/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.util;

import java.text.DateFormat;
import java.util.Calendar;
import org.eclipse.ecf.discovery.IServiceInfo;

public class PrettyPrinter {
    private static final String prompt = "ZooDiscovery> ";
    public static final int PUBLISHED = 1;
    public static final int UNPUBLISHED = 2;
    public static final int ACTIVATED = 3;
    public static final int DEACTIVATED = 4;
    public static final int REMOTE_AVAILABLE = 5;
    public static final int REMOTE_UNAVAILABLE = 6;
    public static final int PUBLISH_DELAYED = 7;
    public static final int UNPUBLISH_DELAYED = 8;

    public static void prompt(int type, IServiceInfo serviceInfo) {
        String token = "";
        String time = String.valueOf(DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime())) + ". ";
        switch (type) {
            case 1: {
                token = "Service Published: ";
                break;
            }
            case 2: {
                token = "Service Unpublished: ";
                break;
            }
            case 3: {
                token = "Discovery Service Activated. ";
                break;
            }
            case 4: {
                token = "Discovery Service Deactivated.";
                break;
            }
            case 7: {
                token = "Service Publication Delayed: ";
                break;
            }
            case 8: {
                token = "Service Unpublication Delayed: ";
                break;
            }
            case 5: {
                token = "Service Discovered: ";
                break;
            }
            case 6: {
                token = "Service Undiscovered: ";
            }
        }
        System.out.println(prompt + token + time + (serviceInfo != null ? serviceInfo : ""));
    }

    public static void attemptingConnectionTo(String ip) {
        System.out.println("ZooDiscovery> INFO - Attempting connection to server: /" + ip);
    }

    public static void connectionLost(String ip) {
        System.out.println("ZooDiscovery> INFO - Connection Lost: /" + ip);
    }
}

