/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.rest.client;

import java.io.File;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.client.IRemoteCallParameter;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.rest.client.AbstractRequestType;

public abstract class AbstractEntityRequestType
extends AbstractRequestType {
    public static final int NO_REQUEST_ENTITY = -1;
    public static final int INPUT_STREAM_REQUEST_ENTITY = 0;
    public static final int STRING_REQUEST_ENTITY = 1;
    public static final int BYTEARRAY_REQUEST_ENTITY = 2;
    public static final int FILE_REQUEST_ENTITY = 3;
    public static final String CHARSET_PARAM_NAME = "charset";
    public static final String CONTENT_TYPE_PARAM_NAME = "contentType";
    public static final String CONTENT_LENGTH_PARAM_NAME = "contentLength";
    protected int requestEntityType = -1;
    protected long defaultContentLength = -2L;
    protected String defaultContentType = null;
    protected String defaultCharset = null;

    public AbstractEntityRequestType(int requestEntityType, String defaultContentType, long defaultContentLength, String defaultCharset, Map defaultRequestHeaders) {
        super(defaultRequestHeaders);
        this.requestEntityType = requestEntityType;
        this.defaultContentType = defaultContentType;
        this.defaultContentLength = defaultContentLength;
        this.defaultCharset = defaultCharset;
    }

    public AbstractEntityRequestType(int requestEntityType, String defaultContentType, long defaultContentLength, String defaultCharset) {
        this(requestEntityType, defaultContentType, defaultContentLength, defaultCharset, null);
    }

    public AbstractEntityRequestType(int requestEntityType, String defaultContentType, long defaultContentLength, Map defaultRequestHeaders) {
        this(requestEntityType, defaultContentType, defaultContentLength, null, defaultRequestHeaders);
    }

    public AbstractEntityRequestType(int requestEntityType, String defaultContentType, long defaultContentLength) {
        this(requestEntityType, defaultContentType, defaultContentLength, (String)null);
    }

    public AbstractEntityRequestType(int requestEntityType, String defaultContentType, Map defaultRequestHeaders) {
        this(requestEntityType, defaultContentType, -2L, null, defaultRequestHeaders);
    }

    public AbstractEntityRequestType(int requestEntityType, String defaultContentType) {
        this(requestEntityType, defaultContentType, null);
    }

    public AbstractEntityRequestType(int requestEntityType, Map defaultRequestHeaders) {
        this(requestEntityType, null, defaultRequestHeaders);
    }

    public AbstractEntityRequestType(Map defaultRequestHeaders) {
        this(-1, defaultRequestHeaders);
    }

    public AbstractEntityRequestType() {
        this(null);
    }

    public boolean useRequestEntity() {
        return this.requestEntityType > -1;
    }

    public RequestEntity generateRequestEntity(String uri, IRemoteCall call, IRemoteCallable callable, IRemoteCallParameter paramDefault, Object paramToSerialize) throws NotSerializableException {
        if (paramToSerialize instanceof RequestEntity) {
            return (RequestEntity)paramToSerialize;
        }
        switch (this.requestEntityType) {
            case 0: {
                if (paramToSerialize instanceof InputStream) {
                    return new InputStreamRequestEntity((InputStream)paramToSerialize, this.getContentLength(call, callable, paramDefault), this.getContentType(call, callable, paramDefault));
                }
                throw new NotSerializableException("Cannot generate request entity.  Expecting InputStream and got class=" + paramToSerialize.getClass().getName());
            }
            case 1: {
                if (paramToSerialize instanceof String) {
                    try {
                        return new StringRequestEntity((String)paramToSerialize, this.getContentType(call, callable, paramDefault), this.getCharset(call, callable, paramDefault));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new NotSerializableException("Could not create request entity from call parameters: " + e.getMessage());
                    }
                }
                throw new NotSerializableException("Cannot generate request entity.  Expecting String and got class=" + paramToSerialize.getClass().getName());
            }
            case 2: {
                if (paramToSerialize instanceof byte[]) {
                    return new ByteArrayRequestEntity((byte[])paramToSerialize, this.getContentType(call, callable, paramDefault));
                }
                throw new NotSerializableException("Cannot generate request entity.  Expecting byte[] and got class=" + paramToSerialize.getClass().getName());
            }
            case 3: {
                if (paramToSerialize instanceof File) {
                    return new FileRequestEntity((File)paramToSerialize, this.getContentType(call, callable, paramDefault));
                }
                throw new NotSerializableException("Remote call parameter with name=" + paramDefault.getName() + " is incorrect type for creating request entity.");
            }
        }
        throw new NotSerializableException("Request entity generation not supported for this request type");
    }

    protected String getCharset(IRemoteCall call, IRemoteCallable callable, IRemoteCallParameter paramDefault) {
        IRemoteCallParameter[] defaultParameters = callable.getDefaultParameters();
        Object[] parameters = call.getParameters();
        if (defaultParameters != null) {
            int i = 0;
            while (i < defaultParameters.length) {
                if (CHARSET_PARAM_NAME.equals(defaultParameters[i].getName())) {
                    Object o;
                    Object object = o = parameters != null && parameters.length > i ? parameters[i] : defaultParameters[i].getValue();
                    if (o instanceof String) {
                        return (String)o;
                    }
                }
                ++i;
            }
        }
        return this.defaultCharset;
    }

    protected long getContentLength(IRemoteCall call, IRemoteCallable callable, IRemoteCallParameter paramDefault) {
        IRemoteCallParameter[] defaultParameters = callable.getDefaultParameters();
        Object[] parameters = call.getParameters();
        if (defaultParameters != null) {
            int i = 0;
            while (i < defaultParameters.length) {
                if (CONTENT_LENGTH_PARAM_NAME.equals(defaultParameters[i].getName())) {
                    Object o;
                    Object object = o = parameters != null && parameters.length > i ? parameters[i] : defaultParameters[i].getValue();
                    if (o instanceof Number) {
                        return ((Number)o).longValue();
                    }
                    if (o instanceof String) {
                        try {
                            return Integer.parseInt((String)o);
                        }
                        catch (NumberFormatException e) {
                            return -2L;
                        }
                    }
                }
                ++i;
            }
        }
        return this.defaultContentLength;
    }

    protected String getContentType(IRemoteCall call, IRemoteCallable callable, IRemoteCallParameter paramDefault) {
        IRemoteCallParameter[] defaultParameters = callable.getDefaultParameters();
        Object[] parameters = call.getParameters();
        if (defaultParameters != null) {
            int i = 0;
            while (i < defaultParameters.length) {
                if (CONTENT_TYPE_PARAM_NAME.equals(defaultParameters[i].getName())) {
                    Object o;
                    Object object = o = parameters != null && parameters.length > i ? parameters[i] : defaultParameters[i].getValue();
                    if (o instanceof String) {
                        return (String)o;
                    }
                }
                ++i;
            }
        }
        return this.defaultContentType;
    }
}

