/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.dialogs.CommitSelectDialog;
import org.eclipse.egit.ui.internal.dialogs.CompareTreeView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareWithPreviousActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        IResource[] resources = this.getSelectedResources(event);
        if (resources.length == 1) {
            JobUtil.scheduleUserJob((IEGitOperation)new CompareWithPreviousOperation(event, repository, resources[0]), (String)UIText.CompareWithPreviousActionHandler_TaskGeneratingInput, null);
        }
        return null;
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.getSelectedResources().length == 1;
    }

    private class CompareWithPreviousOperation
    implements IEGitOperation {
        private ExecutionEvent event;
        private Repository repository;
        private IResource resource;

        private CompareWithPreviousOperation(ExecutionEvent event, Repository repository, IResource resource) {
            this.event = event;
            this.repository = repository;
            this.resource = resource;
        }

        public void execute(IProgressMonitor monitor) throws CoreException {
            List<RepositoryActionHandler.PreviousCommit> previousList;
            try {
                previousList = CompareWithPreviousActionHandler.this.findPreviousCommits();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
                return;
            }
            final AtomicReference<RepositoryActionHandler.PreviousCommit> previous = new AtomicReference<RepositoryActionHandler.PreviousCommit>();
            if (previousList.size() == 0) {
                this.showNotFoundDialog();
                return;
            }
            if (previousList.size() > 1) {
                final ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
                for (RepositoryActionHandler.PreviousCommit pc : previousList) {
                    commits.add(pc.commit);
                }
                HandlerUtil.getActiveShell((ExecutionEvent)this.event).getDisplay().syncExec(new Runnable(){

                    public void run() {
                        CommitSelectDialog dlg = new CommitSelectDialog(HandlerUtil.getActiveShell((ExecutionEvent)CompareWithPreviousOperation.this.event), commits);
                        if (dlg.open() == 0) {
                            for (RepositoryActionHandler.PreviousCommit pc : previousList) {
                                if (!pc.commit.equals((AnyObjectId)dlg.getSelectedCommit())) continue;
                                previous.set(pc);
                                break;
                            }
                        }
                    }
                });
            } else {
                previous.set(previousList.get(0));
            }
            if (previous.get() == null) {
                return;
            }
            if (this.resource instanceof IFile) {
                RepositoryActionHandler.PreviousCommit pc;
                ITypedElement base = SaveableCompareEditorInput.createFileElement((IFile)((IFile)this.resource));
                pc = (RepositoryActionHandler.PreviousCommit)previous.get();
                ITypedElement next = CompareUtils.getFileRevisionTypedElement(pc.path, pc.commit, this.repository);
                GitCompareFileRevisionEditorInput input = new GitCompareFileRevisionEditorInput(base, next, null);
                CompareUI.openCompareEditor((CompareEditorInput)input);
            } else {
                this.openCompareTreeView(((RepositoryActionHandler.PreviousCommit)previous.get()).commit);
            }
        }

        private void openCompareTreeView(final RevCommit previous) {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)this.event);
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        CompareTreeView view = (CompareTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.CompareTreeView");
                        view.setInput(new IResource[]{CompareWithPreviousOperation.this.resource}, previous.name());
                    }
                    catch (PartInitException e) {
                        Activator.handleError(e.getMessage(), e, true);
                    }
                }
            });
        }

        private void showNotFoundDialog() {
            final Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)this.event);
            final String message = MessageFormat.format(UIText.CompareWithPreviousActionHandler_MessageRevisionNotFound, this.resource.getName());
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openWarning((Shell)shell, (String)UIText.CompareWithPreviousActionHandler_TitleRevisionNotFound, (String)message);
                }
            });
        }

        public ISchedulingRule getSchedulingRule() {
            return this.resource;
        }
    }
}

