/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.dialogs.AbstractBranchSelectionDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ResetTargetSelectionDialog
extends AbstractBranchSelectionDialog {
    private ResetCommand.ResetType resetType = ResetCommand.ResetType.MIXED;

    public ResetTargetSelectionDialog(Shell parentShell, Repository repo) {
        super(parentShell, repo, 126);
        super.setHelpAvailable(false);
    }

    protected void createCustomArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)main);
        Group g = new Group(main, 0);
        g.setText(UIText.ResetTargetSelectionDialog_ResetTypeGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)g);
        g.setLayout((Layout)new GridLayout(1, false));
        Button soft = new Button((Composite)g, 16);
        soft.setText(UIText.ResetTargetSelectionDialog_ResetTypeSoftButton);
        soft.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    ResetTargetSelectionDialog.this.resetType = ResetCommand.ResetType.SOFT;
                }
            }
        });
        Button medium = new Button((Composite)g, 16);
        medium.setSelection(true);
        medium.setText(UIText.ResetTargetSelectionDialog_ResetTypeMixedButton);
        medium.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    ResetTargetSelectionDialog.this.resetType = ResetCommand.ResetType.MIXED;
                }
            }
        });
        Button hard = new Button((Composite)g, 16);
        hard.setText(UIText.ResetTargetSelectionDialog_ResetTypeHardButton);
        hard.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    ResetTargetSelectionDialog.this.resetType = ResetCommand.ResetType.HARD;
                }
            }
        });
    }

    protected void refNameSelected(String refName) {
        this.getButton(0).setEnabled(refName != null);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(UIText.ResetTargetSelectionDialog_ResetButton);
    }

    protected String getTitle() {
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repo);
        return NLS.bind((String)UIText.ResetTargetSelectionDialog_ResetTitle, (Object)repoName);
    }

    protected String getWindowTitle() {
        return UIText.ResetTargetSelectionDialog_WindowTitle;
    }

    public ResetCommand.ResetType getResetType() {
        return this.resetType;
    }

    protected void okPressed() {
        if (this.resetType == ResetCommand.ResetType.HARD && !MessageDialog.openQuestion((Shell)this.getShell(), (String)UIText.ResetTargetSelectionDialog_ResetQuestion, (String)UIText.ResetTargetSelectionDialog_ResetConfirmQuestion)) {
            return;
        }
        super.okPressed();
    }

    protected String getMessageText() {
        return UIText.ResetTargetSelectionDialog_SelectBranchForResetMessage;
    }
}

