/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DeleteRepositoryConfirmDialog
extends TitleAreaDialog {
    private final Repository repository;
    private boolean shouldDelete = false;
    private boolean shouldRemoveProjects = false;
    private int numberOfProjects = 0;

    public DeleteRepositoryConfirmDialog(Shell parentShell, Repository repository, int numberOfProjects) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.repository = repository;
        this.numberOfProjects = numberOfProjects;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        main.setLayout((Layout)new GridLayout(1, false));
        if (this.repository.isBare()) {
            return main;
        }
        final Button deleteWorkDir = new Button(main, 32);
        final Button removeProjects = new Button(main, 32);
        deleteWorkDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeleteRepositoryConfirmDialog.this.shouldDelete = deleteWorkDir.getSelection();
                removeProjects.setEnabled(!DeleteRepositoryConfirmDialog.this.shouldDelete);
                if (DeleteRepositoryConfirmDialog.this.shouldDelete && DeleteRepositoryConfirmDialog.this.numberOfProjects > 0) {
                    removeProjects.setSelection(true);
                    DeleteRepositoryConfirmDialog.this.shouldRemoveProjects = true;
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)deleteWorkDir);
        deleteWorkDir.setText(NLS.bind((String)UIText.DeleteRepositoryConfirmDialog_DeleteWorkingDirectoryCheckbox, (Object)this.repository.getWorkTree().getPath()));
        if (this.numberOfProjects > 0) {
            removeProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeleteRepositoryConfirmDialog.this.shouldRemoveProjects = removeProjects.getSelection();
                }
            });
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)removeProjects);
            removeProjects.setText(NLS.bind((String)UIText.RepositoriesView_ConfirmProjectDeletion_Question, (Object)this.numberOfProjects));
        } else {
            removeProjects.setVisible(false);
        }
        return main;
    }

    public void create() {
        super.create();
        this.setTitle(NLS.bind((String)UIText.DeleteRepositoryConfirmDialog_DeleteRepositoryTitle, (Object)this.repository.getDirectory().getPath()));
        this.setMessage(NLS.bind((String)UIText.DeleteRepositoryConfirmDialog_DeleteRepositoryMessage, (Object)this.repository.getDirectory().getPath()));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.DeleteRepositoryConfirmDialog_DeleteRepositoryWindowTitle);
    }

    public boolean shouldDeleteWorkingDir() {
        return this.shouldDelete;
    }

    public boolean shouldRemoveProjects() {
        return this.shouldRemoveProjects;
    }
}

