/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.util;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.internal.common.protocol.CDODataInputImpl;
import org.eclipse.emf.cdo.internal.common.protocol.CDODataOutputImpl;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

public final class CDOCommonUtil {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss'.'SSS");

    private CDOCommonUtil() {
    }

    public static CDODataInput createCDODataInput(ExtendedDataInputStream inputStream, final CDOPackageRegistry packageRegistry, final CDOBranchManager branchManager, final CDOCommitInfoManager commitManager, final CDORevisionFactory revisionFactory, final CDOListFactory listFactory, final CDOLobStore lobStore) throws IOException {
        return new CDODataInputImpl((ExtendedDataInput)inputStream){

            protected CDOPackageRegistry getPackageRegistry() {
                return packageRegistry;
            }

            protected CDOBranchManager getBranchManager() {
                return branchManager;
            }

            protected CDOCommitInfoManager getCommitInfoManager() {
                return commitManager;
            }

            protected CDORevisionFactory getRevisionFactory() {
                return revisionFactory;
            }

            protected CDOListFactory getListFactory() {
                return listFactory;
            }

            protected CDOLobStore getLobStore() {
                return lobStore;
            }
        };
    }

    public static CDODataOutput createCDODataOutput(ExtendedDataOutput extendedDataOutputStream, final CDOPackageRegistry packageRegistry, final CDOIDProvider idProvider) {
        return new CDODataOutputImpl(extendedDataOutputStream){

            public CDOPackageRegistry getPackageRegistry() {
                return packageRegistry;
            }

            public CDOIDProvider getIDProvider() {
                return idProvider;
            }
        };
    }

    public static boolean isValidTimeStamp(long timeStamp, long startTime, long endTime) {
        if (timeStamp == 0L) {
            return endTime == 0L;
        }
        return (endTime == 0L || endTime >= timeStamp) && timeStamp >= startTime;
    }

    public static int compareTimeStamps(long t1, long t2) {
        if (t1 == 0L) {
            t1 = Long.MAX_VALUE;
        }
        if (t2 == 0L) {
            t2 = Long.MAX_VALUE;
        }
        return t1 < t2 ? -1 : (t1 == t2 ? 0 : 1);
    }

    public static String formatTimeStamp() {
        return CDOCommonUtil.formatTimeStamp(System.currentTimeMillis());
    }

    public static String formatTimeStamp(long timeStamp) {
        if (timeStamp == 0L) {
            return "*";
        }
        return DATE_FORMAT.format(new Date(timeStamp));
    }

    public static long parseTimeStamp(String timeStamp) throws ParseException {
        if ("*".equals(timeStamp)) {
            return 0L;
        }
        return DATE_FORMAT.parse(timeStamp).getTime();
    }
}

