/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.lock;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.spi.common.lock.InternalCDOLockState;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOLockStateImpl
implements InternalCDOLockState {
    private final Object lockedObject;
    private final Set<CDOLockOwner> readLockOwners = new HashSet<CDOLockOwner>();
    private CDOLockOwner writeLockOwner;
    private CDOLockOwner writeOptionOwner;

    public CDOLockStateImpl(Object lockedObject) {
        CheckUtil.checkArg((Object)lockedObject, (String)"lockedObject");
        CheckUtil.checkState((lockedObject instanceof CDOID || lockedObject instanceof CDOIDAndBranch ? 1 : 0) != 0, (String)"lockedObject is of wrong type");
        this.lockedObject = lockedObject;
    }

    public CDOLockStateImpl copy() {
        CDOLockStateImpl newLockState = new CDOLockStateImpl(this.lockedObject);
        for (CDOLockOwner owner : this.readLockOwners) {
            newLockState.readLockOwners.add(owner);
        }
        newLockState.writeLockOwner = this.writeLockOwner;
        newLockState.writeOptionOwner = this.writeOptionOwner;
        return newLockState;
    }

    @Override
    public boolean isLocked(IRWLockManager.LockType lockType, CDOLockOwner lockOwner, boolean others) {
        switch (lockType) {
            case READ: {
                return this.isReadLocked(lockOwner, others);
            }
            case WRITE: {
                return this.isWriteLocked(lockOwner, others);
            }
            case OPTION: {
                return this.isOptionLocked(lockOwner, others);
            }
        }
        return false;
    }

    private boolean isReadLocked(CDOLockOwner by, boolean others) {
        int n = this.readLockOwners.size();
        if (n == 0) {
            return false;
        }
        if (!others) {
            return this.readLockOwners.contains(by);
        }
        return true;
    }

    private boolean isWriteLocked(CDOLockOwner by, boolean others) {
        if (this.writeLockOwner == null) {
            return false;
        }
        return this.writeLockOwner.equals(by) ^ others;
    }

    private boolean isOptionLocked(CDOLockOwner by, boolean others) {
        if (this.writeOptionOwner == null) {
            return false;
        }
        return this.writeOptionOwner.equals(by) ^ others;
    }

    @Override
    public Set<CDOLockOwner> getReadLockOwners() {
        return Collections.unmodifiableSet(this.readLockOwners);
    }

    @Override
    public void addReadLockOwner(CDOLockOwner lockOwner) {
        this.readLockOwners.add(lockOwner);
    }

    @Override
    public boolean removeReadLockOwner(CDOLockOwner lockOwner) {
        return this.readLockOwners.remove(lockOwner);
    }

    @Override
    public CDOLockOwner getWriteLockOwner() {
        return this.writeLockOwner;
    }

    @Override
    public void setWriteLockOwner(CDOLockOwner lockOwner) {
        this.writeLockOwner = lockOwner;
    }

    @Override
    public CDOLockOwner getWriteOptionOwner() {
        return this.writeOptionOwner;
    }

    @Override
    public void setWriteOptionOwner(CDOLockOwner lockOwner) {
        this.writeOptionOwner = lockOwner;
    }

    @Override
    public Object getLockedObject() {
        return this.lockedObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CDOLockState\nlockedObject=");
        builder.append(this.lockedObject);
        builder.append("\nreadLockOwners=");
        if (this.readLockOwners.size() > 0) {
            boolean first = true;
            for (CDOLockOwner lockOwner : this.readLockOwners) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(lockOwner);
            }
            builder.deleteCharAt(builder.length() - 1);
        } else {
            builder.append("NONE");
        }
        builder.append("\nwriteLockOwner=");
        builder.append(this.writeLockOwner != null ? this.writeLockOwner : "NONE");
        builder.append("\nwriteOptionOwner=");
        builder.append(this.writeOptionOwner != null ? this.writeOptionOwner : "NONE");
        return builder.toString();
    }
}

