/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.examples.acore.graphiti.features;

import org.eclipse.emf.cdo.dawn.examples.acore.ABasicClass;
import org.eclipse.emf.cdo.dawn.examples.acore.graphiti.util.DawnGraphitiAcoreResourceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;

public abstract class AcoreBasicAddElementFeature
extends AbstractAddShapeFeature {
    public AcoreBasicAddElementFeature(IFeatureProvider fp) {
        super(fp);
    }

    public abstract boolean canAdd(IAddContext var1);

    protected abstract Color getBackgroundColor();

    protected abstract Color getForegroundColor();

    public PictogramElement add(IAddContext context) {
        ABasicClass addedClass = (ABasicClass)context.getNewObject();
        Diagram targetDiagram = (Diagram)context.getTargetContainer();
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        int width = 100;
        int height = 50;
        IGaService gaService = Graphiti.getGaService();
        this.addToResourceIfNeeded(addedClass);
        ContainerShape containerShape = this.createContainerShape(context, addedClass, targetDiagram, peCreateService, width, height, gaService);
        return containerShape;
    }

    private ContainerShape createContainerShape(IAddContext context, ABasicClass addedClass, Diagram targetDiagram, IPeCreateService peCreateService, int width, int height, IGaService gaService) {
        ContainerShape containerShape = peCreateService.createContainerShape((ContainerShape)targetDiagram, true);
        RoundedRectangle roundedRectangle = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)containerShape, 5, 5);
        roundedRectangle.setForeground(this.getForegroundColor());
        roundedRectangle.setBackground(this.getBackgroundColor());
        roundedRectangle.setLineWidth(Integer.valueOf(2));
        gaService.setLocationAndSize((GraphicsAlgorithm)roundedRectangle, context.getX(), context.getY(), width, height);
        this.link((PictogramElement)containerShape, addedClass);
        Shape shape = peCreateService.createShape(containerShape, false);
        int[] nArray = new int[4];
        nArray[1] = 20;
        nArray[2] = width;
        nArray[3] = 20;
        Polyline polyline = gaService.createPolyline((GraphicsAlgorithmContainer)shape, nArray);
        polyline.setForeground(this.getForegroundColor());
        polyline.setLineWidth(Integer.valueOf(2));
        shape = peCreateService.createShape(containerShape, false);
        Text text = gaService.createText((GraphicsAlgorithmContainer)shape, addedClass.getName());
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        gaService.setLocationAndSize((GraphicsAlgorithm)text, 0, 0, width, 20);
        this.link((PictogramElement)shape, addedClass);
        this.activateDirectEditing(containerShape, shape, text);
        peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
        BoxRelativeAnchor boxAnchor = peCreateService.createBoxRelativeAnchor((AnchorContainer)containerShape);
        boxAnchor.setRelativeWidth(1.0);
        boxAnchor.setRelativeHeight(0.5);
        boxAnchor.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)roundedRectangle);
        Rectangle rectangle = gaService.createRectangle((GraphicsAlgorithmContainer)boxAnchor);
        rectangle.setFilled(Boolean.valueOf(true));
        int w = 6;
        gaService.setLocationAndSize((GraphicsAlgorithm)rectangle, -2 * w, -w, 2 * w, 2 * w);
        rectangle.setForeground(this.getForegroundColor());
        rectangle.setBackground(this.getBackgroundColor());
        this.layoutPictogramElement((PictogramElement)containerShape);
        return containerShape;
    }

    private void activateDirectEditing(ContainerShape containerShape, Shape shape, Text text) {
        IDirectEditingInfo directEditingInfo = this.getFeatureProvider().getDirectEditingInfo();
        directEditingInfo.setMainPictogramElement((PictogramElement)containerShape);
        directEditingInfo.setPictogramElement((PictogramElement)shape);
        directEditingInfo.setGraphicsAlgorithm((GraphicsAlgorithm)text);
    }

    private void addToResourceIfNeeded(ABasicClass addedClass) {
        if (addedClass.eResource() == null) {
            DawnGraphitiAcoreResourceUtil.addToModelResource((EObject)addedClass, this.getDiagram().eResource().getResourceSet());
        }
    }
}

