/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.efs;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.internal.efs.CDOFileRoot;
import org.eclipse.emf.cdo.internal.efs.InfiniteProgress;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionConfiguration;
import org.eclipse.emf.cdo.util.CDOURIData;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;

public abstract class CDOFileSystem
extends FileSystem {
    private Map<Pair<String, String>, CDOSession> sessions = new HashMap<Pair<String, String>, CDOSession>();
    private Map<URI, CDOView> views = new HashMap<URI, CDOView>();

    protected CDOFileSystem() {
    }

    public int attributes() {
        return 0x30000000;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public IFileStore getStore(URI uri) {
        CDOURIData data = new CDOURIData(uri.toString());
        String authority = data.getAuthority();
        String repositoryName = data.getRepositoryName();
        IPath path = data.getResourcePath();
        IPath branchPath = data.getBranchPath();
        long timeStamp = data.getTimeStamp();
        CDOFileRoot root = new CDOFileRoot(this, authority, repositoryName, branchPath, timeStamp);
        if (path.isEmpty()) {
            return root;
        }
        return root.getFileStore(path);
    }

    public CDOView getView(CDOFileRoot root, IProgressMonitor monitor) {
        URI uri = root.toURI();
        CDOView view = this.views.get(uri);
        if (view == null) {
            view = this.openView(root, monitor);
            this.views.put(uri, view);
        }
        return view;
    }

    protected CDOView openView(CDOFileRoot root, IProgressMonitor monitor) {
        String authority = root.getAuthority();
        String repositoryName = root.getRepositoryName();
        String branchPath = root.getBranchPath().toPortableString();
        final long timeStamp = root.getTimeStamp();
        final CDOSession session = this.getSession(authority, repositoryName, monitor);
        final CDOBranch branch = session.getBranchManager().getBranch(branchPath);
        return InfiniteProgress.call("Open view", new Callable<CDOView>(){

            @Override
            public CDOView call() throws Exception {
                return session.openView(branch, timeStamp);
            }
        });
    }

    protected CDOSession getSession(String authority, String repositoryName, IProgressMonitor monitor) {
        Pair sessionKey = new Pair((Object)authority, (Object)repositoryName);
        CDOSession session = this.sessions.get(sessionKey);
        if (session == null) {
            final CDOSessionConfiguration configuration = this.createSessionConfiguration(authority, repositoryName, monitor);
            session = InfiniteProgress.call("Open session", new Callable<CDOSession>(){

                @Override
                public CDOSession call() throws Exception {
                    return configuration.openSession();
                }
            });
            this.sessions.put((Pair<String, String>)sessionKey, session);
        }
        return session;
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    protected abstract CDOSessionConfiguration createSessionConfiguration(String var1, String var2, IProgressMonitor var3);

    public static abstract class Net4j
    extends CDOFileSystem {
        private String connectorType;

        protected Net4j(String connectorType) {
            this.connectorType = connectorType;
        }

        protected IConnector getConnector(final String authority, IProgressMonitor monitor) {
            return InfiniteProgress.call("Open connection", new Callable<IConnector>(){

                @Override
                public IConnector call() throws Exception {
                    return Net4jUtil.getConnector((IManagedContainer)Net4j.this.getContainer(), (String)Net4j.this.connectorType, (String)authority);
                }
            });
        }

        protected CDOSessionConfiguration createSessionConfiguration(String authority, String repositoryName, IProgressMonitor monitor) {
            CDONet4jSessionConfiguration configuration = CDONet4jUtil.createNet4jSessionConfiguration();
            configuration.setConnector(this.getConnector(authority, monitor));
            configuration.setRepositoryName(repositoryName);
            return configuration;
        }

        public static class TCP
        extends Net4j {
            public TCP() {
                super("tcp");
            }
        }
    }
}

