/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.admin.protocol;

import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.server.internal.admin.CDOAdminServer;
import org.eclipse.emf.cdo.server.internal.admin.CDOAdminServerRepository;
import org.eclipse.emf.cdo.server.internal.admin.protocol.CreateRepositoryIndication;
import org.eclipse.emf.cdo.server.internal.admin.protocol.DeleteRepositoryIndication;
import org.eclipse.emf.cdo.server.internal.admin.protocol.QueryRepositoriesIndication;
import org.eclipse.emf.cdo.server.internal.admin.protocol.RepositoryAddedRequest;
import org.eclipse.emf.cdo.server.internal.admin.protocol.RepositoryRemovedRequest;
import org.eclipse.emf.cdo.server.internal.admin.protocol.RepositoryReplicationPogressedRequest;
import org.eclipse.emf.cdo.server.internal.admin.protocol.RepositoryStateChangedRequest;
import org.eclipse.emf.cdo.server.internal.admin.protocol.RepositoryTypeChangedRequest;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.spi.net4j.ServerProtocolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOAdminServerProtocol
extends SignalProtocol<CDOAdminServer> {
    private final IManagedContainer container;

    public CDOAdminServerProtocol(IManagedContainer container, CDOAdminServer admin) {
        super("cdo-admin");
        this.container = container;
        this.setInfraStructure((Object)admin);
        admin.registerProtocol(this);
    }

    public final IManagedContainer getContainer() {
        return this.container;
    }

    public void sendRepositoryAdded(CDOAdminServerRepository repository) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new RepositoryAddedRequest(this, repository).sendAsync();
        }
    }

    public void sendRepositoryRemoved(String name) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new RepositoryRemovedRequest(this, name).sendAsync();
        }
    }

    public void sendRepositoryTypeChanged(String name, CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new RepositoryTypeChangedRequest(this, name, oldType, newType).sendAsync();
        }
    }

    public void sendRepositoryStateChanged(String name, CDOCommonRepository.State oldState, CDOCommonRepository.State newState) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new RepositoryStateChangedRequest(this, name, oldState, newState).sendAsync();
        }
    }

    public void sendRepositoryReplicationProgressed(String name, double totalWork, double work) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new RepositoryReplicationPogressedRequest(this, name, totalWork, work).sendAsync();
        }
    }

    protected SignalReactor createSignalReactor(short signalID) {
        switch (signalID) {
            case 1: {
                return new QueryRepositoriesIndication(this);
            }
            case 2: {
                return new CreateRepositoryIndication(this);
            }
            case 3: {
                return new DeleteRepositoryIndication(this);
            }
        }
        return super.createSignalReactor(signalID);
    }

    protected void doDeactivate() throws Exception {
        ((CDOAdminServer)((Object)this.getInfraStructure())).deregisterProtocol(this);
        super.doDeactivate();
    }

    public static class Factory
    extends ServerProtocolFactory {
        public static final String TYPE = "cdo-admin";
        private IManagedContainer container;

        public Factory(IManagedContainer container) {
            super(TYPE);
            this.container = container;
        }

        public IManagedContainer getContainer() {
            return this.container;
        }

        public CDOAdminServerProtocol create(String description) {
            CDOAdminServer admin = this.getAdmin();
            return new CDOAdminServerProtocol(this.container, admin);
        }

        protected CDOAdminServer getAdmin() {
            String productGroup = "org.eclipse.emf.cdo.server.admin.adminServers";
            String type = "default";
            return (CDOAdminServer)((Object)this.container.getElement(productGroup, type, null));
        }

        public static CDOAdminServerProtocol get(IManagedContainer container, String description) {
            return (CDOAdminServerProtocol)((Object)container.getElement("org.eclipse.net4j.serverProtocols", TYPE, description));
        }

        public static final class Plugin
        extends Factory {
            public Plugin() {
                super((IManagedContainer)IPluginContainer.INSTANCE);
            }
        }
    }
}

