/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class ExternalReferenceManager
extends Lifecycle {
    private static final int NULL = 0;
    private IDBTable table;
    private IDBField idField;
    private IDBField uriField;
    private IDBField timestampField;
    private final IIDHandler idHandler;
    private AtomicLong lastMappedID = new AtomicLong(0L);
    @ReflectUtil.ExcludeFromDump
    private transient String sqlSelectByLongID;
    @ReflectUtil.ExcludeFromDump
    private transient String sqlSelectByURI;
    @ReflectUtil.ExcludeFromDump
    private transient String sqlInsert;

    public ExternalReferenceManager(IIDHandler idHandler) {
        this.idHandler = idHandler;
    }

    public IIDHandler getIDHandler() {
        return this.idHandler;
    }

    public long mapExternalReference(CDOIDExternal id, long commitTime) {
        IDBStoreAccessor accessor = ExternalReferenceManager.getAccessor();
        return this.mapURI(accessor, id.getURI(), commitTime);
    }

    public CDOIDExternal unmapExternalReference(long mappedId) {
        IDBStoreAccessor accessor = ExternalReferenceManager.getAccessor();
        return CDOIDUtil.createExternal((String)this.unmapURI(accessor, mappedId));
    }

    public long mapURI(IDBStoreAccessor accessor, String uri, long commitTime) {
        long result = this.lookupByURI(accessor, uri);
        if (result < 0L) {
            return result;
        }
        return this.insertNew(accessor, uri, commitTime);
    }

    public String unmapURI(IDBStoreAccessor accessor, long mappedId) {
        String string;
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = statementCache.getPreparedStatement(this.sqlSelectByLongID, IPreparedStatementCache.ReuseProbability.HIGH);
            stmt.setLong(1, mappedId);
            resultSet = stmt.executeQuery();
            if (!resultSet.next()) {
                OM.LOG.error("External ID " + mappedId + " not found. Database inconsistent!");
                throw new IllegalStateException("External ID " + mappedId + " not found. Database inconsistent!");
            }
            string = resultSet.getString(1);
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(stmt);
        return string;
    }

    public void rawExport(Connection connection, CDODataOutput out, long fromCommitTime, long toCommitTime) throws IOException {
        String where = " WHERE " + this.timestampField + " BETWEEN " + fromCommitTime + " AND " + toCommitTime;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)this.table, null, (String)where);
    }

    public void rawImport(Connection connection, CDODataInput in, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)this.table, (OMMonitor)monitor);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        IDBStore store = this.idHandler.getStore();
        this.table = store.getDBSchema().addTable("cdo_external_refs");
        this.idField = this.table.addField("id", this.idHandler.getDBType());
        this.uriField = this.table.addField("uri", DBType.VARCHAR, 1024);
        this.timestampField = this.table.addField("committime", DBType.BIGINT);
        this.table.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.idField});
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{this.uriField});
        IDBStoreAccessor writer = store.getWriter(null);
        Connection connection = writer.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                statement = connection.createStatement();
                store.getDBAdapter().createTable(this.table, statement);
                connection.commit();
                String sql = "SELECT MIN(" + this.idField + ") FROM " + this.table;
                resultSet = statement.executeQuery(sql);
                if (resultSet.next()) {
                    this.lastMappedID.set(resultSet.getLong(1));
                }
            }
            catch (SQLException ex) {
                connection.rollback();
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)statement);
            writer.release();
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)statement);
        writer.release();
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.table);
        builder.append("(");
        builder.append(this.idField);
        builder.append(",");
        builder.append(this.uriField);
        builder.append(",");
        builder.append(this.timestampField);
        builder.append(") VALUES (?, ?, ?)");
        this.sqlInsert = builder.toString();
        builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.idField);
        builder.append(" FROM ");
        builder.append(this.table);
        builder.append(" WHERE ");
        builder.append(this.uriField);
        builder.append("=?");
        this.sqlSelectByURI = builder.toString();
        builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.uriField);
        builder.append(" FROM ");
        builder.append(this.table);
        builder.append(" WHERE ");
        builder.append(this.idField);
        builder.append("=?");
        this.sqlSelectByLongID = builder.toString();
    }

    private long insertNew(IDBStoreAccessor accessor, String uri, long commitTime) {
        long newMappedID = this.lastMappedID.decrementAndGet();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            stmt = statementCache.getPreparedStatement(this.sqlInsert, IPreparedStatementCache.ReuseProbability.MEDIUM);
            stmt.setLong(1, newMappedID);
            stmt.setString(2, uri);
            stmt.setLong(3, commitTime);
            DBUtil.update((PreparedStatement)stmt, (boolean)true);
            long l = newMappedID;
            statementCache.releasePreparedStatement(stmt);
            return l;
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
        }
    }

    private long lookupByURI(IDBStoreAccessor accessor, String uri) {
        ResultSet resultSet;
        PreparedStatement stmt;
        IPreparedStatementCache statementCache;
        block4: {
            long l;
            statementCache = accessor.getStatementCache();
            stmt = null;
            resultSet = null;
            try {
                stmt = statementCache.getPreparedStatement(this.sqlSelectByURI, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setString(1, uri);
                resultSet = stmt.executeQuery();
                if (!resultSet.next()) break block4;
                l = resultSet.getLong(1);
            }
            catch (SQLException e) {
                try {
                    throw new DBException((Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtil.close(resultSet);
                    statementCache.releasePreparedStatement(stmt);
                    throw throwable;
                }
            }
            DBUtil.close((ResultSet)resultSet);
            statementCache.releasePreparedStatement(stmt);
            return l;
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(stmt);
        return 0L;
    }

    private static IDBStoreAccessor getAccessor() {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        if (accessor == null) {
            throw new IllegalStateException("Can only be called from within a valid IDBStoreAccessor context");
        }
        return (IDBStoreAccessor)accessor;
    }
}

