/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractListTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalNonAuditMappingStrategy;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class NonAuditListTableMapping
extends AbstractListTableMapping
implements IListMappingDeltaSupport {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, NonAuditListTableMapping.class);
    private AbstractListTableMapping.FieldInfo[] keyFields;
    private static final int UNBOUNDED_SHIFT = -1;
    private String sqlClear;
    private String sqlUpdateValue;
    private String sqlUpdateIndex;
    private String sqlInsertValue;
    private String sqlDeleteItem;
    private String sqlShiftDownIndex;
    private String sqlReadCurrentIndexOffset;
    private String sqlShiftUpIndex;

    public NonAuditListTableMapping(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
        this.initSQLStrings();
    }

    private void initSQLStrings() {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("cdo_source");
        builder.append("=? ");
        this.sqlClear = builder.toString();
        builder.append(" AND ");
        builder.append("cdo_idx");
        builder.append("=? ");
        this.sqlDeleteItem = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("cdo_value");
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append("cdo_source");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=? ");
        this.sqlUpdateValue = builder.toString();
        builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getTable());
        builder.append(" (");
        builder.append("cdo_source");
        builder.append(", ");
        builder.append("cdo_idx");
        builder.append(", ");
        builder.append("cdo_value");
        builder.append(") VALUES(?, ?, ?) ");
        this.sqlInsertValue = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("cdo_idx");
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append("cdo_source");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=? ");
        this.sqlUpdateIndex = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("cdo_idx");
        builder.append("=");
        builder.append("cdo_idx");
        builder.append("+? WHERE ");
        builder.append("cdo_source");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append(" BETWEEN ? AND ?");
        builder.append("/*! ORDER BY ");
        builder.append("cdo_idx");
        this.sqlShiftDownIndex = String.valueOf(builder.toString()) + " */";
        builder.append(" DESC");
        this.sqlShiftUpIndex = String.valueOf(builder.toString()) + " */";
        builder = new StringBuilder();
        builder.append("SELECT MIN(");
        builder.append("cdo_idx");
        builder.append(") FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("cdo_source");
        builder.append("=?");
        this.sqlReadCurrentIndexOffset = builder.toString();
    }

    public void addSimpleChunkWhere(IDBStoreAccessor accessor, CDOID cdoid, StringBuilder builder, int index) {
        int offset = this.getCurrentIndexOffset(accessor, cdoid);
        super.addSimpleChunkWhere(accessor, cdoid, builder, index + offset);
    }

    public void addRangedChunkWhere(IDBStoreAccessor accessor, CDOID cdoid, StringBuilder builder, int fromIndex, int toIndex) {
        int offset = this.getCurrentIndexOffset(accessor, cdoid);
        super.addRangedChunkWhere(accessor, cdoid, builder, fromIndex + offset, toIndex + offset);
    }

    protected AbstractListTableMapping.FieldInfo[] getKeyFields() {
        if (this.keyFields == null) {
            DBType dbType = this.getMappingStrategy().getStore().getIDHandler().getDBType();
            this.keyFields = new AbstractListTableMapping.FieldInfo[]{new AbstractListTableMapping.FieldInfo("cdo_source", dbType)};
        }
        return this.keyFields;
    }

    protected void setKeyFields(PreparedStatement stmt, CDORevision revision) throws SQLException {
        this.getMappingStrategy().getStore().getIDHandler().setCDOID(stmt, 1, revision.getID());
    }

    public void objectDetached(IDBStoreAccessor accessor, CDOID id, long revised) {
        this.clearList(accessor, id);
    }

    public void clearList(IDBStoreAccessor accessor, CDOID id) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlClear, IPreparedStatementCache.ReuseProbability.HIGH);
                this.getMappingStrategy().getStore().getIDHandler().setCDOID(stmt, 1, id);
                DBUtil.update((PreparedStatement)stmt, (boolean)false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    public int getCurrentIndexOffset(IDBStoreAccessor accessor, CDOID id) {
        int n;
        ResultSet rset;
        PreparedStatement stmt;
        block5: {
            IPreparedStatementCache statementCache = accessor.getStatementCache();
            stmt = null;
            rset = null;
            stmt = statementCache.getPreparedStatement(this.sqlReadCurrentIndexOffset, IPreparedStatementCache.ReuseProbability.HIGH);
            this.getMappingStrategy().getStore().getIDHandler().setCDOID(stmt, 1, id);
            rset = stmt.executeQuery();
            if (rset.next()) break block5;
            DBUtil.close((ResultSet)rset);
            this.releaseStatement(accessor, stmt);
            return 0;
        }
        try {
            n = rset.getInt(1);
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rset);
                this.releaseStatement(accessor, stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)rset);
        this.releaseStatement(accessor, stmt);
        return n;
    }

    public void processDelta(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, long created, CDOListFeatureDelta delta) {
        CDOBranchPoint main = accessor.getStore().getRepository().getBranchManager().getMainBranch().getHead();
        InternalCDORevision originalRevision = (InternalCDORevision)accessor.getStore().getRepository().getRevisionManager().getRevision(id, main, -1, 0, true);
        int oldListSize = originalRevision.getList(this.getFeature()).size();
        if (TRACER.isEnabled()) {
            TRACER.format("ListTableMapping.processDelta for revision {0} - previous list size: {1}", new Object[]{originalRevision, oldListSize});
        }
        ListDeltaVisitor visitor = new ListDeltaVisitor(oldListSize);
        if (TRACER.isEnabled()) {
            TRACER.trace("Processing deltas...");
        }
        for (CDOFeatureDelta listDelta : delta.getListChanges()) {
            listDelta.accept((CDOFeatureDeltaVisitor)visitor);
        }
        visitor.postProcess(accessor, id);
        visitor.writeResultToDatabase(accessor, id);
    }

    private void releaseStatement(IDBStoreAccessor accessor, PreparedStatement ... stmts) {
        Throwable t = null;
        PreparedStatement[] preparedStatementArray = stmts;
        int n = stmts.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                PreparedStatement stmt = preparedStatementArray[n2];
                try {
                    if (stmt == null) break block10;
                    try {
                        try {
                            stmt.clearBatch();
                        }
                        catch (SQLException e) {
                            throw new DBException((Throwable)e);
                        }
                    }
                    finally {
                        accessor.getStatementCache().releasePreparedStatement(stmt);
                    }
                }
                catch (Throwable th) {
                    if (t == null) {
                        t = th;
                    }
                    OM.LOG.error(t);
                }
            }
            ++n2;
        }
        if (t != null) {
            throw new DBException(t);
        }
    }

    private final class ListDeltaVisitor
    implements CDOFeatureDeltaVisitor {
        private boolean clearFirst = false;
        private ArrayList<ManipulationElement> manipulations;
        private int tempIndex = -1;

        public ListDeltaVisitor(int oldListSize) {
            this.manipulations = new ArrayList(oldListSize);
            int i = 0;
            while (i < oldListSize) {
                this.manipulations.add(ManipulationElement.createOriginalElement(i));
                ++i;
            }
        }

        public void visit(CDOAddFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("  - insert at {0} value {1}", new Object[]{delta.getIndex(), delta.getValue()});
            }
            this.shiftIndexes(delta.getIndex(), -1, 1);
            this.manipulations.add(ManipulationElement.createInsertedElement(delta.getIndex(), delta.getValue()));
        }

        public void visit(CDORemoveFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("  - remove at {0}", new Object[]{delta.getIndex()});
            }
            ManipulationElement e = this.findElement(delta.getIndex());
            this.deleteItem(e);
            this.shiftIndexes(delta.getIndex() + 1, -1, -1);
        }

        public void visit(CDOSetFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("  - set at {0} value {1}", new Object[]{delta.getIndex(), delta.getValue()});
            }
            ManipulationElement e = this.findElement(delta.getIndex());
            e.value = delta.getValue();
            if (!e.is(8)) {
                e.addType(2);
            }
        }

        public void visit(CDOUnsetFeatureDelta delta) {
            if (delta.getFeature().isUnsettable()) {
                Assert.isTrue((boolean)false);
            }
            if (TRACER.isEnabled()) {
                TRACER.format("  - unset list", new Object[0]);
            }
            this.clearFirst = true;
            this.manipulations.clear();
        }

        public void visit(CDOClearFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("  - clear list", new Object[0]);
            }
            this.clearFirst = true;
            this.manipulations.clear();
        }

        public void visit(CDOMoveFeatureDelta delta) {
            int fromIdx = delta.getOldPosition();
            int toIdx = delta.getNewPosition();
            if (TRACER.isEnabled()) {
                TRACER.format("  - move {0} -> {1}", new Object[]{fromIdx, toIdx});
            }
            if (fromIdx == toIdx) {
                return;
            }
            ManipulationElement e = this.findElement(fromIdx);
            if (fromIdx < toIdx) {
                this.shiftIndexes(fromIdx + 1, toIdx, -1);
            } else {
                this.shiftIndexes(toIdx, fromIdx - 1, 1);
            }
            e.destinationIndex = toIdx;
            if (!e.is(8)) {
                e.addType(4);
            }
        }

        public void visit(CDOListFeatureDelta delta) {
            Assert.isTrue((boolean)false);
        }

        public void visit(CDOContainerFeatureDelta delta) {
            Assert.isTrue((boolean)false);
        }

        private void shiftIndexes(int from, int to, int offset) {
            for (ManipulationElement e : this.manipulations) {
                if (e.destinationIndex < from || to != -1 && e.destinationIndex > to) continue;
                e.destinationIndex += offset;
            }
        }

        private ManipulationElement findElement(int index) {
            for (ManipulationElement e : this.manipulations) {
                if (e.destinationIndex != index) continue;
                return e;
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        private void deleteItem(ManipulationElement e) {
            if (e.is(8)) {
                this.manipulations.remove(e);
            } else {
                e.type = 16;
                e.destinationIndex = Integer.MIN_VALUE;
            }
        }

        public void postProcess(IDBStoreAccessor accessor, CDOID id) {
            if (!((HorizontalNonAuditMappingStrategy)NonAuditListTableMapping.this.getMappingStrategy()).shallForceZeroBasedIndex()) {
                int offsetBefore = NonAuditListTableMapping.this.getCurrentIndexOffset(accessor, id);
                if (TRACER.isEnabled()) {
                    TRACER.trace("Offset optimization.");
                    TRACER.trace("Current offset = " + offsetBefore);
                }
                this.applyOffsetToSourceIndexes(offsetBefore);
                int offsetAfter = (long)Math.abs(offsetBefore) + (long)this.manipulations.size() > Integer.MAX_VALUE ? 0 : this.calculateOptimalOffset();
                if (TRACER.isEnabled()) {
                    TRACER.trace("New offset = " + -offsetAfter);
                }
                this.applyOffsetToDestinationIndexes(offsetAfter);
                this.tempIndex = Math.min(offsetBefore, offsetAfter) - 1;
            }
        }

        private int calculateOptimalOffset() {
            HashMap<Integer, Integer> occurrences = new HashMap<Integer, Integer>();
            int bestOffset = 0;
            int bestOffsetOccurrence = 0;
            for (ManipulationElement element : this.manipulations) {
                int srcIdx = element.sourceIndex;
                int destIdx = element.destinationIndex;
                if (srcIdx == Integer.MIN_VALUE || destIdx == Integer.MIN_VALUE) continue;
                int offset = destIdx - srcIdx;
                Integer oldOccurrence = (Integer)occurrences.get(offset);
                int newOccurrence = oldOccurrence == null ? 1 : oldOccurrence + 1;
                occurrences.put(offset, newOccurrence);
                if (newOccurrence <= bestOffsetOccurrence) continue;
                bestOffsetOccurrence = newOccurrence;
                bestOffset = offset;
            }
            return bestOffset;
        }

        private void applyOffsetToSourceIndexes(int offsetBefore) {
            for (ManipulationElement element : this.manipulations) {
                if (element.sourceIndex == Integer.MIN_VALUE) continue;
                element.sourceIndex += offsetBefore;
            }
        }

        private void applyOffsetToDestinationIndexes(int offsetAfter) {
            for (ManipulationElement element : this.manipulations) {
                if (element.destinationIndex == Integer.MIN_VALUE) continue;
                element.destinationIndex -= offsetAfter;
            }
        }

        private void writeResultToDatabase(IDBStoreAccessor accessor, CDOID id) {
            IIDHandler idHandler = NonAuditListTableMapping.this.getMappingStrategy().getStore().getIDHandler();
            IPreparedStatementCache statementCache = accessor.getStatementCache();
            PreparedStatement deleteStmt = null;
            Statement moveStmt = null;
            PreparedStatement setValueStmt = null;
            PreparedStatement insertStmt = null;
            int deleteCounter = 0;
            int moveCounter = 0;
            int setValueCounter = 0;
            int insertCounter = 0;
            if (TRACER.isEnabled()) {
                TRACER.trace("Writing to database:");
            }
            if (this.clearFirst) {
                if (TRACER.isEnabled()) {
                    TRACER.trace(" - clear list");
                }
                NonAuditListTableMapping.this.clearList(accessor, id);
            }
            try {
                try {
                    for (ManipulationElement element : this.manipulations) {
                        if (element.is(16)) {
                            if (deleteStmt == null) {
                                deleteStmt = statementCache.getPreparedStatement(NonAuditListTableMapping.this.sqlDeleteItem, IPreparedStatementCache.ReuseProbability.HIGH);
                                idHandler.setCDOID(deleteStmt, 1, id);
                            }
                            deleteStmt.setInt(2, element.sourceIndex);
                            deleteStmt.addBatch();
                            ++deleteCounter;
                            if (TRACER.isEnabled()) {
                                TRACER.format(" - delete at {0} ", new Object[]{element.sourceIndex});
                            }
                        }
                        if (!element.is(4)) continue;
                        if (moveStmt == null) {
                            moveStmt = statementCache.getPreparedStatement(NonAuditListTableMapping.this.sqlUpdateIndex, IPreparedStatementCache.ReuseProbability.HIGH);
                            idHandler.setCDOID((PreparedStatement)moveStmt, 2, id);
                        }
                        moveStmt.setInt(3, element.sourceIndex);
                        moveStmt.setInt(1, --this.tempIndex);
                        element.tempIndex = this.tempIndex;
                        moveStmt.addBatch();
                        ++moveCounter;
                        if (!TRACER.isEnabled()) continue;
                        TRACER.format(" - move {0} -> {1} ", new Object[]{element.sourceIndex, element.tempIndex});
                    }
                    if (deleteCounter > 0) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("Performing {0} delete operations", new Object[]{deleteCounter});
                        }
                        DBUtil.executeBatch(deleteStmt, (int)deleteCounter);
                    }
                    if (moveCounter > 0) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("Performing {0} move operations", new Object[]{moveCounter});
                        }
                        DBUtil.executeBatch(moveStmt, (int)moveCounter);
                        moveStmt.clearBatch();
                        moveCounter = 0;
                    }
                    this.writeShiftOperations(accessor, id);
                    for (ManipulationElement element : this.manipulations) {
                        if (element.is(4)) {
                            moveStmt.setInt(3, element.tempIndex);
                            moveStmt.setInt(1, element.destinationIndex);
                            moveStmt.addBatch();
                            ++moveCounter;
                            if (TRACER.isEnabled()) {
                                TRACER.format(" - move {0} -> {1} ", new Object[]{element.tempIndex, element.destinationIndex});
                            }
                        }
                        if (element.is(2)) {
                            if (setValueStmt == null) {
                                setValueStmt = statementCache.getPreparedStatement(NonAuditListTableMapping.this.sqlUpdateValue, IPreparedStatementCache.ReuseProbability.HIGH);
                                idHandler.setCDOID(setValueStmt, 2, id);
                            }
                            setValueStmt.setInt(3, element.destinationIndex);
                            NonAuditListTableMapping.this.getTypeMapping().setValue(setValueStmt, 1, element.value);
                            setValueStmt.addBatch();
                            ++setValueCounter;
                            if (TRACER.isEnabled()) {
                                TRACER.format(" - set value at {0} to {1} ", new Object[]{element.destinationIndex, element.value});
                            }
                        }
                        if (!element.is(8)) continue;
                        if (insertStmt == null) {
                            insertStmt = statementCache.getPreparedStatement(NonAuditListTableMapping.this.sqlInsertValue, IPreparedStatementCache.ReuseProbability.HIGH);
                            idHandler.setCDOID(insertStmt, 1, id);
                        }
                        insertStmt.setInt(2, element.destinationIndex);
                        NonAuditListTableMapping.this.getTypeMapping().setValue(insertStmt, 3, element.value);
                        insertStmt.addBatch();
                        ++insertCounter;
                        if (!TRACER.isEnabled()) continue;
                        TRACER.format(" - insert value at {0} : value {1} ", new Object[]{element.destinationIndex, element.value});
                    }
                    if (moveCounter > 0) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("Performing {0} move operations", new Object[]{moveCounter});
                        }
                        DBUtil.executeBatch((PreparedStatement)moveStmt, (int)moveCounter);
                    }
                    if (insertCounter > 0) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("Performing {0} insert operations", new Object[]{insertCounter});
                        }
                        DBUtil.executeBatch(insertStmt, (int)insertCounter);
                    }
                    if (setValueCounter > 0) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("Performing {0} set operations", new Object[]{setValueCounter});
                        }
                        DBUtil.executeBatch(setValueStmt, (int)setValueCounter);
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                NonAuditListTableMapping.this.releaseStatement(accessor, new PreparedStatement[]{deleteStmt, moveStmt, insertStmt, setValueStmt});
                throw throwable;
            }
            NonAuditListTableMapping.this.releaseStatement(accessor, new PreparedStatement[]{deleteStmt, moveStmt, insertStmt, setValueStmt});
        }

        private void writeShiftOperations(IDBStoreAccessor accessor, CDOID id) throws SQLException {
            IIDHandler idHandler = NonAuditListTableMapping.this.getMappingStrategy().getStore().getIDHandler();
            int size = this.manipulations.size();
            LinkedList<ShiftOperation> shiftOperations = new LinkedList<ShiftOperation>();
            int rangeStartIndex = Integer.MIN_VALUE;
            int rangeOffset = 0;
            int lastElementIndex = Integer.MIN_VALUE;
            int i = 0;
            while (i < size) {
                ManipulationElement element = this.manipulations.get(i);
                if (element.type == 0 || element.type == 2) {
                    int elementOffset = element.destinationIndex - element.sourceIndex;
                    if (elementOffset != rangeOffset && rangeStartIndex != Integer.MIN_VALUE) {
                        shiftOperations.add(new ShiftOperation(rangeStartIndex, lastElementIndex, rangeOffset));
                        rangeStartIndex = Integer.MIN_VALUE;
                        rangeOffset = 0;
                    }
                    if (elementOffset != 0 && rangeStartIndex == Integer.MIN_VALUE) {
                        rangeStartIndex = element.sourceIndex;
                        rangeOffset = elementOffset;
                    }
                } else if (rangeStartIndex != Integer.MIN_VALUE) {
                    shiftOperations.add(new ShiftOperation(rangeStartIndex, lastElementIndex, rangeOffset));
                    rangeStartIndex = Integer.MIN_VALUE;
                    rangeOffset = 0;
                }
                lastElementIndex = element.sourceIndex;
                ++i;
            }
            if (rangeStartIndex != Integer.MIN_VALUE) {
                shiftOperations.add(new ShiftOperation(rangeStartIndex, lastElementIndex, rangeOffset));
            }
            ListIterator operationIt = shiftOperations.listIterator();
            IPreparedStatementCache statementCache = accessor.getStatementCache();
            PreparedStatement shiftDownStmt = null;
            int operationCounter = 0;
            try {
                while (operationIt.hasNext()) {
                    ShiftOperation operation = (ShiftOperation)operationIt.next();
                    if (operation.offset >= 0) continue;
                    if (shiftDownStmt == null) {
                        shiftDownStmt = statementCache.getPreparedStatement(NonAuditListTableMapping.this.sqlShiftDownIndex, IPreparedStatementCache.ReuseProbability.HIGH);
                        idHandler.setCDOID(shiftDownStmt, 2, id);
                    }
                    if (TRACER.isEnabled()) {
                        TRACER.format(" - shift down {0} ", new Object[]{operation});
                    }
                    shiftDownStmt.setInt(1, operation.offset);
                    shiftDownStmt.setInt(3, operation.startIndex);
                    shiftDownStmt.setInt(4, operation.endIndex);
                    shiftDownStmt.addBatch();
                    ++operationCounter;
                    operationIt.remove();
                }
                if (operationCounter > 0) {
                    DBUtil.executeBatch(shiftDownStmt, (int)operationCounter, (boolean)false);
                }
            }
            catch (Throwable throwable) {
                NonAuditListTableMapping.this.releaseStatement(accessor, new PreparedStatement[]{shiftDownStmt});
                throw throwable;
            }
            NonAuditListTableMapping.this.releaseStatement(accessor, new PreparedStatement[]{shiftDownStmt});
            PreparedStatement shiftUpStmt = null;
            operationCounter = 0;
            try {
                while (operationIt.hasPrevious()) {
                    ShiftOperation operation = (ShiftOperation)operationIt.previous();
                    if (shiftUpStmt == null) {
                        shiftUpStmt = statementCache.getPreparedStatement(NonAuditListTableMapping.this.sqlShiftUpIndex, IPreparedStatementCache.ReuseProbability.HIGH);
                        idHandler.setCDOID(shiftUpStmt, 2, id);
                    }
                    if (TRACER.isEnabled()) {
                        TRACER.format(" - shift up {0} ", new Object[]{operation});
                    }
                    shiftUpStmt.setInt(1, operation.offset);
                    shiftUpStmt.setInt(3, operation.startIndex);
                    shiftUpStmt.setInt(4, operation.endIndex);
                    shiftUpStmt.addBatch();
                    ++operationCounter;
                }
                if (operationCounter > 0) {
                    DBUtil.executeBatch(shiftUpStmt, (int)operationCounter, (boolean)false);
                }
            }
            catch (Throwable throwable) {
                NonAuditListTableMapping.this.releaseStatement(accessor, new PreparedStatement[]{shiftUpStmt});
                throw throwable;
            }
            NonAuditListTableMapping.this.releaseStatement(accessor, new PreparedStatement[]{shiftUpStmt});
        }
    }

    private static interface ManipulationConstants {
        public static final int NO_INDEX = Integer.MIN_VALUE;
        public static final int DELETE = 16;
        public static final int INSERT = 8;
        public static final int MOVE = 4;
        public static final int SET_VALUE = 2;
        public static final Object NIL = new Object();
        public static final int NONE = 0;
    }

    private static final class ManipulationElement
    implements ManipulationConstants {
        public int type;
        public int sourceIndex;
        public int tempIndex;
        public int destinationIndex;
        public Object value;

        public ManipulationElement(int srcIdx, int dstIdx, Object val, int t) {
            this.sourceIndex = srcIdx;
            this.tempIndex = Integer.MIN_VALUE;
            this.destinationIndex = dstIdx;
            this.value = val;
            this.type = t;
        }

        public static ManipulationElement createOriginalElement(int index) {
            return new ManipulationElement(index, index, NIL, 0);
        }

        public static ManipulationElement createInsertedElement(int index, Object value) {
            return new ManipulationElement(Integer.MIN_VALUE, index, value, 8);
        }

        public boolean is(int t) {
            return (this.type & t) > 0;
        }

        public void addType(int t) {
            this.type |= t;
        }
    }

    private static class ShiftOperation {
        final int startIndex;
        final int endIndex;
        final int offset;

        ShiftOperation(int startIndex, int endIndex, int offset) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.offset = offset;
        }

        public String toString() {
            return "range [" + this.startIndex + ".." + this.endIndex + "] offset " + this.offset;
        }
    }
}

