/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.util.concurrent.ExecutionException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.server.XATransactionCommitContext;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CommitTransactionIndication;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CommitXATransactionPhase2Indication
extends CommitTransactionIndication {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, CommitXATransactionPhase2Indication.class);

    public CommitXATransactionPhase2Indication(CDOServerProtocol protocol) {
        super(protocol, (short)14);
    }

    protected void indicating(CDODataInput in, OMMonitor monitor) throws Exception {
        this.initializeCommitContext(in);
        XATransactionCommitContext xaContextContext = (XATransactionCommitContext)this.commitContext;
        int size = in.readInt();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Receiving {0} mapping informations", new Object[]{size});
        }
        int i = 0;
        while (i < size) {
            CDOIDTemp oldID = (CDOIDTemp)in.readCDOID();
            CDOID newID = in.readCDOID();
            xaContextContext.addIDMapping((CDOID)oldID, newID);
            ++i;
        }
        xaContextContext.getState().set((Object)XATransactionCommitContext.CommitState.APPLY_ID_MAPPING_DONE);
    }

    protected void responding(CDODataOutput out, OMMonitor monitor) throws Exception {
        String exceptionMessage = null;
        try {
            this.getRepository().getCommitManager().waitForTermination(this.commitContext.getTransaction());
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        catch (ExecutionException ex) {
            exceptionMessage = ex.getMessage();
        }
        if (exceptionMessage == null) {
            exceptionMessage = this.commitContext.getRollbackMessage();
        }
        this.respondingException(out, exceptionMessage, null);
    }

    protected void initializeCommitContext(CDODataInput in) throws Exception {
        int viewID = in.readInt();
        this.commitContext = this.getRepository().getCommitManager().get(this.getTransaction(viewID));
    }
}

