/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.ocl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOChangeKind;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.ocl.OCLExtentCreator;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.spi.cdo.InternalCDOObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOExtentCreator
implements OCLExtentCreator {
    private CDOView view;
    private CDOChangeSetData changeSetData;
    private CDORevisionCacheAdder revisionCacheAdder;

    public CDOExtentCreator(CDOView view) {
        this.view = view;
    }

    public CDOView getView() {
        return this.view;
    }

    public CDOChangeSetData getChangeSetData() {
        return this.changeSetData;
    }

    public void setChangeSetData(CDOChangeSetData changeSetData) {
        this.changeSetData = changeSetData;
    }

    public CDORevisionCacheAdder getRevisionCacheAdder() {
        return this.revisionCacheAdder;
    }

    public void setRevisionCacheAdder(CDORevisionCacheAdder revisionCacheAdder) {
        this.revisionCacheAdder = revisionCacheAdder;
    }

    @Override
    public Set<EObject> createExtent(EClass eClass, AtomicBoolean canceled) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        CDOBranch branch = this.view.getBranch();
        long timeStamp = this.view.getTimeStamp();
        return this.createExtent(eClass, accessor, branch, timeStamp, canceled);
    }

    protected Set<EObject> createExtent(EClass eClass, IStoreAccessor accessor, CDOBranch branch, long timeStamp, final AtomicBoolean canceled) {
        List newObjects;
        final HashSet<EObject> extent = new HashSet<EObject>();
        if (this.changeSetData != null && (newObjects = this.changeSetData.getNewObjects()) != null) {
            for (CDOIDAndVersion key : newObjects) {
                EObject object = this.getEObject(key.getID());
                if (object == null) continue;
                extent.add(object);
            }
        }
        accessor.handleRevisions(eClass, branch, timeStamp, false, (CDORevisionHandler)new CDORevisionHandler.Filtered.Undetached(new CDORevisionHandler(){

            public boolean handleRevision(CDORevision revision) {
                EObject object;
                CDOID id;
                if (CDOExtentCreator.this.revisionCacheAdder != null) {
                    CDOExtentCreator.this.revisionCacheAdder.addRevision(revision);
                }
                if (!CDOExtentCreator.this.isDetached(id = revision.getID()) && (object = CDOExtentCreator.this.getEObject(id)) != null) {
                    extent.add(object);
                }
                return !canceled.get();
            }
        }));
        return extent;
    }

    protected boolean isDetached(CDOID id) {
        if (this.changeSetData == null) {
            return false;
        }
        CDOChangeKind changeKind = this.changeSetData.getChangeKind(id);
        return changeKind == CDOChangeKind.DETACHED;
    }

    protected EObject getEObject(CDOID id) throws ObjectNotFoundException {
        InternalCDOObject object = (InternalCDOObject)this.view.getObject(id);
        if (object == null) {
            throw new ObjectNotFoundException(id);
        }
        return object.cdoInternalInstance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Lazy
    extends CDOExtentCreator {
        public Lazy(CDOView view) {
            super(view);
        }

        @Override
        protected Set<EObject> createExtent(final EClass eClass, final IStoreAccessor accessor, final CDOBranch branch, final long timeStamp, final AtomicBoolean canceled) {
            return new Set<EObject>(){
                private Iterator<EObject> emptyIterator;
                private Boolean empty;
                private CountDownLatch emptyKnown = new CountDownLatch(1);

                @Override
                public synchronized boolean isEmpty() {
                    if (this.empty != null) {
                        return this.empty;
                    }
                    this.emptyIterator = this.iterator();
                    try {
                        this.emptyKnown.await();
                        return this.empty;
                    }
                    catch (InterruptedException ex) {
                        throw new Error("Interrupted");
                    }
                }

                @Override
                public synchronized Iterator<EObject> iterator() {
                    if (this.emptyIterator != null) {
                        Iterator<EObject> it = this.emptyIterator;
                        this.emptyIterator = null;
                        return it;
                    }
                    final Object mutex = new Object();
                    final LinkedList ids = new LinkedList();
                    final boolean[] done = new boolean[1];
                    Thread thread = new Thread("OCLExtentIterator"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            this.handleDirtyState();
                            this.handlePersistentState();
                            Object object = mutex;
                            synchronized (object) {
                                done[0] = true;
                                mutex.notify();
                            }
                            if (empty == null) {
                                empty = true;
                                emptyKnown.countDown();
                            }
                        }

                        private void handleDirtyState() {
                            List newObjects;
                            CDOChangeSetData changeSetData = Lazy.this.getChangeSetData();
                            if (changeSetData != null && (newObjects = changeSetData.getNewObjects()) != null) {
                                for (CDOIDAndVersion key : newObjects) {
                                    this.enqueue(key.getID());
                                }
                            }
                        }

                        private void handlePersistentState() {
                            accessor.handleRevisions(eClass, branch, timeStamp, false, (CDORevisionHandler)new CDORevisionHandler.Filtered.Undetached(new CDORevisionHandler(){

                                public boolean handleRevision(CDORevision revision) {
                                    empty = false;
                                    emptyKnown.countDown();
                                    CDORevisionCacheAdder revisionCacheAdder = Lazy.this.getRevisionCacheAdder();
                                    if (revisionCacheAdder != null) {
                                        revisionCacheAdder.addRevision(revision);
                                    }
                                    CDOID id = revision.getID();
                                    if (!Lazy.this.isDetached(id)) {
                                        this.enqueue(id);
                                    }
                                    return !canceled.get();
                                }
                            }));
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private void enqueue(CDOID id) {
                            Object object = mutex;
                            synchronized (object) {
                                ids.addLast(id);
                                mutex.notify();
                            }
                        }
                    };
                    thread.setDaemon(true);
                    thread.start();
                    return new Iterator<EObject>(){
                        private CDOID next;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public boolean hasNext() {
                            while (this.next == null) {
                                if (canceled.get()) {
                                    return false;
                                }
                                Object object = mutex;
                                synchronized (object) {
                                    if (ids.isEmpty()) {
                                        if (done[0]) {
                                            return false;
                                        }
                                        try {
                                            mutex.wait();
                                        }
                                        catch (InterruptedException ex) {
                                            throw new Error(ex);
                                        }
                                    } else {
                                        this.next = (CDOID)ids.removeFirst();
                                    }
                                }
                            }
                            return true;
                        }

                        @Override
                        public EObject next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            try {
                                EObject eObject = Lazy.this.getEObject(this.next);
                                return eObject;
                            }
                            finally {
                                this.next = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    throw new Error("Not supported");
                }

                @Override
                public boolean contains(Object o) {
                    throw new Error("Not supported");
                }

                @Override
                public Object[] toArray() {
                    throw new Error("Not supported");
                }

                @Override
                public <T> T[] toArray(T[] a) {
                    throw new Error("Not supported");
                }

                @Override
                public boolean add(EObject o) {
                    throw new Error("Not supported");
                }

                @Override
                public boolean remove(Object o) {
                    throw new Error("Not supported");
                }

                @Override
                public boolean containsAll(Collection<?> c) {
                    throw new Error("Not supported");
                }

                @Override
                public boolean addAll(Collection<? extends EObject> c) {
                    throw new Error("Not supported");
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    throw new Error("Not supported");
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    throw new Error("Not supported");
                }

                @Override
                public void clear() {
                    throw new Error("Not supported");
                }
            };
        }
    }
}

