/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.ClassPermission;
import org.eclipse.emf.cdo.security.Directory;
import org.eclipse.emf.cdo.security.Group;
import org.eclipse.emf.cdo.security.PackagePermission;
import org.eclipse.emf.cdo.security.Permission;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.RealmUtil;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.SecurityItem;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.security.UserPassword;
import org.eclipse.emf.cdo.server.IPermissionManager;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.internal.security.bundle.OM;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.ManagedRevisionProvider;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.net4j.util.security.SecurityUtil;

public class SecurityManager
extends Lifecycle
implements InternalSecurityManager {
    private IListener repositoryListener = new LifecycleEventAdapter(){

        protected void onActivated(ILifecycle lifecycle) {
            SecurityManager.this.init();
        }

        protected void onDeactivated(ILifecycle lifecycle) {
            SecurityManager.this.deactivate();
        }
    };
    private final IUserManager userManager = new UserManager();
    private final IPermissionManager permissionManager = new PermissionManager();
    private final IRepository.WriteAccessHandler writeAccessHandler = new WriteAccessHandler();
    private final List<InternalSecurityManager.CommitHandler> commitHandlers = new ArrayList<InternalSecurityManager.CommitHandler>();
    private final String realmPath;
    private final IManagedContainer container;
    private final Map<String, User> users = new HashMap<String, User>();
    private InternalRepository repository;
    private IAcceptor acceptor;
    private IConnector connector;
    private CDOTransaction transaction;
    private Realm realm;
    private EList<SecurityItem> newUsers;
    private EList<SecurityItem> newGroups;
    private EList<SecurityItem> newRoles;

    public SecurityManager(String realmPath, IManagedContainer container) {
        this.realmPath = realmPath;
        this.container = container;
    }

    public final IManagedContainer getContainer() {
        return this.container;
    }

    public final String getRealmPath() {
        return this.realmPath;
    }

    public final IRepository getRepository() {
        return this.repository;
    }

    public void setRepository(InternalRepository repository) {
        this.repository = repository;
        this.init();
    }

    public Realm getRealm() {
        return this.realm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String userID) {
        Map<String, User> map = this.users;
        synchronized (map) {
            User user = this.users.get(userID);
            if (user == null) {
                EList items = this.realm.getItems();
                user = RealmUtil.findUser((EList)items, (String)userID);
                if (user == null) {
                    throw new SecurityException("User " + userID + " not found");
                }
                this.users.put(userID, user);
            }
            return user;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(ISecurityManager.RealmOperation operation) {
        CDOTransaction cDOTransaction = this.transaction;
        synchronized (cDOTransaction) {
            operation.execute(this.realm);
            try {
                this.transaction.commit();
            }
            catch (CommitException ex) {
                throw WrappedException.wrap((Exception)((Object)ex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalSecurityManager.CommitHandler[] getCommitHandlers() {
        List<InternalSecurityManager.CommitHandler> list = this.commitHandlers;
        synchronized (list) {
            return this.commitHandlers.toArray(new InternalSecurityManager.CommitHandler[this.commitHandlers.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommitHandler(InternalSecurityManager.CommitHandler handler) {
        this.checkInactive();
        List<InternalSecurityManager.CommitHandler> list = this.commitHandlers;
        synchronized (list) {
            if (!this.commitHandlers.contains(handler)) {
                this.commitHandlers.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommitHandler(InternalSecurityManager.CommitHandler handler) {
        this.checkInactive();
        List<InternalSecurityManager.CommitHandler> list = this.commitHandlers;
        synchronized (list) {
            this.commitHandlers.remove(handler);
        }
    }

    protected void initCommitHandlers(boolean firstTime) {
        InternalSecurityManager.CommitHandler[] commitHandlerArray = this.getCommitHandlers();
        int n = commitHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSecurityManager.CommitHandler handler = commitHandlerArray[n2];
            try {
                handler.init(this, firstTime);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
    }

    protected void handleCommit(IStoreAccessor.CommitContext commitContext, User user) {
        InternalSecurityManager.CommitHandler[] commitHandlerArray = this.getCommitHandlers();
        int n = commitHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSecurityManager.CommitHandler handler = commitHandlerArray[n2];
            try {
                handler.handleCommit(this, commitContext, user);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
    }

    protected void init() {
        CDOResource resource;
        boolean firstTime;
        if (!this.isActive() || this.repository == null) {
            return;
        }
        this.repository.addListener(this.repositoryListener);
        if (!LifecycleUtil.isActive((Object)this.repository)) {
            return;
        }
        String repositoryName = this.repository.getName();
        String acceptorName = String.valueOf(repositoryName) + "_security";
        this.acceptor = Net4jUtil.getAcceptor((IManagedContainer)this.container, (String)"jvm", (String)acceptorName);
        this.connector = Net4jUtil.getConnector((IManagedContainer)this.container, (String)"jvm", (String)acceptorName);
        CDONet4jSessionConfiguration config = CDONet4jUtil.createNet4jSessionConfiguration();
        config.setConnector(this.connector);
        config.setRepositoryName(repositoryName);
        CDONet4jSession session = config.openNet4jSession();
        this.transaction = session.openTransaction();
        boolean bl = firstTime = !this.transaction.hasResource(this.realmPath);
        if (firstTime) {
            resource = this.transaction.createResource(this.realmPath);
            this.realm = this.createRealm();
            resource.getContents().add((Object)this.realm);
        } else {
            resource = this.transaction.getResource(this.realmPath);
            this.realm = (Realm)resource.getContents().get(0);
        }
        this.initCommitHandlers(firstTime);
        try {
            this.transaction.commit();
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        InternalSessionManager sessionManager = this.repository.getSessionManager();
        sessionManager.setUserManager(this.userManager);
        sessionManager.setPermissionManager(this.permissionManager);
        this.repository.addHandler((IRepository.Handler)this.writeAccessHandler);
    }

    protected Realm createRealm() {
        Realm realm = SecurityFactory.eINSTANCE.createRealm();
        realm.setName("Security Realm");
        Directory users = SecurityFactory.eINSTANCE.createDirectory();
        users.setName("Users");
        realm.getItems().add((Object)users);
        this.newUsers = users.getItems();
        Directory groups = SecurityFactory.eINSTANCE.createDirectory();
        groups.setName("Groups");
        realm.getItems().add((Object)groups);
        this.newGroups = groups.getItems();
        Directory roles = SecurityFactory.eINSTANCE.createDirectory();
        roles.setName("Roles");
        realm.getItems().add((Object)roles);
        this.newRoles = roles.getItems();
        User admin = SecurityFactory.eINSTANCE.createUser();
        admin.setId("Administrator");
        this.newUsers.add((Object)admin);
        UserPassword adminPassword = SecurityFactory.eINSTANCE.createUserPassword();
        adminPassword.setEncrypted("0000");
        admin.setPassword(adminPassword);
        Group admins = SecurityFactory.eINSTANCE.createGroup();
        admins.setId("Administrators");
        admins.getUsers().add((Object)admin);
        this.newGroups.add((Object)admins);
        Role administration = SecurityFactory.eINSTANCE.createRole();
        administration.setId("Administration");
        administration.getAssignees().add((Object)admins);
        this.newRoles.add((Object)administration);
        PackagePermission allResources = SecurityFactory.eINSTANCE.createPackagePermission();
        allResources.setAccess(Access.READ);
        administration.getPermissions().add((Object)allResources);
        allResources.setApplicablePackage((EPackage)EresourcePackage.eINSTANCE);
        for (EClassifier eClassifier : SecurityPackage.eINSTANCE.getEClassifiers()) {
            EClass eClass;
            if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isInterface() || eClass.isAbstract() || eClass == SecurityPackage.Literals.USER_PASSWORD) continue;
            ClassPermission permission = SecurityFactory.eINSTANCE.createClassPermission();
            permission.setAccess(Access.WRITE);
            administration.getPermissions().add((Object)permission);
            permission.setApplicableClass(eClass);
        }
        return realm;
    }

    protected CDOPermission convertPermission(Access permission) {
        if (permission != null) {
            switch (permission) {
                case READ: {
                    return CDOPermission.READ;
                }
                case WRITE: {
                    return CDOPermission.WRITE;
                }
            }
        }
        return CDOPermission.NONE;
    }

    protected CDOPermission getPermission(CDORevision revision, CDORevisionProvider revisionProvider, CDOBranchPoint securityContext, User user) {
        CDOPermission result = this.convertPermission(user.getDefaultAccess());
        if (result == CDOPermission.WRITE) {
            return result;
        }
        for (Permission permission : user.getAllPermissions()) {
            CDOPermission p = this.convertPermission(permission.getAccess());
            if (p.ordinal() <= result.ordinal() || !permission.isApplicable(revision, revisionProvider, securityContext) || (result = p) != CDOPermission.WRITE) continue;
            return result;
        }
        return result;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.init();
    }

    protected void doDeactivate() throws Exception {
        this.users.clear();
        this.realm = null;
        this.transaction.getSession().close();
        this.transaction = null;
        this.connector.close();
        this.connector = null;
        this.acceptor.close();
        this.acceptor = null;
        super.doDeactivate();
    }

    private final class PermissionManager
    implements IPermissionManager {
        private PermissionManager() {
        }

        public CDOPermission getPermission(CDORevision revision, CDOBranchPoint securityContext, String userID) {
            User user = SecurityManager.this.getUser(userID);
            InternalCDORevisionManager revisionManager = SecurityManager.this.repository.getRevisionManager();
            ManagedRevisionProvider revisionProvider = new ManagedRevisionProvider((CDORevisionManager)revisionManager, securityContext);
            return SecurityManager.this.getPermission(revision, (CDORevisionProvider)revisionProvider, securityContext, user);
        }
    }

    private final class UserManager
    implements IUserManager {
        private UserManager() {
        }

        public void addUser(final String userID, final char[] password) {
            SecurityManager.this.modify(new ISecurityManager.RealmOperation(){

                public void execute(Realm realm) {
                    UserPassword userPassword = SecurityFactory.eINSTANCE.createUserPassword();
                    userPassword.setEncrypted(new String(password));
                    User user = SecurityFactory.eINSTANCE.createUser();
                    user.setId(userID);
                    user.setPassword(userPassword);
                    realm.getItems().add((Object)user);
                }
            });
        }

        public void removeUser(final String userID) {
            SecurityManager.this.modify(new ISecurityManager.RealmOperation(){

                public void execute(Realm realm) {
                    User user = SecurityManager.this.getUser(userID);
                    EcoreUtil.remove((EObject)user);
                }
            });
        }

        public byte[] encrypt(String userID, byte[] data, String algorithmName, byte[] salt, int count) throws SecurityException {
            char[] password;
            User user = SecurityManager.this.getUser(userID);
            UserPassword userPassword = user.getPassword();
            String encrypted = userPassword == null ? null : userPassword.getEncrypted();
            char[] cArray = password = encrypted == null ? null : encrypted.toCharArray();
            if (password == null) {
                throw new SecurityException("No password: " + userID);
            }
            try {
                return SecurityUtil.encrypt((byte[])data, (char[])password, (String)algorithmName, (byte[])salt, (int)count);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new SecurityException(ex);
            }
        }
    }

    private final class WriteAccessHandler
    implements IRepository.WriteAccessHandler {
        private WriteAccessHandler() {
        }

        public void handleTransactionBeforeCommitting(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) throws RuntimeException {
            CDOBranchPoint securityContext = commitContext.getBranchPoint();
            String userID = commitContext.getUserID();
            User user = SecurityManager.this.getUser(userID);
            SecurityManager.this.handleCommit(commitContext, user);
            this.permissionRevisionsBeforeCommitting(commitContext, securityContext, user, commitContext.getNewObjects());
            this.permissionRevisionsBeforeCommitting(commitContext, securityContext, user, commitContext.getDirtyObjects());
        }

        private void permissionRevisionsBeforeCommitting(IStoreAccessor.CommitContext commitContext, CDOBranchPoint securityContext, User user, InternalCDORevision[] revisions) {
            InternalCDORevision[] internalCDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                CDOPermission permission = SecurityManager.this.getPermission((CDORevision)revision, (CDORevisionProvider)commitContext, securityContext, user);
                if (permission != CDOPermission.WRITE) {
                    throw new SecurityException("User " + user + " is not allowed to write to " + revision);
                }
                ++n2;
            }
        }

        @Deprecated
        public void handleTransactionAfterCommitted(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) {
        }
    }
}

