/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.spi.security;

import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.security.SecurityManagerUtil;
import org.eclipse.emf.cdo.server.spi.security.AnnotationHandler;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;

public abstract class SecurityManagerFactory
extends Factory {
    public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.security.managers";

    public SecurityManagerFactory(String type) {
        super(PRODUCT_GROUP, type);
    }

    public abstract ISecurityManager create(String var1) throws ProductCreationException;

    public static class Annotation
    extends SecurityManagerFactory {
        private static final String TYPE = "annotation";

        public Annotation() {
            super(TYPE);
        }

        public ISecurityManager create(String realmPath) throws ProductCreationException {
            InternalSecurityManager securityManager = (InternalSecurityManager)SecurityManagerUtil.createSecurityManager(realmPath);
            AnnotationHandler handler = new AnnotationHandler();
            securityManager.addCommitHandler(handler);
            return securityManager;
        }
    }

    public static class Default
    extends SecurityManagerFactory {
        private static final String TYPE = "default";

        public Default() {
            super(TYPE);
        }

        public ISecurityManager create(String realmPath) throws ProductCreationException {
            return SecurityManagerUtil.createSecurityManager(realmPath);
        }
    }
}

