/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.internal.server.QueryResult;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IQueryContext;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.server.InternalQueryManager;
import org.eclipse.emf.cdo.spi.server.InternalQueryResult;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.SingleDeltaContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryManager
extends Lifecycle
implements InternalQueryManager {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SESSION, QueryManager.class);
    private InternalRepository repository;
    private Map<Integer, QueryContext> queryContexts = new ConcurrentHashMap<Integer, QueryContext>();
    private ExecutorService executors;
    private boolean shutdownExecutorService;
    private int nextQuery;
    private boolean allowInterruptRunningQueries = true;

    @Override
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(InternalRepository repository) {
        this.repository = repository;
        String value = repository.getProperties().get("allowInterruptRunningQueries");
        if (value != null) {
            this.allowInterruptRunningQueries = Boolean.parseBoolean(value);
        }
    }

    public synchronized ExecutorService getExecutors() {
        if (this.executors == null) {
            this.shutdownExecutorService = true;
            this.executors = Executors.newFixedThreadPool(10);
        }
        return this.executors;
    }

    public synchronized void setExecutors(ExecutorService executors) {
        if (this.shutdownExecutorService) {
            this.executors.shutdown();
            this.shutdownExecutorService = false;
        }
        this.executors = executors;
    }

    @Override
    public InternalQueryResult execute(InternalView view, CDOQueryInfo queryInfo) {
        QueryResult queryResult = new QueryResult(view, queryInfo, this.nextQuery());
        QueryContext queryContext = new QueryContext(queryResult);
        this.execute(queryContext);
        return queryResult;
    }

    @Override
    public boolean isRunning(int queryID) {
        QueryContext queryContext = this.queryContexts.get(queryID);
        return queryContext != null;
    }

    @Override
    public void cancel(int queryID) {
        QueryContext queryContext = this.queryContexts.get(queryID);
        if (queryContext == null || queryContext.getFuture().isDone()) {
            throw new RuntimeException("Query " + queryID + " is not running anymore");
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Cancelling query for context: " + queryContext);
        }
        queryContext.cancel();
    }

    public synchronized void register(QueryContext queryContext) {
        this.queryContexts.put(queryContext.getQueryResult().getQueryID(), queryContext);
        queryContext.addListener();
    }

    public synchronized void unregister(QueryContext queryContext) {
        if (this.queryContexts.remove(queryContext.getQueryResult().getQueryID()) != null) {
            queryContext.removeListener();
        }
    }

    public synchronized int nextQuery() {
        return this.nextQuery++;
    }

    protected void doDeactivate() throws Exception {
        super.doDeactivate();
        this.setExecutors(null);
    }

    private Future<?> execute(QueryContext queryContext) {
        Future<?> future = this.getExecutors().submit(queryContext);
        queryContext.setFuture(future);
        this.register(queryContext);
        return future;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryContext
    implements IQueryContext,
    Runnable {
        private CDOBranchPoint branchPoint;
        private InternalQueryResult queryResult;
        private boolean started;
        private boolean cancelled;
        private int resultCount;
        private Future<?> future;
        private IListener sessionListener = new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof SingleDeltaContainerEvent) {
                    InternalView view = QueryContext.this.getQueryResult().getView();
                    SingleDeltaContainerEvent deltaEvent = (SingleDeltaContainerEvent)event;
                    if (deltaEvent.getDeltaKind() == IContainerDelta.Kind.REMOVED && deltaEvent.getDeltaElement() == view) {
                        QueryContext.this.cancel();
                    }
                }
            }
        };

        public QueryContext(InternalQueryResult queryResult) {
            this.queryResult = queryResult;
            InternalView view = this.getView();
            this.branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)view);
        }

        public InternalQueryResult getQueryResult() {
            return this.queryResult;
        }

        @Override
        public InternalView getView() {
            return this.queryResult.getView();
        }

        public CDOBranch getBranch() {
            return this.branchPoint.getBranch();
        }

        public long getTimeStamp() {
            return this.branchPoint.getTimeStamp();
        }

        public Future<?> getFuture() {
            return this.future;
        }

        public void setFuture(Future<?> future) {
            this.future = future;
        }

        public void cancel() {
            this.cancelled = true;
            if (this.future != null) {
                this.future.cancel(QueryManager.this.allowInterruptRunningQueries);
            }
            if (!this.started) {
                QueryManager.this.unregister(this);
            }
        }

        @Override
        public int getResultCount() {
            return this.resultCount;
        }

        @Override
        public boolean addResult(Object object) {
            if (this.resultCount == 0) {
                throw new IllegalStateException("Maximum number of results exceeded");
            }
            this.queryResult.getQueue().add(object);
            return !this.cancelled && --this.resultCount > 0;
        }

        @Override
        public void run() {
            InternalSession session = this.queryResult.getView().getSession();
            StoreThreadLocal.setSession(session);
            try {
                try {
                    this.started = true;
                    CDOQueryInfo info = this.queryResult.getQueryInfo();
                    this.resultCount = info.getMaxResults() < 0 ? Integer.MAX_VALUE : info.getMaxResults();
                    IQueryHandler handler = QueryManager.this.repository.getQueryHandler(info);
                    handler.executeQuery(info, this);
                }
                catch (Throwable exception) {
                    this.queryResult.getQueue().setException(exception);
                    this.queryResult.getQueue().close();
                    QueryManager.this.unregister(this);
                    StoreThreadLocal.release();
                }
            }
            finally {
                this.queryResult.getQueue().close();
                QueryManager.this.unregister(this);
                StoreThreadLocal.release();
            }
        }

        public void addListener() {
            InternalView view = this.getQueryResult().getView();
            InternalSession session = view.getSession();
            session.addListener(this.sessionListener);
        }

        public void removeListener() {
            InternalView view = this.getQueryResult().getView();
            InternalSession session = view.getSession();
            session.removeListener(this.sessionListener);
        }
    }
}

