/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.syncing;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchCreatedEvent;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.internal.common.revision.NOOPRevisionCache;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.session.CDOSessionConfiguration;
import org.eclipse.emf.cdo.session.CDOSessionConfigurationFactory;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.cdo.session.CDOSessionLocksChangedEvent;
import org.eclipse.emf.cdo.spi.common.CDORawReplicationContext;
import org.eclipse.emf.cdo.spi.common.CDOReplicationContext;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.spi.server.InternalRepositorySynchronizer;
import org.eclipse.emf.cdo.spi.server.InternalSynchronizableRepository;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.QueueRunner;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.om.monitor.NotifyingMonitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositorySynchronizer
extends QueueRunner
implements InternalRepositorySynchronizer {
    public static final int DEFAULT_RETRY_INTERVAL = 3;
    public static final int DEFAULT_MAX_RECOMMITS = 10;
    public static final int DEFAULT_RECOMMIT_INTERVAL = 1;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REPOSITORY, RepositorySynchronizer.class);
    private static final Integer CONNECT_PRIORITY = 0;
    private static final Integer REPLICATE_PRIORITY = 1;
    private static final Integer BRANCH_PRIORITY = 2;
    private static final Integer COMMIT_PRIORITY;
    private static final Integer LOCKS_PRIORITY;
    private int retryInterval = 3;
    private Object connectLock = new Object();
    private InternalSynchronizableRepository localRepository;
    private InternalCDOSession remoteSession;
    private RemoteSessionListener remoteSessionListener = new RemoteSessionListener();
    private CDOSessionConfigurationFactory remoteSessionConfigurationFactory;
    private boolean rawReplication = true;
    private int maxRecommits = 10;
    private int recommitInterval = 1;
    private Timer recommitTimer;

    static {
        LOCKS_PRIORITY = COMMIT_PRIORITY = Integer.valueOf(3);
    }

    public RepositorySynchronizer() {
        this.setDaemon(true);
    }

    @Override
    public int getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    @Override
    public InternalSynchronizableRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public void setLocalRepository(InternalSynchronizableRepository localRepository) {
        this.checkInactive();
        this.localRepository = localRepository;
    }

    @Override
    public CDOSessionConfigurationFactory getRemoteSessionConfigurationFactory() {
        return this.remoteSessionConfigurationFactory;
    }

    @Override
    public void setRemoteSessionConfigurationFactory(CDOSessionConfigurationFactory masterSessionConfigurationFactory) {
        this.checkArg(masterSessionConfigurationFactory, "remoteSessionConfigurationFactory");
        this.remoteSessionConfigurationFactory = masterSessionConfigurationFactory;
    }

    @Override
    public InternalCDOSession getRemoteSession() {
        return this.remoteSession;
    }

    @Override
    public boolean isRawReplication() {
        return this.rawReplication;
    }

    @Override
    public void setRawReplication(boolean rawReplication) {
        this.checkInactive();
        this.rawReplication = rawReplication;
    }

    @Override
    public int getMaxRecommits() {
        return this.maxRecommits;
    }

    @Override
    public void setMaxRecommits(int maxRecommits) {
        this.maxRecommits = maxRecommits;
    }

    @Override
    public int getRecommitInterval() {
        return this.recommitInterval;
    }

    @Override
    public void setRecommitInterval(int recommitInterval) {
        this.recommitInterval = recommitInterval;
    }

    protected String getThreadName() {
        return "RepositorySynchronizer";
    }

    protected BlockingQueue<Runnable> createQueue() {
        return new PriorityBlockingQueue<Runnable>();
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.remoteSessionConfigurationFactory, "remoteSessionConfigurationFactory");
        this.checkState(this.localRepository, "localRepository");
    }

    protected void doAfterActivate() throws Exception {
        super.doAfterActivate();
        this.scheduleConnect();
    }

    protected void doDeactivate() throws Exception {
        if (this.recommitTimer != null) {
            this.recommitTimer.cancel();
            this.recommitTimer = null;
        }
        if (this.remoteSession != null) {
            this.remoteSession.removeListener((IListener)this.remoteSessionListener);
            this.remoteSession.getBranchManager().removeListener((IListener)this.remoteSessionListener);
            this.remoteSession.close();
            this.remoteSession = null;
        }
        super.doDeactivate();
    }

    private void handleDisconnect() {
        OM.LOG.info("Disconnected from master.");
        if (this.localRepository.getRootResourceID() == null) {
            this.localRepository.setState(CDOCommonRepository.State.INITIAL);
        } else {
            this.localRepository.setState(CDOCommonRepository.State.OFFLINE);
        }
        this.remoteSession.getBranchManager().removeListener((IListener)this.remoteSessionListener);
        this.remoteSession.removeListener((IListener)this.remoteSessionListener);
        this.remoteSession = null;
        this.reconnect();
    }

    private void reconnect() {
        this.clearQueue();
        if (this.isActive()) {
            this.scheduleConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleConnect() {
        Object object = this.connectLock;
        synchronized (object) {
            CDOCommonRepository.State state = this.localRepository.getState();
            if (state.isConnected()) {
                return;
            }
            if (this.isActive()) {
                this.addWork(new ConnectRunnable());
            }
        }
    }

    private void scheduleReplicate() {
        if (this.isActive()) {
            this.addWork(new ReplicateRunnable());
        }
    }

    private void sleepRetryInterval() {
        long now;
        long end = System.currentTimeMillis() + 1000L * (long)this.retryInterval;
        while ((now = System.currentTimeMillis()) < end && this.isActive()) {
            ConcurrencyUtil.sleep((long)Math.min(100L, end - now));
        }
    }

    private final class BranchRunnable
    extends QueueRunnable {
        private CDOBranch branch;

        public BranchRunnable(CDOBranch branch) {
            this.branch = branch;
        }

        public void run() {
            RepositorySynchronizer.this.localRepository.handleBranch(this.branch);
        }

        public int compareTo(QueueRunnable o) {
            int result = super.compareTo(o);
            if (result == 0) {
                result = this.branch.compareTo((Object)((BranchRunnable)o).branch);
            }
            return result;
        }

        protected Integer getPriority() {
            return BRANCH_PRIORITY;
        }
    }

    private final class CommitRunnable
    extends RetryingRunnable {
        private CDOCommitInfo commitInfo;

        public CommitRunnable(CDOCommitInfo commitInfo) {
            this.commitInfo = commitInfo;
        }

        protected void doRun() {
            RepositorySynchronizer.this.localRepository.handleCommitInfo(this.commitInfo);
        }

        public int compareTo(QueueRunnable o) {
            int result = super.compareTo(o);
            if (result == 0) {
                Long timeStamp = this.commitInfo.getTimeStamp();
                Long timeStamp2 = ((CommitRunnable)o).commitInfo.getTimeStamp();
                result = timeStamp < timeStamp2 ? -1 : (timeStamp == timeStamp2 ? 0 : 1);
            }
            return result;
        }

        protected Integer getPriority() {
            return COMMIT_PRIORITY;
        }

        protected String getErrorMessage() {
            return "Replication of master commit failed:" + this.commitInfo;
        }
    }

    private final class ConnectRunnable
    extends QueueRunnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = RepositorySynchronizer.this.connectLock;
            synchronized (object) {
                RepositorySynchronizer.this.checkActive();
                if (TRACER.isEnabled()) {
                    TRACER.trace("Connecting to master...");
                }
                try {
                    CDOSessionConfiguration masterConfiguration = RepositorySynchronizer.this.remoteSessionConfigurationFactory.createSessionConfiguration();
                    masterConfiguration.setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode.ADDITIONS);
                    masterConfiguration.setLockNotificationMode(CDOCommonSession.Options.LockNotificationMode.ALWAYS);
                    RepositorySynchronizer.this.remoteSession = (InternalCDOSession)masterConfiguration.openSession();
                    this.ensureNOOPRevisionCache();
                    this.setRootResourceID();
                }
                catch (Exception ex) {
                    if (RepositorySynchronizer.this.isActive()) {
                        OM.LOG.warn("Connection attempt failed. Retrying in " + RepositorySynchronizer.this.retryInterval + " seconds...", (Throwable)ex);
                        RepositorySynchronizer.this.sleepRetryInterval();
                        RepositorySynchronizer.this.reconnect();
                    }
                    return;
                }
                OM.LOG.info("Connected to master.");
                RepositorySynchronizer.this.scheduleReplicate();
                RepositorySynchronizer.this.remoteSession.addListener((IListener)RepositorySynchronizer.this.remoteSessionListener);
                RepositorySynchronizer.this.remoteSession.getBranchManager().addListener((IListener)RepositorySynchronizer.this.remoteSessionListener);
            }
        }

        protected Integer getPriority() {
            return CONNECT_PRIORITY;
        }

        private void setRootResourceID() {
            CDOCommonRepository.State state = RepositorySynchronizer.this.localRepository.getState();
            if (state == CDOCommonRepository.State.INITIAL) {
                CDOID rootResourceID = RepositorySynchronizer.this.remoteSession.getRepositoryInfo().getRootResourceID();
                RepositorySynchronizer.this.localRepository.setRootResourceID(rootResourceID);
                RepositorySynchronizer.this.localRepository.setState(CDOCommonRepository.State.OFFLINE);
            }
        }

        private void ensureNOOPRevisionCache() {
            InternalCDORevisionCache cache = RepositorySynchronizer.this.remoteSession.getRevisionManager().getCache();
            if (!(cache instanceof NOOPRevisionCache)) {
                throw new IllegalStateException("Master session does not use a NOOPRevisionCache: " + cache.getClass().getName());
            }
        }
    }

    private final class LocksRunnable
    extends RetryingRunnable {
        private CDOLockChangeInfo lockChangeInfo;

        public LocksRunnable(CDOLockChangeInfo lockChangeInfo) {
            this.lockChangeInfo = lockChangeInfo;
        }

        protected Integer getPriority() {
            return LOCKS_PRIORITY;
        }

        protected void doRun() {
            try {
                StoreThreadLocal.setSession(RepositorySynchronizer.this.localRepository.getReplicatorSession());
                RepositorySynchronizer.this.localRepository.handleLockChangeInfo(this.lockChangeInfo);
            }
            finally {
                StoreThreadLocal.release();
            }
        }

        protected String getErrorMessage() {
            return "Replication of master lock changes failed:" + this.lockChangeInfo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class QueueRunnable
    implements Runnable,
    Comparable<QueueRunnable> {
        private QueueRunnable() {
        }

        @Override
        public int compareTo(QueueRunnable o) {
            return this.getPriority().compareTo(o.getPriority());
        }

        protected abstract Integer getPriority();
    }

    private final class RemoteSessionListener
    implements IListener {
        private RemoteSessionListener() {
        }

        public void notifyEvent(IEvent event) {
            ILifecycleEvent e;
            if (!RepositorySynchronizer.this.isActive()) {
                return;
            }
            if (event instanceof CDOBranchCreatedEvent) {
                CDOBranchCreatedEvent e2 = (CDOBranchCreatedEvent)event;
                RepositorySynchronizer.this.addWork(new BranchRunnable(e2.getBranch()));
            } else if (event instanceof CDOSessionInvalidationEvent) {
                CDOSessionInvalidationEvent e3 = (CDOSessionInvalidationEvent)event;
                if (e3.isRemote()) {
                    RepositorySynchronizer.this.addWork(new CommitRunnable((CDOCommitInfo)e3));
                }
            } else if (event instanceof CDOSessionLocksChangedEvent) {
                CDOSessionLocksChangedEvent e4 = (CDOSessionLocksChangedEvent)event;
                RepositorySynchronizer.this.addWork(new LocksRunnable((CDOLockChangeInfo)e4));
            } else if (event instanceof ILifecycleEvent && (e = (ILifecycleEvent)event).getKind() == ILifecycleEvent.Kind.DEACTIVATED && e.getSource() == RepositorySynchronizer.this.remoteSession) {
                RepositorySynchronizer.this.handleDisconnect();
            }
        }
    }

    private final class ReplicateRunnable
    extends QueueRunnable {
        public void run() {
            block5: {
                try {
                    RepositorySynchronizer.this.checkActive();
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Synchronizing with master...");
                    }
                    RepositorySynchronizer.this.localRepository.setState(CDOCommonRepository.State.SYNCING);
                    CDOSessionProtocol sessionProtocol = RepositorySynchronizer.this.remoteSession.getSessionProtocol();
                    NotifyingMonitor monitor = new NotifyingMonitor("Synchronizing", RepositorySynchronizer.this.getListeners());
                    if (RepositorySynchronizer.this.isRawReplication()) {
                        sessionProtocol.replicateRepositoryRaw((CDORawReplicationContext)RepositorySynchronizer.this.localRepository, (OMMonitor)monitor);
                    } else {
                        sessionProtocol.replicateRepository((CDOReplicationContext)RepositorySynchronizer.this.localRepository, (OMMonitor)monitor);
                    }
                    RepositorySynchronizer.this.localRepository.setState(CDOCommonRepository.State.ONLINE);
                    OM.LOG.info("Synchronized with master.");
                }
                catch (RuntimeException ex) {
                    if (!RepositorySynchronizer.this.isActive()) break block5;
                    OM.LOG.warn("Replication attempt failed. Retrying in " + RepositorySynchronizer.this.retryInterval + " seconds...", (Throwable)ex);
                    RepositorySynchronizer.this.sleepRetryInterval();
                    RepositorySynchronizer.this.handleDisconnect();
                }
            }
        }

        protected Integer getPriority() {
            return REPLICATE_PRIORITY;
        }
    }

    private abstract class RetryingRunnable
    extends QueueRunnable {
        private List<Exception> failedRuns;

        private RetryingRunnable() {
        }

        protected abstract void doRun();

        protected abstract String getErrorMessage();

        public void run() {
            try {
                this.doRun();
            }
            catch (Exception ex) {
                if (this.failedRuns == null) {
                    this.failedRuns = new ArrayList<Exception>();
                }
                this.failedRuns.add(ex);
                if (this.failedRuns.size() <= RepositorySynchronizer.this.maxRecommits) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Replication of master commit failed. Trying again in {0} seconds...", new Object[]{RepositorySynchronizer.this.recommitInterval});
                    }
                    if (RepositorySynchronizer.this.recommitTimer == null) {
                        RepositorySynchronizer.this.recommitTimer = new Timer("RecommitTimer-" + RepositorySynchronizer.this);
                    }
                    RepositorySynchronizer.this.recommitTimer.schedule(new TimerTask(){

                        public void run() {
                            try {
                                RepositorySynchronizer.this.addWork(this);
                            }
                            catch (Exception ex) {
                                OM.LOG.error("CommitRunnableTask failed", (Throwable)ex);
                            }
                        }
                    }, (long)RepositorySynchronizer.this.recommitInterval * 1000L);
                }
                OM.LOG.error(this.getErrorMessage(), (Throwable)ex);
            }
        }
    }
}

