/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class ObjectWriteAccessHandler
implements IRepository.WriteAccessHandler {
    private boolean legacyModeEnabled;
    private IStoreAccessor.CommitContext commitContext;
    private CDOView view;
    private EObject[] newObjects;
    private EObject[] dirtyObjects;

    public ObjectWriteAccessHandler() {
    }

    public ObjectWriteAccessHandler(boolean legacyModeEnabled) {
        this.legacyModeEnabled = legacyModeEnabled;
    }

    public final boolean isLegacyModeEnabled() {
        return this.legacyModeEnabled;
    }

    protected final IStoreAccessor.CommitContext getCommitContext() {
        return this.commitContext;
    }

    protected final ITransaction getTransaction() {
        return this.commitContext.getTransaction();
    }

    protected final CDOView getView() {
        if (this.view == null) {
            this.view = CDOServerUtil.openView(this.commitContext, this.legacyModeEnabled);
        }
        return this.view;
    }

    protected final EObject[] getNewObjects() {
        if (this.newObjects == null) {
            InternalCDORevision[] newRevisions = this.commitContext.getNewObjects();
            this.newObjects = new EObject[newRevisions.length];
            CDOView view = this.getView();
            int i = 0;
            while (i < newRevisions.length) {
                InternalCDORevision newRevision = newRevisions[i];
                CDOObject newObject = view.getObject(newRevision.getID());
                this.newObjects[i] = CDOUtil.getEObject((EObject)newObject);
                ++i;
            }
        }
        return this.newObjects;
    }

    protected final EObject[] getDirtyObjects() {
        if (this.dirtyObjects == null) {
            InternalCDORevision[] dirtyRevisions = this.commitContext.getDirtyObjects();
            this.dirtyObjects = new EObject[dirtyRevisions.length];
            CDOView view = this.getView();
            int i = 0;
            while (i < dirtyRevisions.length) {
                InternalCDORevision dirtyRevision = dirtyRevisions[i];
                CDOObject dirtyObject = view.getObject(dirtyRevision.getID());
                this.dirtyObjects[i] = CDOUtil.getEObject((EObject)dirtyObject);
                ++i;
            }
        }
        return this.dirtyObjects;
    }

    public final void handleTransactionBeforeCommitting(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) throws RuntimeException {
        try {
            this.commitContext = commitContext;
            this.handleTransactionBeforeCommitting(monitor);
        }
        finally {
            LifecycleUtil.deactivate((Object)this.view);
            this.view = null;
            this.dirtyObjects = null;
            this.newObjects = null;
            this.commitContext = null;
        }
    }

    public final void handleTransactionAfterCommitted(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) {
        try {
            this.commitContext = commitContext;
            this.handleTransactionAfterCommitted(monitor);
        }
        finally {
            LifecycleUtil.deactivate((Object)this.view);
            this.view = null;
            this.dirtyObjects = null;
            this.newObjects = null;
            this.commitContext = null;
        }
    }

    protected void handleTransactionBeforeCommitting(OMMonitor monitor) throws RuntimeException {
    }

    protected void handleTransactionAfterCommitted(OMMonitor monitor) {
    }
}

