/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.ide.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.ui.ide.Node;
import org.eclipse.emf.cdo.ui.internal.ide.messages.Messages;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.LongRunningActionDelegate;
import org.eclipse.swt.widgets.Shell;

public class CreateBranchActionDelegate
extends LongRunningActionDelegate {
    private String name;

    protected void preRun() throws Exception {
        InputDialog dialog = new InputDialog(new Shell(), Messages.getString("CreateBranchActionDelegate_0"), Messages.getString("CreateBranchActionDelegate_1"), "", (IInputValidator)new BranchNameInputValidator());
        if (dialog.open() == 0) {
            this.name = dialog.getValue();
        } else {
            this.cancel();
        }
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        Node.BranchNode branchNode = (Node.BranchNode)((Object)UIUtil.getElement((ISelection)this.getSelection(), Node.BranchNode.class));
        branchNode.getBranch().createBranch(this.name);
    }

    private final class BranchNameInputValidator
    implements IInputValidator {
        private BranchNameInputValidator() {
        }

        public String isValid(String newText) {
            if (StringUtil.isEmpty((String)newText)) {
                return Messages.getString("CreateBranchActionDelegate_3");
            }
            if (newText.contains("/")) {
                return Messages.getString("CreateBranchActionDelegate_4");
            }
            Node.BranchNode branchNode = (Node.BranchNode)((Object)UIUtil.getElement((ISelection)CreateBranchActionDelegate.this.getSelection(), Node.BranchNode.class));
            CDOBranch branch = branchNode.getBranch();
            if (branch.getBranch(newText) != null) {
                return Messages.getString("CreateBranchActionDelegate_5");
            }
            return null;
        }
    }
}

