/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import java.util.ArrayList;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionContainer;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.internal.cdo.session.CDOViewContainerImpl;
import org.eclipse.emf.internal.cdo.transaction.CDOTransactionImpl;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;

public abstract class CDOTransactionContainerImpl
extends CDOViewContainerImpl
implements CDOTransactionContainer {
    public InternalCDOTransaction getTransaction(int viewID) {
        CDOView view = this.getView(viewID);
        if (view instanceof InternalCDOTransaction) {
            return (InternalCDOTransaction)view;
        }
        return null;
    }

    public InternalCDOTransaction[] getTransactions() {
        this.checkActive();
        ArrayList<InternalCDOTransaction> result = new ArrayList<InternalCDOTransaction>();
        InternalCDOView[] internalCDOViewArray = this.getViews();
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view = internalCDOViewArray[n2];
            if (view instanceof InternalCDOTransaction) {
                result.add((InternalCDOTransaction)view);
            }
            ++n2;
        }
        return result.toArray(new InternalCDOTransaction[result.size()]);
    }

    public CDOTransaction openTransaction(CDOBranchPoint target, ResourceSet resourceSet) {
        this.checkArg(target.getTimeStamp() == 0L, "Target is not head of a branch: " + target);
        return null;
    }

    public CDOTransaction openTransaction(CDOBranchPoint target) {
        return this.openTransaction(target, this.createResourceSet());
    }

    public InternalCDOTransaction openTransaction(CDOBranch branch, ResourceSet resourceSet) {
        this.checkActive();
        InternalCDOTransaction transaction = this.createTransaction(branch);
        this.initView(transaction, resourceSet);
        return transaction;
    }

    public InternalCDOTransaction openTransaction(ResourceSet resourceSet) {
        return this.openTransaction(this.getMainBranch(), resourceSet);
    }

    public InternalCDOTransaction openTransaction(CDOBranch branch) {
        return this.openTransaction(branch, this.createResourceSet());
    }

    public InternalCDOTransaction openTransaction() {
        return this.openTransaction(this.getMainBranch());
    }

    public CDOTransaction openTransaction(String durableLockingID) {
        return this.openTransaction(durableLockingID, this.createResourceSet());
    }

    public CDOTransaction openTransaction(String durableLockingID, ResourceSet resourceSet) {
        this.checkActive();
        InternalCDOTransaction transaction = this.createTransaction(durableLockingID);
        this.initView(transaction, resourceSet);
        return transaction;
    }

    protected InternalCDOTransaction createTransaction(CDOBranch branch) {
        return new CDOTransactionImpl(branch);
    }

    protected InternalCDOTransaction createTransaction(String durableLockingID) {
        return new CDOTransactionImpl(durableLockingID);
    }
}

