/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.net4j.util.properties.DefaultPropertyTester;
import org.eclipse.net4j.util.properties.IProperties;
import org.eclipse.net4j.util.properties.Properties;
import org.eclipse.net4j.util.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionProperties
extends Properties<CDOSession> {
    public static final IProperties<CDOSession> INSTANCE = new SessionProperties();
    private static final String CATEGORY_SESSION = "Session";
    private static final String CATEGORY_REPOSITORY = "Repository";

    private SessionProperties() {
        super(CDOSession.class);
        this.add((Property)new Property<CDOSession>("open", Messages.getString("SessionPropertyTester_34"), Messages.getString("SessionPropertyTester_35"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return !session.isClosed();
            }
        });
        this.add((Property)new Property<CDOSession>("sessionID", Messages.getString("SessionPropertyTester_0"), Messages.getString("SessionPropertyTester_3"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return session.getSessionID();
            }
        });
        this.add((Property)new Property<CDOSession>("userID", Messages.getString("SessionPropertyTester_4"), Messages.getString("SessionPropertyTester_5"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return session.getUserID();
            }
        });
        this.add((Property)new Property<CDOSession>("passiveUpdateEnabled", Messages.getString("SessionPropertyTester_6"), Messages.getString("SessionPropertyTester_7"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return session.options().isPassiveUpdateEnabled();
            }
        });
        this.add((Property)new Property<CDOSession>("lastUpdateTime", Messages.getString("SessionPropertyTester_36"), Messages.getString("SessionPropertyTester_37"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return CDOCommonUtil.formatTimeStamp((long)session.getLastUpdateTime());
            }
        });
        this.add((Property)new Property<CDOSession>("passiveUpdateMode", Messages.getString("SessionPropertyTester_8"), Messages.getString("SessionPropertyTester_9"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return session.options().getPassiveUpdateMode();
            }
        });
        this.add((Property)new Property<CDOSession>("repositoryName", Messages.getString("SessionPropertyTester_10"), Messages.getString("SessionPropertyTester_11"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().getName();
            }
        });
        this.add((Property)new Property<CDOSession>("repositoryUUID", Messages.getString("SessionPropertyTester_12"), Messages.getString("SessionPropertyTester_13"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().getUUID();
            }
        });
        this.add((Property)new Property<CDOSession>("repositoryType", Messages.getString("SessionPropertyTester_14"), Messages.getString("SessionPropertyTester_15"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().getType();
            }
        });
        this.add((Property)new Property<CDOSession>("repositoryState", Messages.getString("SessionPropertyTester_16"), Messages.getString("SessionPropertyTester_17"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().getState();
            }
        });
        this.add((Property)new Property<CDOSession>("repositoryCreationTime", Messages.getString("SessionPropertyTester_18"), Messages.getString("SessionPropertyTester_19"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return CDOCommonUtil.formatTimeStamp((long)session.getRepositoryInfo().getCreationTime());
            }
        });
        this.add((Property)new Property<CDOSession>("supportingAudits", Messages.getString("SessionPropertyTester_20"), Messages.getString("SessionPropertyTester_21"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().isSupportingAudits();
            }
        });
        this.add((Property)new Property<CDOSession>("supportingBranches", Messages.getString("SessionPropertyTester_22"), Messages.getString("SessionPropertyTester_23"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().isSupportingBranches();
            }
        });
        this.add((Property)new Property<CDOSession>("supportingEcore", Messages.getString("SessionPropertyTester_28"), Messages.getString("SessionPropertyTester_29"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().isSupportingEcore();
            }
        });
        this.add((Property)new Property<CDOSession>("ensureReferentialIntegrity", Messages.getString("SessionPropertyTester_30"), Messages.getString("SessionPropertyTester_31"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().isEnsuringReferentialIntegrity();
            }
        });
        this.add((Property)new Property<CDOSession>("idGenerationLocation", Messages.getString("SessionPropertyTester_32"), Messages.getString("SessionPropertyTester_33"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().getIDGenerationLocation();
            }
        });
        this.add((Property)new Property<CDOSession>("storeType", Messages.getString("SessionPropertyTester_24"), Messages.getString("SessionPropertyTester_25"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().getStoreType();
            }
        });
        this.add((Property)new Property<CDOSession>("objectIDTypes", Messages.getString("SessionPropertyTester_26"), Messages.getString("SessionPropertyTester_27"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                StringBuilder builder = new StringBuilder();
                for (CDOID.ObjectType objectIDType : session.getRepositoryInfo().getObjectIDTypes()) {
                    if (builder.length() != 0) {
                        builder.append(", ");
                    }
                    builder.append(objectIDType);
                }
                return builder;
            }
        });
    }

    public static void main(String[] args) {
        new Tester().dumpContributionMarkup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Tester
    extends DefaultPropertyTester<CDOSession> {
        public static final String NAMESPACE = "org.eclipse.emf.cdo.session";

        public Tester() {
            super(NAMESPACE, INSTANCE);
        }
    }
}

