/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDOElementProxy;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOAddFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOClearFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOContainerFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOMoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORemoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSetFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOUnsetFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.view.CDOFeatureAnalyzer;
import org.eclipse.emf.cdo.view.CDORevisionPrefetchingPolicy;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.spi.cdo.CDOStore;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOStoreImpl
implements CDOStore {
    private final ContextTracer TRACER = new ContextTracer(OM.DEBUG_STORE, CDOStoreImpl.class);
    private InternalCDOView view;

    public CDOStoreImpl(InternalCDOView view) {
        this.view = view;
    }

    @Override
    public InternalCDOView getView() {
        return this.view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContainer(InternalEObject eObject, CDOResource newResource, InternalEObject newEContainer, int newContainerFeatureID) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("setContainer({0}, {1}, {2}, {3})", new Object[]{cdoObject, newResource, newEContainer, newContainerFeatureID});
            }
            CDOID newContainerID = newEContainer == null ? CDOID.NULL : cdoObject.cdoView().convertObjectToID(newEContainer, true);
            CDOID newResourceID = newResource == null ? CDOID.NULL : newResource.cdoID();
            CDOContainerFeatureDeltaImpl delta = new CDOContainerFeatureDeltaImpl(newResourceID, (Object)newContainerID, newContainerFeatureID);
            InternalCDORevision revision = CDOStoreImpl.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
            revision.setResourceID(newResourceID);
            revision.setContainerID((Object)newContainerID);
            revision.setContainingFeatureID(newContainerFeatureID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalEObject getContainer(InternalEObject eObject) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("getContainer({0})", new Object[]{cdoObject});
            }
            InternalCDORevision revision = CDOStoreImpl.getRevisionForReading(cdoObject);
            return (InternalEObject)this.convertIDToObject(cdoObject.cdoView(), cdoObject, EcorePackage.eINSTANCE.eContainingFeature(), -1, revision.getContainerID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getContainingFeatureID(InternalEObject eObject) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("getContainingFeatureID({0})", new Object[]{cdoObject});
            }
            InternalCDORevision revision = CDOStoreImpl.getRevisionForReading(cdoObject);
            return revision.getContainingFeatureID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalEObject getResource(InternalEObject eObject) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("getResource({0})", new Object[]{cdoObject});
            }
            InternalCDORevision revision = CDOStoreImpl.getRevisionForReading(cdoObject);
            return (InternalEObject)this.convertIDToObject(cdoObject.cdoView(), cdoObject, EcorePackage.eINSTANCE.eContainingFeature(), -1, revision.getResourceID());
        }
    }

    public EStructuralFeature getContainingFeature(InternalEObject eObject) {
        throw new UnsupportedOperationException("Use getContainingFeatureID() instead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(InternalEObject eObject, EStructuralFeature feature, int index) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("get({0}, {1}, {2})", new Object[]{cdoObject, feature, index});
            }
            CDOFeatureAnalyzer featureAnalyzer = this.view.options().getFeatureAnalyzer();
            featureAnalyzer.preTraverseFeature(cdoObject, feature, index);
            InternalCDORevision revision = CDOStoreImpl.getRevisionForReading(cdoObject);
            Object value = revision.get(feature, index);
            value = this.convertToEMF((EObject)eObject, revision, feature, index, value);
            featureAnalyzer.postTraverseFeature(cdoObject, feature, index, value);
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSet(InternalEObject eObject, EStructuralFeature feature) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("isSet({0}, {1})", new Object[]{cdoObject, feature});
            }
            if (!feature.isUnsettable()) {
                Object defaultValue;
                if (feature.isMany()) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 4] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                    InternalCDORevision revision = CDOStoreImpl.getRevisionForReading(cdoObject);
                    CDOList list = revision.getList(feature);
                    return list != null && !list.isEmpty();
                }
                Object value = eObject.eGet(feature);
                boolean bl = !ObjectUtil.equals((Object)value, (Object)(defaultValue = feature.getDefaultValue()));
                return bl;
            }
            Object value = this.get(eObject, feature, -1);
            boolean bl = value != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(InternalEObject eObject, EStructuralFeature feature) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("size({0}, {1})", new Object[]{cdoObject, feature});
            }
            InternalCDORevision revision = CDOStoreImpl.getRevisionForReading(cdoObject);
            return revision.size(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(InternalEObject eObject, EStructuralFeature feature) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("isEmpty({0}, {1})", new Object[]{cdoObject, feature});
            }
            InternalCDORevision revision = CDOStoreImpl.getRevisionForReading(cdoObject);
            return revision.isEmpty(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(InternalEObject eObject, EStructuralFeature feature, Object value) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("contains({0}, {1}, {2})", new Object[]{cdoObject, feature, value});
            }
            Object convertedValue = this.convertToCDO(cdoObject, feature, value);
            InternalCDORevision revision = CDOStoreImpl.getRevisionForReading(cdoObject);
            boolean result = revision.contains(feature, convertedValue);
            if (!result && value != convertedValue && value instanceof EObject) {
                result = revision.contains(feature, value);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(InternalEObject eObject, EStructuralFeature feature, Object value) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("indexOf({0}, {1}, {2})", new Object[]{cdoObject, feature, value});
            }
            value = this.convertToCDO(cdoObject, feature, value);
            InternalCDORevision revision = CDOStoreImpl.getRevisionForReading(cdoObject);
            return revision.indexOf(feature, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(InternalEObject eObject, EStructuralFeature feature, Object value) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("lastIndexOf({0}, {1}, {2})", new Object[]{cdoObject, feature, value});
            }
            value = this.convertToCDO(cdoObject, feature, value);
            InternalCDORevision revision = CDOStoreImpl.getRevisionForReading(cdoObject);
            return revision.lastIndexOf(feature, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode(InternalEObject eObject, EStructuralFeature feature) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("hashCode({0}, {1})", new Object[]{cdoObject, feature});
            }
            InternalCDORevision revision = CDOStoreImpl.getRevisionForReading(cdoObject);
            return revision.hashCode(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(InternalEObject eObject, EStructuralFeature feature) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("toArray({0}, {1})", new Object[]{cdoObject, feature});
            }
            InternalCDORevision revision = CDOStoreImpl.getRevisionForReading(cdoObject);
            Object[] result = revision.toArray(feature);
            int i = 0;
            while (i < result.length) {
                result[i] = this.convertToEMF((EObject)eObject, revision, feature, i, result[i]);
                ++i;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] toArray(InternalEObject eObject, EStructuralFeature feature, T[] a) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            Object[] array = this.toArray(eObject, feature);
            int size = array.length;
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            System.arraycopy(array, 0, a, 0, size);
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(InternalEObject eObject, EStructuralFeature feature, int index, Object value) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("set({0}, {1}, {2}, {3})", new Object[]{cdoObject, feature, index, value});
            }
            value = this.convertToCDO(cdoObject, feature, value);
            InternalCDORevision oldRevision = CDOStoreImpl.getRevisionForReading(cdoObject);
            Object oldValue = oldRevision.get(feature, index);
            oldValue = this.convertToEMF((EObject)eObject, oldRevision, feature, index, oldValue);
            CDOSetFeatureDeltaImpl delta = new CDOSetFeatureDeltaImpl(feature, index, value, oldValue);
            InternalCDORevision revision = CDOStoreImpl.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
            revision.set(feature, index, value);
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unset(InternalEObject eObject, EStructuralFeature feature) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("unset({0}, {1})", new Object[]{cdoObject, feature});
            }
            CDOUnsetFeatureDeltaImpl delta = new CDOUnsetFeatureDeltaImpl(feature);
            InternalCDORevision revision = CDOStoreImpl.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
            if (feature.isUnsettable()) {
                revision.unset(feature);
            } else if (feature.isMany()) {
                Object value = revision.getValue(feature);
                List list = (List)value;
                list.clear();
            } else {
                Object defaultValue = this.convertToCDO(cdoObject, feature, feature.getDefaultValue());
                revision.set(feature, -1, defaultValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(InternalEObject eObject, EStructuralFeature feature, int index, Object value) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("add({0}, {1}, {2}, {3})", new Object[]{cdoObject, feature, index, value});
            }
            if (!feature.isMany()) {
                throw new UnsupportedOperationException("ADD is not supported for single-valued features");
            }
            value = this.convertToCDO(cdoObject, feature, value);
            CDOAddFeatureDeltaImpl delta = new CDOAddFeatureDeltaImpl(feature, index, value);
            InternalCDORevision revision = CDOStoreImpl.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
            revision.add(feature, index, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(InternalEObject eObject, EStructuralFeature feature, int index) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("remove({0}, {1}, {2})", new Object[]{cdoObject, feature, index});
            }
            Object oldValue = null;
            if (feature.isMany()) {
                InternalCDORevision readLockedRevision = CDOStoreImpl.getRevisionForReading(cdoObject);
                CDOList list = readLockedRevision.getList(feature);
                int size = list.size();
                if (index < 0 || size <= index) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
            } else {
                throw new UnsupportedOperationException("REMOVE is not supported for single-valued features");
            }
            CDORemoveFeatureDeltaImpl delta = new CDORemoveFeatureDeltaImpl(feature, index);
            InternalCDORevision revision = CDOStoreImpl.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
            oldValue = revision.remove(feature, index);
            return this.convertToEMF((EObject)eObject, revision, feature, index, oldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(InternalEObject eObject, EStructuralFeature feature) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("clear({0}, {1})", new Object[]{cdoObject, feature});
            }
            CDOClearFeatureDeltaImpl delta = new CDOClearFeatureDeltaImpl(feature);
            InternalCDORevision revision = CDOStoreImpl.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
            revision.clear(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object move(InternalEObject eObject, EStructuralFeature feature, int target, int source) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            InternalCDOObject cdoObject = this.getCDOObject(eObject);
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("move({0}, {1}, {2}, {3})", new Object[]{cdoObject, feature, target, source});
            }
            CDOMoveFeatureDeltaImpl delta = new CDOMoveFeatureDeltaImpl(feature, target, source);
            InternalCDORevision revision = CDOStoreImpl.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
            Object result = revision.move(feature, target, source);
            result = this.convertToEMF((EObject)eObject, revision, feature, -1, result);
            return result;
        }
    }

    public EObject create(EClass eClass) {
        throw new UnsupportedOperationException("Use the generated factory to create objects");
    }

    public String toString() {
        return MessageFormat.format("CDOStore[{0}]", this.view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object resolveProxy(InternalCDORevision revision, EStructuralFeature feature, int index, Object value) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            if (value instanceof CDOElementProxy) {
                CDOElementProxy proxy = (CDOElementProxy)value;
                value = this.view.getSession().resolveElementProxy((CDORevision)revision, feature, index, proxy.getIndex());
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object convertToCDO(InternalCDOObject object, EStructuralFeature feature, Object value) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            if (value != null) {
                if (feature instanceof EReference) {
                    value = this.view.convertObjectToID(value, true);
                } else if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)value;
                    EStructuralFeature innerFeature = entry.getEStructuralFeature();
                    Object innerValue = entry.getValue();
                    Object convertedValue = this.view.convertObjectToID(innerValue);
                    if (convertedValue != innerValue) {
                        value = CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)innerFeature, (Object)convertedValue);
                    }
                } else {
                    CDOType type = CDOModelUtil.getType((EClassifier)feature.getEType());
                    if (type != null) {
                        value = type.convertToCDO(feature.getEType(), value);
                    }
                }
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object convertToEMF(EObject eObject, InternalCDORevision revision, EStructuralFeature feature, int index, Object value) {
        InternalCDOView internalCDOView = this.view;
        synchronized (internalCDOView) {
            if (value != null) {
                if (feature.isMany()) {
                    if (index == -1) {
                        return value;
                    }
                    if ((value = this.resolveProxy(revision, feature, index, value)) instanceof CDOID) {
                        InternalCDORevisionManager revisionManager;
                        CDOID id = (CDOID)value;
                        CDOList list = revision.getList(feature);
                        CDORevisionPrefetchingPolicy policy = this.view.options().getRevisionPrefetchingPolicy();
                        List<CDOID> listOfIDs = policy.loadAhead((CDORevisionManager)(revisionManager = this.view.getSession().getRevisionManager()), (CDOBranchPoint)this.view, eObject, feature, list, index, id);
                        if (!listOfIDs.isEmpty()) {
                            int initialChunkSize = this.view.getSession().options().getCollectionLoadingPolicy().getInitialChunkSize();
                            revisionManager.getRevisions(listOfIDs, (CDOBranchPoint)this.view, initialChunkSize, 0, true);
                        }
                    }
                }
                if (feature instanceof EReference) {
                    value = this.convertIDToObject(this.view, eObject, feature, index, value);
                } else if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)value;
                    EStructuralFeature innerFeature = entry.getEStructuralFeature();
                    Object innerValue = entry.getValue();
                    Object convertedValue = this.convertIDToObject(this.view, eObject, feature, index, innerValue);
                    if (convertedValue != innerValue) {
                        value = FeatureMapUtil.createEntry((EStructuralFeature)innerFeature, (Object)convertedValue);
                    }
                } else {
                    CDOType type = CDOModelUtil.getType((EClassifier)feature.getEType());
                    if (type != null) {
                        value = type.convertToEMF(feature.getEType(), value);
                    }
                }
            }
            return value;
        }
    }

    private Object convertIDToObject(InternalCDOView view, EObject eObject, EStructuralFeature feature, int index, Object value) {
        block2: {
            try {
                value = view.convertIDToObject(value);
            }
            catch (ObjectNotFoundException ex) {
                if (!(value instanceof CDOID)) break block2;
                value = view.options().getStaleReferencePolicy().processStaleReference(eObject, feature, index, ex.getID());
            }
        }
        return value;
    }

    private InternalCDOObject getCDOObject(Object object) {
        return FSMUtil.adapt(object, this.view);
    }

    private static InternalCDORevision getRevisionForReading(InternalCDOObject cdoObject) {
        CDOStateMachine.INSTANCE.read(cdoObject);
        return CDOStoreImpl.getRevision(cdoObject);
    }

    private static InternalCDORevision getRevisionForWriting(InternalCDOObject cdoObject, CDOFeatureDelta delta) {
        CDOStateMachine.INSTANCE.write(cdoObject, delta);
        return CDOStoreImpl.getRevision(cdoObject);
    }

    private static InternalCDORevision getRevision(InternalCDOObject cdoObject) {
        InternalCDORevision revision = cdoObject.cdoRevision();
        if (revision == null) {
            throw new IllegalStateException("revision == null");
        }
        return revision;
    }
}

