/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.compare.ui.viewer.filter.DifferenceFilterDescriptor;
import org.eclipse.emf.compare.ui.viewer.filter.IDifferenceFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DifferenceFilterRegistry {
    INSTANCE;

    public static final String DIFF_FILTER_EXTENSION_POINT = "org.eclipse.emf.compare.ui.diff.filter";
    public static final String FILTERING_ADDED_ELEMENTS_ID = "addElements";
    public static final String FILTERING_REMOVED_ELEMENTS_ID = "removedElements";
    public static final String FILTERING_MOVED_ELEMENTS_ID = "movedElements";
    public static final String FILTERING_CHANGED_ELEMENTS_ID = "changedElements";
    private static final String SEPARATOR = ";";
    private final Map<String, DifferenceFilterDescriptor> storage = new HashMap<String, DifferenceFilterDescriptor>();

    public void parseInitialContributions() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(DIFF_FILTER_EXTENSION_POINT).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                this.addExtension(configElements[j]);
                ++j;
            }
            ++i;
        }
    }

    public synchronized List<DifferenceFilterDescriptor> getDescriptors() {
        return new ArrayList<DifferenceFilterDescriptor>(this.storage.values());
    }

    public synchronized void addExtension(IConfigurationElement element) {
        DifferenceFilterDescriptor desc = new DifferenceFilterDescriptor(element);
        this.storage.put(desc.getID(), desc);
    }

    public synchronized void removeExtension(IConfigurationElement element) {
        DifferenceFilterDescriptor desc = new DifferenceFilterDescriptor(element);
        this.storage.remove(desc.getID());
    }

    public synchronized void clearRegistry() {
        this.storage.clear();
    }

    public DifferenceFilterDescriptor getDescriptor(String id) {
        return this.storage.get(id);
    }

    public String getDescriptors(List<DifferenceFilterDescriptor> descriptors) {
        boolean firstElement = true;
        StringBuffer result = new StringBuffer();
        for (DifferenceFilterDescriptor desc : descriptors) {
            if (!firstElement) {
                result.append(SEPARATOR);
            }
            result.append(desc.getID());
            firstElement = false;
        }
        return result.toString();
    }

    public List<DifferenceFilterDescriptor> getDescriptors(String descriptors) {
        String[] values;
        ArrayList<DifferenceFilterDescriptor> result = new ArrayList<DifferenceFilterDescriptor>();
        String[] stringArray = values = descriptors.split(SEPARATOR);
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            DifferenceFilterDescriptor desc = this.getDescriptor(value);
            if (desc != null) {
                result.add(desc);
            }
            ++n2;
        }
        return result;
    }

    public List<IDifferenceFilter> getFilters(String descriptors) {
        ArrayList<IDifferenceFilter> result = new ArrayList<IDifferenceFilter>();
        for (DifferenceFilterDescriptor desc : this.getDescriptors(descriptors)) {
            result.add(desc.getExtension());
        }
        return result;
    }
}

