/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui.builder;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xcore.ui.internal.XcoreActivator;
import org.eclipse.xtext.builder.BuilderParticipant;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.resource.IResourceDescription;
import org.osgi.framework.Bundle;

public class XcoreBuildParticipant
extends BuilderParticipant {
    protected Set<IProject> newProjects = Sets.newLinkedHashSet();

    public void build(IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        super.build(context, monitor);
        final HashSet createdProjects = Sets.newHashSet();
        for (IProject newProject : this.newProjects) {
            if (!newProject.exists()) continue;
            createdProjects.add(newProject);
        }
        if (!createdProjects.isEmpty()) {
            final Bundle bundle = XcoreActivator.getInstance().getBundle();
            Job job = new Job(Platform.getResourceBundle((Bundle)bundle).getString("_UI_NewProjectBuild_job")){

                protected IStatus run(IProgressMonitor monitor) {
                    for (IProject project : createdProjects) {
                        try {
                            project.build(10, monitor);
                        }
                        catch (CoreException exception) {
                            return new Status(exception.getStatus().getSeverity(), bundle.getSymbolicName(), exception.getMessage(), (Throwable)exception);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(40);
            job.schedule();
        }
        this.newProjects.clear();
    }

    protected void handleChangedContents(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, EclipseResourceFileSystemAccess2 fileSystemAccess) throws CoreException {
        Resource resource = context.getResourceSet().getResource(delta.getUri(), true);
        GenModel genModel = (GenModel)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)GenModelPackage.Literals.GEN_MODEL);
        IWorkspaceRoot root = context.getBuiltProject().getWorkspace().getRoot();
        if (genModel != null) {
            String[] stringArray = new String[]{genModel.getEditProjectDirectory(), genModel.getEditorProjectDirectory(), genModel.getTestsProjectDirectory()};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project;
                String projectName = stringArray[n2];
                if (!Strings.isNullOrEmpty((String)projectName) && !(project = root.getProject(projectName)).exists()) {
                    this.newProjects.add(project);
                }
                ++n2;
            }
        }
        super.handleChangedContents(delta, context, fileSystemAccess);
    }
}

