/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui.contentassist;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xcore.XPackage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.xtext.common.types.xtext.ui.JdtTypesProposalProvider;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.impl.QualifiedNameValueConverter;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportingTypesProposalProvider
extends JdtTypesProposalProvider {
    @Inject
    private QualifiedNameValueConverter qualifiedNameValueConverter;

    protected ConfigurableCompletionProposal.IReplacementTextApplier createTextApplier(ContentAssistContext context, IScope typeScope, IQualifiedNameConverter qualifiedNameConverter, IValueConverter<String> valueConverter) {
        return new FQNImporter((Resource)context.getResource(), context.getViewer(), typeScope, qualifiedNameConverter, valueConverter, this.qualifiedNameValueConverter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FQNImporter
    extends JdtTypesProposalProvider.FQNShortener {
        private final ITextViewer viewer;
        private final QualifiedNameValueConverter importConverter;

        public FQNImporter(Resource context, ITextViewer viewer, IScope scope, IQualifiedNameConverter qualifiedNameConverter, IValueConverter<String> valueConverter, QualifiedNameValueConverter importConverter) {
            super(context, scope, qualifiedNameConverter, valueConverter);
            this.viewer = viewer;
            this.importConverter = importConverter;
        }

        public void apply(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
            QualifiedName qualifiedName;
            String replacementString;
            String proposalReplacementString;
            String typeName = proposalReplacementString = proposal.getReplacementString();
            if (this.valueConverter != null) {
                typeName = (String)this.valueConverter.toValue(proposalReplacementString, null);
            }
            if (!proposalReplacementString.equals(replacementString = this.getActualReplacementString(proposal))) {
                QualifiedName shortQualifiedName;
                String shortTypeName = replacementString;
                if (this.valueConverter != null) {
                    shortTypeName = (String)this.valueConverter.toValue(replacementString, null);
                }
                if ((shortQualifiedName = this.qualifiedNameConverter.toQualifiedName(shortTypeName)).getSegmentCount() == 1) {
                    proposal.setCursorPosition(replacementString.length());
                    document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), replacementString);
                    return;
                }
            }
            if ((qualifiedName = this.qualifiedNameConverter.toQualifiedName(typeName)).getSegmentCount() == 1) {
                proposal.setCursorPosition(proposalReplacementString.length());
                document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), proposalReplacementString);
                return;
            }
            IEObjectDescription description = this.scope.getSingleElement(qualifiedName.skipFirst(qualifiedName.getSegmentCount() - 1));
            if (description != null) {
                proposal.setCursorPosition(proposalReplacementString.length());
                document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), proposalReplacementString);
                return;
            }
            String shortName = qualifiedName.getLastSegment();
            int topPixel = -1;
            StyledText widget = this.viewer.getTextWidget();
            if (widget != null) {
                topPixel = widget.getTopPixel();
            }
            ITextViewerExtension viewerExtension = null;
            if (this.viewer instanceof ITextViewerExtension) {
                viewerExtension = (ITextViewerExtension)this.viewer;
                viewerExtension.setRedraw(false);
            }
            try {
                int offset = 0;
                boolean startWithLineBreak = true;
                boolean endWithLineBreak = false;
                XPackage file = (XPackage)this.context.getContents().get(0);
                EList importDirectives = file.getImportDirectives();
                if (importDirectives.isEmpty()) {
                    startWithLineBreak = false;
                    EList annotationDirectives = file.getAnnotationDirectives();
                    if (annotationDirectives.isEmpty()) {
                        EList classifiers = file.getClassifiers();
                        if (classifiers.isEmpty()) {
                            offset = document.getLength();
                        } else {
                            ICompositeNode node = NodeModelUtils.getNode((EObject)((EObject)classifiers.get(0)));
                            offset = node.getOffset();
                            endWithLineBreak = true;
                        }
                    } else {
                        ICompositeNode node = NodeModelUtils.getNode((EObject)((EObject)annotationDirectives.get(0)));
                        offset = node.getOffset();
                        endWithLineBreak = true;
                    }
                } else {
                    ICompositeNode node = NodeModelUtils.getNode((EObject)((EObject)importDirectives.get(importDirectives.size() - 1)));
                    offset = node.getOffset() + node.getLength();
                }
                offset = Math.min(proposal.getReplacementOffset(), offset);
                String escapedShortname = shortName;
                if (this.valueConverter != null) {
                    escapedShortname = this.valueConverter.toString((Object)shortName);
                }
                proposal.setCursorPosition(escapedShortname.length());
                document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), escapedShortname);
                int lineOfOffset = document.getLineOfOffset(offset);
                String lineDelimiter = document.getLineDelimiter(lineOfOffset);
                if (lineDelimiter == null && lineOfOffset > 0) {
                    lineDelimiter = document.getLineDelimiter(lineOfOffset - 1);
                }
                String importStatement = String.valueOf(startWithLineBreak ? lineDelimiter : "") + "import " + this.importConverter.toString(typeName);
                if (endWithLineBreak) {
                    importStatement = String.valueOf(importStatement) + lineDelimiter + lineDelimiter;
                }
                document.replace(offset, 0, importStatement.toString());
                proposal.setCursorPosition(proposal.getCursorPosition() + importStatement.length());
                if (widget != null) {
                    int additionalTopPixel = 0;
                    if (startWithLineBreak) {
                        additionalTopPixel += widget.getLineHeight();
                    }
                    if (endWithLineBreak) {
                        additionalTopPixel += 2 * widget.getLineHeight();
                    }
                    widget.setTopPixel(topPixel + additionalTopPixel);
                }
            }
            finally {
                if (viewerExtension != null) {
                    viewerExtension.setRedraw(true);
                }
            }
        }
    }
}

