/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.common.ui.internal.controls;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.common.core.internal.builder.AbstractEmfFacetCatalog;
import org.eclipse.emf.facet.infra.common.ui.internal.EmfFacetCommonUIPlugin;
import org.eclipse.emf.facet.infra.common.ui.internal.controls.Tooltip;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class EObjectErrorPainter {
    private static final String DATA_KEY_ERROR_MARKER = "errorMarker";
    private final IEditorInput editorInput;
    private final EditingDomain editingDomain;

    public EObjectErrorPainter(IEditorInput editorInput, EditingDomain editingDomain) {
        this.editorInput = editorInput;
        this.editingDomain = editingDomain;
    }

    public IMarker getError(EObject eObject) {
        block7: {
            IFile file;
            block8: {
                if (!(this.editorInput instanceof IFileEditorInput)) break block7;
                IFileEditorInput fileEditorInput = (IFileEditorInput)this.editorInput;
                file = fileEditorInput.getFile();
                if (file.exists()) break block8;
                return null;
            }
            try {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 1);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    String uriAttribute;
                    IMarker marker = iMarkerArray[n2];
                    if ((marker.getType().equals("org.eclipse.emf.ecore.diagnostic") || marker.getType().equals(AbstractEmfFacetCatalog.BROKEN_REF_MARKER)) && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                        EObject objectWithURI;
                        URI uri = URI.createURI((String)uriAttribute);
                        String encoded = uri.toString().replaceAll(" ", "%20");
                        if (!encoded.equals(uri.toString())) {
                            uri = URI.createURI((String)encoded);
                        }
                        if (eObject == (objectWithURI = this.editingDomain.getResourceSet().getEObject(uri, true))) {
                            return marker;
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (Plugin)EmfFacetCommonUIPlugin.getDefault());
            }
        }
        return null;
    }

    public void installOn(Tree tree) {
        tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                EObjectErrorPainter.this.handlePaintError(event);
            }
        });
        tree.setToolTipText("");
        this.addTooltip(tree);
    }

    protected void handlePaintError(Event event) {
        TreeItem item = (TreeItem)event.item;
        Object data = item.getData();
        if (data instanceof Resource) {
            Resource resource = (Resource)data;
            EList contents = resource.getContents();
            for (EObject eObject : contents) {
                EObjectMarker marker = this.firstMarker(eObject);
                if (marker == null) continue;
                this.paintError(event);
            }
        } else if (data instanceof EObject) {
            EObject eObject = (EObject)data;
            EObjectMarker marker = this.firstMarker(eObject);
            if (marker != null) {
                if (marker.eObject == eObject) {
                    item.setData(DATA_KEY_ERROR_MARKER, (Object)marker.marker);
                }
                this.paintError(event);
            } else {
                item.setData(DATA_KEY_ERROR_MARKER, null);
            }
        }
    }

    private void paintError(Event event) {
        Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
        event.gc.drawImage(image, event.x - 2, event.y + event.height - image.getBounds().height);
    }

    private EObjectMarker firstMarker(EObject eObject) {
        LinkedList<EObject> elements = new LinkedList<EObject>();
        elements.add(eObject);
        while (!elements.isEmpty()) {
            EObject e = (EObject)elements.removeFirst();
            IMarker marker = this.getError(e);
            if (marker != null) {
                EObjectMarker eObjectMarker = new EObjectMarker();
                eObjectMarker.eObject = e;
                eObjectMarker.marker = marker;
                return eObjectMarker;
            }
            elements.addAll((Collection<EObject>)e.eContents());
        }
        return null;
    }

    private void addTooltip(Tree tree) {
        Tooltip tooltip = new Tooltip(){

            protected void onHover(TreeItem item) {
                Display display = Display.getCurrent();
                Object data = item.getData(EObjectErrorPainter.DATA_KEY_ERROR_MARKER);
                if (data instanceof IMarker) {
                    IMarker marker = (IMarker)data;
                    String text = null;
                    try {
                        text = (String)marker.getAttribute("message");
                    }
                    catch (CoreException e) {
                        Logger.logError((Throwable)e, (Plugin)EmfFacetCommonUIPlugin.getDefault());
                    }
                    if (text != null) {
                        this.createTooltip(display, text, item);
                    }
                }
            }
        };
        tooltip.installOn(tree);
    }

    private final class EObjectMarker {
        private EObject eObject;
        private IMarker marker;

        private EObjectMarker() {
        }
    }
}

