/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.common.ui.internal.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.infra.common.core.internal.utils.FileUtils;
import org.eclipse.emf.facet.infra.common.core.internal.utils.IFilter;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ProjectUtils;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.osgi.framework.Bundle;

public abstract class AbstractExampleWizard
extends Wizard
implements INewWizard {
    private static final String CHECKSTYLE_NATURE = "net.sf.eclipsecs.core.CheckstyleNature";
    private static final String CHECKSTYLE_BUILDER = "net.sf.eclipsecs.core.CheckstyleBuilder";
    private final IFilter checkstyleFilter = new IFilter(){

        public boolean filter(Object object) {
            boolean result = true;
            if (object instanceof File) {
                File file = (File)object;
                result = !file.getName().equals(".checkstyle");
            } else if (object instanceof String) {
                String str = (String)object;
                result = !str.equals(".checkstyle");
            }
            return result;
        }
    };

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected abstract Plugin getActivator();

    public boolean performFinish() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    AbstractExampleWizard.this.beforeImport();
                    IProject project = ProjectUtils.importPlugin((Bundle)AbstractExampleWizard.this.getActivator().getBundle(), (IFilter)AbstractExampleWizard.this.checkstyleFilter);
                    AbstractExampleWizard.this.removeWizardExtension(project);
                    AbstractExampleWizard.this.removeCheckstyleNatureAndBuilder(project);
                    AbstractExampleWizard.this.changeBundleId(project);
                    AbstractExampleWizard.this.afterImport(project);
                }
                catch (Exception e) {
                    Logger.logError((Throwable)e, (Plugin)AbstractExampleWizard.this.getActivator());
                }
            }
        };
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)operation);
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)this.getActivator());
            return false;
        }
        return true;
    }

    private void removeWizardExtension(IProject project) {
        try {
            boolean success = false;
            IFile pluginXML = project.getFile("plugin.xml");
            if (pluginXML.exists()) {
                int end;
                String contents = FileUtils.readInputStream((InputStream)pluginXML.getContents(true));
                String startStr = "<extension point=\"org.eclipse.ui.newWizards\">";
                String endStr = "</extension>";
                int start = contents.indexOf("<extension point=\"org.eclipse.ui.newWizards\">");
                if (start != -1 && (end = contents.indexOf("</extension>", start + "<extension point=\"org.eclipse.ui.newWizards\">".length())) != -1) {
                    String result = String.valueOf(contents.substring(0, start)) + contents.substring(end += "</extension>".length(), contents.length());
                    pluginXML.setContents((InputStream)new ByteArrayInputStream(result.getBytes()), true, true, (IProgressMonitor)new NullProgressMonitor());
                    success = true;
                }
            }
            if (!success) {
                Logger.logWarning((String)("Couldn't clean " + pluginXML.getFullPath()), (Plugin)this.getActivator());
            }
        }
        catch (Exception e) {
            Logger.logError((String)"Error cleaning plugin.xml", (Plugin)this.getActivator());
        }
    }

    private void removeCheckstyleNatureAndBuilder(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            ArrayList<String> list = new ArrayList<String>();
            String[] stringArray = natures;
            int n = natures.length;
            int n2 = 0;
            while (n2 < n) {
                String nature = stringArray[n2];
                if (!CHECKSTYLE_NATURE.equals(nature)) {
                    list.add(nature);
                }
                ++n2;
            }
            description.setNatureIds(list.toArray(new String[list.size()]));
            ICommand[] oldBuildSpec = description.getBuildSpec();
            ArrayList<ICommand> newBuildSpec = new ArrayList<ICommand>();
            ICommand[] iCommandArray = oldBuildSpec;
            int n3 = oldBuildSpec.length;
            int n4 = 0;
            while (n4 < n3) {
                ICommand command = iCommandArray[n4];
                if (!CHECKSTYLE_BUILDER.equals(command.getBuilderName())) {
                    newBuildSpec.add(command);
                }
                ++n4;
            }
            description.setBuildSpec(newBuildSpec.toArray(new ICommand[newBuildSpec.size()]));
            project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Logger.logError((String)"Error cleaning example project", (Plugin)this.getActivator());
        }
    }

    private void changeBundleId(IProject project) {
        try {
            IFile manifestFile = project.getFile("META-INF/MANIFEST.MF");
            if (manifestFile.exists()) {
                String contents = FileUtils.readInputStream((InputStream)manifestFile.getContents(true));
                contents = contents.replaceFirst("Bundle-SymbolicName:\\s*org\\.eclipse\\.gmt\\.", "Bundle-SymbolicName: ");
                manifestFile.setContents((InputStream)new ByteArrayInputStream(contents.getBytes()), true, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            Logger.logError((String)"Error changing imported bundle id", (Plugin)this.getActivator());
        }
    }

    protected void beforeImport() {
    }

    protected void afterImport(IProject project) {
    }
}

