/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.facet.infra.query.core.exception;

import org.eclipse.core.resources.IProject;
import org.osgi.framework.Bundle;

/**
 * @deprecated use the new eFacet2 metamodel in org.eclipse.emf.facet.efacet2.metamodel
 *             and the new APIs in org.eclipse.emf.facet.efacet.core
 */
@Deprecated
public class BundleClassPathException extends ModelQueryException {

	private static final long serialVersionUID = 8664502897169666916L;
	
	private final IProject project;
	private final Bundle bundle;

	public IProject getProject() {
		return this.project;
	}

	public Bundle getBundle() {
		return this.bundle;
	}

	public BundleClassPathException(final IProject project, final Bundle localBundle) {
		super(
				"The output location of the Java project '" + project.getName() + "' was not found in its Bundle-ClassPath. " + //$NON-NLS-1$//$NON-NLS-2$
						"This prevents the Java queries implementations it contains from being loaded."); //$NON-NLS-1$
		this.project = project;
		this.bundle = localBundle;
	}
}
