/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Grgoire Dup (Mia-Software)
 *     Nicolas Bros (Mia-Software)
 *******************************************************************************/
package org.eclipse.emf.facet.infra.query.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.common.ui.internal.util.WorkbenchUtils;
import org.eclipse.emf.facet.infra.query.JavaModelQuery;
import org.eclipse.emf.facet.infra.query.editor.presentation.QueryEditor;
import org.eclipse.emf.facet.infra.query.ui.Activator;
import org.eclipse.emf.facet.infra.query.ui.Messages;
import org.eclipse.emf.facet.infra.query.ui.exceptions.ClassAlreadyExistsException;
import org.eclipse.emf.facet.infra.query.ui.exceptions.ResourceURIExpectedException;
import org.eclipse.emf.facet.infra.query.ui.wizards.NewClassCreationWizard;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

/**
 * 
 * @author Gregoire Dupe (Mia-Software)
 * @deprecated use the new eFacet2 metamodel in org.eclipse.emf.facet.efacet2.metamodel
 *             and the new APIs in org.eclipse.emf.facet.efacet.ui
 */
@Deprecated
public class CreateJavaQueryImplClassAction implements IActionDelegate {

	private ISelection fSelection;

	public void run(final IAction action) {
		List<JavaModelQuery> selectedQueries = new ArrayList<JavaModelQuery>();
		if (this.fSelection instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection) this.fSelection;
			Iterator<?> iterator = structuredSelection.iterator();
			while (iterator.hasNext()) {
				Object selectedElement = iterator.next();
				if (selectedElement instanceof JavaModelQuery) {
					JavaModelQuery element = (JavaModelQuery) selectedElement;
					selectedQueries.add(element);
				}
			}
		}
		for (JavaModelQuery query : selectedQueries) {
			try {
				EditingDomain editingDomain = null;
				// if using the action on an open query set editor, edit the
				// editor's resource instead of modifying the underlying file
				IWorkbenchPart activePart = WorkbenchUtils.getActivePart();
				if (activePart instanceof QueryEditor) {
					QueryEditor queryEditor = (QueryEditor) activePart;
					ResourceSet resourceSet = queryEditor.getEditingDomain().getResourceSet();
					if (resourceSet.getResources().contains(query.eResource())) {
						editingDomain = queryEditor.getEditingDomain();
					}
				}

				NewClassCreationWizard wizard = new NewClassCreationWizard(query, editingDomain);
				IWorkbench workbench = Activator.getDefault().getWorkbench();
				IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
				Shell shell = window.getShell();
				WizardDialog dialog = new WizardDialog(shell, wizard);
				dialog.create();
				dialog.open();
			} catch (ResourceURIExpectedException e) {
				MessageDialog.openError(Activator.getDefault().getWorkbench()
						.getActiveWorkbenchWindow().getShell(),
						Messages.CreateJavaQueryImplClass_cannotCreate,
						Messages.CreateJavaQueryImplClass_modelURIMustBePlatform);
				Logger.logError(e, Activator.getDefault());
			} catch (ClassAlreadyExistsException e) {
				MessageDialog.openError(Activator.getDefault().getWorkbench()
						.getActiveWorkbenchWindow().getShell(),
						Messages.CreateJavaQueryImplClass_cannotCreateImplClass,
						Messages.CreateJavaQueryImplClass_implClassAlreadyExists);
				Logger.logError(e, Activator.getDefault());
			} catch (Exception e) {
				MessageDialog.openError(Activator.getDefault().getWorkbench()
						.getActiveWorkbenchWindow().getShell(),
						Messages.CreateJavaQueryImplClass_unknownError,
						Messages.CreateJavaQueryImplClass_cannotCreateImplClass2);
				Logger.logError(e, Activator.getDefault());
			}
		}
	}

	public void selectionChanged(final IAction action, final ISelection selection) {
		this.fSelection = selection;
	}

}
