/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.facet.widgets.internal.ImageProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.internal.IColumnsToHideDialog;
import org.eclipse.emf.facet.widgets.nattable.internal.IPutOnTheTopQuestionDialog;
import org.eclipse.emf.facet.widgets.nattable.internal.Messages;
import org.eclipse.emf.facet.widgets.nattable.internal.SortedColumnContentProvider;
import org.eclipse.emf.facet.widgets.nattable.internal.dialogs.PutOnTheTopQuestionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class ColumnsToHideDialog
extends SelectionDialog
implements IColumnsToHideDialog {
    private final Object inputElement;
    private final ILabelProvider labelProvider;
    private final SortedColumnContentProvider contentProvider;
    private CheckboxTableViewer listViewer;
    private static final int DIALOG_WIDTH = 300;
    private static final int DIALOG_HEIGHT = 300;
    private boolean setAtTheTop;
    private List<Column> initialSelection;
    private final boolean askToPutOnTheTopTheLocalCustomization;
    private boolean mustAskTheUserNextTime;
    private PutOnTheTopQuestionDialog putOnTheTopQuestionDialog;

    public ColumnsToHideDialog(Shell parentShell, Object input, ILabelProvider labelProvider, SortedColumnContentProvider contentProvider, boolean askToPutOnTheTopTheLocalCustomization, boolean localCustomizationMustBeOnTheTop) {
        super(parentShell);
        this.setTitle(Messages.NatTableWidget_selectColumnToShowHide);
        this.inputElement = input;
        this.labelProvider = labelProvider;
        this.contentProvider = contentProvider;
        this.setAtTheTop = localCustomizationMustBeOnTheTop;
        this.askToPutOnTheTopTheLocalCustomization = askToPutOnTheTopTheLocalCustomization;
    }

    private void checkInitialSelections() {
        Iterator itemsToCheck = this.getInitialElementSelections().iterator();
        while (itemsToCheck.hasNext()) {
            this.listViewer.setChecked(itemsToCheck.next(), true);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setImage(ImageProvider.getInstance().getSelectColumnsToHide());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createMessageArea(composite);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 300;
        data.widthHint = 300;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.addSelectionButtons(composite);
        this.listViewer.setInput(this.inputElement);
        if (!this.getInitialElementSelections().isEmpty()) {
            this.checkInitialSelections();
        }
        final Button cbSort = new Button(composite, 32);
        cbSort.setText("Sort Columns By Name");
        cbSort.pack();
        cbSort.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnsToHideDialog.this.contentProvider.setIsSorted(cbSort.getSelection());
                ColumnsToHideDialog.this.getViewer().refresh();
            }
        });
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected CheckboxTableViewer getViewer() {
        return this.listViewer;
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Button selectButton = this.createButton(buttonComposite, 18, "&Select All", false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnsToHideDialog.this.selectAll();
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, "&Deselect All", false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnsToHideDialog.this.deselectAll();
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    public int open() {
        if (this.askToPutOnTheTopTheLocalCustomization) {
            this.putOnTheTopQuestionDialog = this.openPutOnTheTopQuestionDialog();
        }
        this.initialSelection = this.getVisibleColumns(this.setAtTheTop);
        this.setInitialElementSelections(this.initialSelection);
        return super.open();
    }

    private PutOnTheTopQuestionDialog openPutOnTheTopQuestionDialog() {
        String message = "When you select the hidden columns, the information is stored in a local uiCustom file. This file needs to be on the top of the custom stack to be correctly applied.\n\nSet the local custom file at the top of the custom stack ?";
        String toggleMessage = "Don't display this warning the next time and save the answer.";
        final PutOnTheTopQuestionDialog dialog = new PutOnTheTopQuestionDialog(this.getShell(), Messages.NatTableWidget_selectColumnToShowHide, ImageProvider.getInstance().getSelectColumnsToHide(), message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, toggleMessage, false){

            public boolean close() {
                ColumnsToHideDialog.this.setAtTheTop = this.getUserAnswer();
                ColumnsToHideDialog.this.mustAskTheUserNextTime = this.getMustAskTheUserNextTime();
                return super.close();
            }
        };
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog;
    }

    @Override
    public boolean getPutOnTheTop() {
        return this.setAtTheTop;
    }

    public List<Column> getInitialSelection() {
        return this.initialSelection;
    }

    @Override
    public IPutOnTheTopQuestionDialog getPutOnTheTopQuestionDialog() {
        return this.putOnTheTopQuestionDialog;
    }

    @Override
    public void ok() {
        this.okPressed();
    }

    public abstract List<Column> getVisibleColumns(boolean var1);

    @Override
    public List<Column> getSelectedColumns() {
        ArrayList<Column> resultList = new ArrayList<Column>();
        Object[] objectArray = this.getResult();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object result = objectArray[n2];
            if (result instanceof Column) {
                Column column = (Column)result;
                resultList.add(column);
            }
            ++n2;
        }
        return resultList;
    }

    @Override
    public boolean getMustAskTheUserNextTime() {
        return this.mustAskTheUserNextTime;
    }

    @Override
    public void selectAll() {
        this.getViewer().setAllChecked(true);
    }

    @Override
    public void deselectAll() {
        this.getViewer().setAllChecked(false);
    }

    protected void okPressed() {
        Object[] children = this.contentProvider.getElements(this.inputElement);
        if (children != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < children.length) {
                Object element = children[i];
                if (this.listViewer.getChecked(element)) {
                    list.add(element);
                }
                ++i;
            }
            this.setResult(list);
        }
        super.okPressed();
    }
}

