/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TableFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TablePackage;
import org.eclipse.emf.facet.widgets.table.ui.internal.CustomizationUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.ITableCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.internal.TableInstanceUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.command.BrutalListSetCommand;
import org.eclipse.emf.facet.widgets.table.ui.internal.comparator.RowComparator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ColumnSortDirection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.TableWidgetRuntimeException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableCommandFactory
implements ITableCommandFactory {
    private final Table table;
    private final EditingDomain editingDomain;
    private final ICommandFactory commandFactory;
    private final IFacetManager facetManager;

    public TableCommandFactory(Table table, EditingDomain editingDomain, ICommandFactory commandFactory, IFacetManager facetManager) {
        this.table = table;
        this.editingDomain = editingDomain;
        this.commandFactory = commandFactory;
        this.facetManager = facetManager;
    }

    @Override
    public Command createSetLoadedFacetSetsCommand(List<FacetSet> facetSets) {
        return this.createSetLoadedFacetSetsCommand(facetSets, true);
    }

    public Command createSetLoadedFacetSetsCommand(List<FacetSet> facetSets, boolean manageCustoms) {
        CommandList commandList = new CommandList();
        List<FeatureColumn> columnsToRemove = TableInstanceUtils.columnsToRemove(this.table, facetSets, (List<Row>)this.table.getRows());
        for (Column column : columnsToRemove) {
            Command removeColumnCmd = this.createRemoveColumnCommand(column);
            commandList.add(removeColumnCmd);
        }
        if (!this.table.getFacetSets().equals(facetSets)) {
            Command command = this.commandFactory.createSetCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_FacetSets(), facetSets);
            commandList.add(command);
        }
        LinkedList<Customization> linkedList = new LinkedList<Customization>();
        for (FacetSet facetSet : facetSets) {
            if (!(facetSet instanceof Customization)) continue;
            Customization custom = (Customization)facetSet;
            linkedList.add(custom);
        }
        if (manageCustoms) {
            ArrayList removedFacetSet = new ArrayList();
            removedFacetSet.addAll(this.table.getFacetSets());
            removedFacetSet.removeAll(facetSets);
            LinkedList<Customization> removedCustoms = new LinkedList<Customization>();
            for (FacetSet facetSet : removedFacetSet) {
                if (!(facetSet instanceof Customization)) continue;
                Customization custom = (Customization)facetSet;
                removedCustoms.add(custom);
            }
            if (!linkedList.isEmpty() || !removedCustoms.isEmpty()) {
                ArrayList<Customization> customizations = new ArrayList<Customization>();
                customizations.addAll((Collection<Customization>)this.table.getCustomizations());
                customizations.removeAll(removedCustoms);
                customizations.addAll(linkedList);
                Command loadCustom = this.createCoreSetCustomizationsCommand(customizations);
                commandList.add(loadCustom);
            }
        }
        return TableCommandFactory.createResult(commandList, "Set loaded facetSets");
    }

    private static Command createResult(List<Command> commandList, String label) {
        CompoundCommand result = null;
        while (commandList.contains(null)) {
            commandList.remove(null);
        }
        if (!commandList.isEmpty()) {
            result = new CompoundCommand(label, commandList);
        }
        return result;
    }

    @Override
    public Command createRemoveColumnCommand(Column column) {
        ArrayList<Command> commandList = new ArrayList<Command>();
        if (this.table.getColumns().contains((Object)column)) {
            Command command = this.commandFactory.createRemoveCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_Columns(), (Object)column);
            commandList.add(command);
        }
        return TableCommandFactory.createResult(commandList, "Remove column");
    }

    @Override
    public Command createAddColumnCommand(List<ETypedElement> eTypedElements, List<FacetSet> facetSets) {
        CommandList commandList = new CommandList();
        LinkedHashSet<FacetSet> newFacetSets = new LinkedHashSet<FacetSet>();
        newFacetSets.addAll(facetSets);
        newFacetSets.addAll((Collection<FacetSet>)this.table.getFacetSets());
        for (ETypedElement eTypedElement : eTypedElements) {
            FacetSet signatureFS = TableCommandFactory.getSignatureFacetSet(eTypedElement);
            if (signatureFS == null) continue;
            newFacetSets.add(signatureFS);
        }
        Command addFacetCommand = this.createSetLoadedFacetSetsCommand(new ArrayList<FacetSet>(newFacetSets));
        commandList.add(addFacetCommand);
        Command addColumn = this.createAddColumn(eTypedElements);
        commandList.add(addColumn);
        return TableCommandFactory.createResult(commandList, "Add columns and facetSets");
    }

    private static FacetSet getSignatureFacetSet(ETypedElement eTypedElement) {
        FacetSet result = null;
        if (eTypedElement instanceof DerivedTypedElement) {
            DerivedTypedElement signatureTE;
            DerivedTypedElement derivedTE = (DerivedTypedElement)eTypedElement;
            try {
                signatureTE = FacetUtils.getTopOverrideFeature((DerivedTypedElement)derivedTE);
            }
            catch (FacetManagerException e) {
                throw new TableWidgetRuntimeException(e);
            }
            if (derivedTE.getOverride() != null && signatureTE != null) {
                FacetSet signatureFS;
                result = signatureFS = FacetUtils.getFacetSet((ETypedElement)signatureTE);
            }
        }
        return result;
    }

    private Command createAddColumn(List<ETypedElement> eTypedElements) {
        CommandList commandList = new CommandList();
        for (ETypedElement eTypedElement : eTypedElements) {
            Command addColumn = this.createAddColumn(eTypedElement);
            commandList.add(addColumn);
        }
        return TableCommandFactory.createResult(commandList, "Add columns");
    }

    private Command createAddColumn(ETypedElement eTypedElement) {
        ETypedElement signature = eTypedElement;
        if (eTypedElement instanceof FacetOperation) {
            FacetOperation facetOperation = (FacetOperation)eTypedElement;
            signature = FacetUtils.getSignature((FacetOperation)facetOperation);
        }
        Column existingColumn = null;
        for (Column column : this.table.getColumns()) {
            FeatureColumn featureColumn;
            if (!(column instanceof FeatureColumn) || !(featureColumn = (FeatureColumn)column).getFeature().equals(signature)) continue;
            existingColumn = column;
            break;
        }
        CommandList commandList = new CommandList();
        if (existingColumn == null) {
            FeatureColumn column = TableFactory.eINSTANCE.createFeatureColumn();
            Command setColumn = this.commandFactory.createAddCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_Columns(), (Object)column);
            commandList.add(setColumn);
            Command setETypedElement = this.commandFactory.createSetCommand(this.editingDomain, (Object)column, (Object)TablePackage.eINSTANCE.getFeatureColumn_Feature(), (Object)signature);
            commandList.add(setETypedElement);
        }
        return TableCommandFactory.createResult(commandList, "Add column");
    }

    @Override
    public Command createSetCustomizationCommand(List<Customization> customizations) {
        CommandList commandList = new CommandList();
        Set<FacetSet> referredFS = CustomizationUtils.findFacetsCustomizedBy(customizations);
        EList alreadyLoaded = this.table.getFacetSets();
        ArrayList removedCustoms = new ArrayList();
        removedCustoms.addAll(this.table.getCustomizations());
        removedCustoms.removeAll(customizations);
        ArrayList<FacetSet> facetSets = new ArrayList<FacetSet>();
        facetSets.addAll(customizations);
        facetSets.removeAll((Collection<?>)alreadyLoaded);
        facetSets.addAll((Collection<FacetSet>)alreadyLoaded);
        facetSets.removeAll(referredFS);
        facetSets.addAll(referredFS);
        facetSets.removeAll(removedCustoms);
        Command facetLoad = this.createSetLoadedFacetSetsCommand(facetSets, false);
        commandList.add(facetLoad);
        Command customLoad = this.createCoreSetCustomizationsCommand(customizations);
        commandList.add(customLoad);
        return TableCommandFactory.createResult(commandList, "Load cutomizations and associated facet sets");
    }

    private Command createCoreSetCustomizationsCommand(List<Customization> customizations) {
        ArrayList<Customization> sortedCustoms = new ArrayList<Customization>();
        sortedCustoms.addAll((Collection<Customization>)this.table.getLocalCustomizations());
        for (Customization customization : customizations) {
            if (sortedCustoms.contains(customization)) continue;
            sortedCustoms.add(customization);
        }
        CommandList commandList = new CommandList();
        if (!this.table.getCustomizations().equals(sortedCustoms)) {
            Command command = this.commandFactory.createSetCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_Customizations(), sortedCustoms);
            commandList.add(command);
        }
        return TableCommandFactory.createResult(commandList, "Set loaded cutomizations");
    }

    @Override
    public Command createRemoveColumnsCommand(List<ETypedElement> elements) {
        ArrayList<Command> commandList = new ArrayList<Command>();
        if (elements != null && !elements.isEmpty()) {
            for (Column column : this.table.getColumns()) {
                FeatureColumn featureColumn;
                if (!(column instanceof FeatureColumn) || !elements.contains((featureColumn = (FeatureColumn)column).getFeature())) continue;
                Command rmCommand = this.commandFactory.createRemoveCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_Columns(), (Object)featureColumn);
                commandList.add(rmCommand);
            }
        }
        return TableCommandFactory.createResult(commandList, NLS.bind((String)"Remove {0} columms", (Object)commandList.size()));
    }

    @Override
    public Command createSortRowCommand(FeatureColumn featureColumn, ColumnSortDirection direction) {
        ArrayList rows = new ArrayList(this.table.getRows());
        ETypedElement eTypedElement = featureColumn.getFeature();
        RowComparator comparator = new RowComparator(eTypedElement, direction, this.facetManager);
        Collections.sort(rows, comparator);
        return new BrutalListSetCommand(this.table, TablePackage.eINSTANCE.getTable_Rows(), rows, Messages.TableCommandFactory_row_sort_label, NLS.bind((String)Messages.TableCommandFactory_row_sort_description, (Object)eTypedElement.getName()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CommandList
    extends LinkedList<Command> {
        private static final long serialVersionUID = 8581553157248060152L;

        CommandList() {
        }

        @Override
        public boolean add(Command command) {
            boolean result = command == null ? false : super.add(command);
            return result;
        }
    }
}

