/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.CustomFactory;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.CustomPackage;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.EClassCustomization;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.FacetCustomization;
import org.eclipse.emf.facet.custom.ui.internal.exported.ICustomizationCommandFactory;
import org.eclipse.emf.facet.custom.ui.internal.exported.ICustomizationCommandFactoryFactory;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.EFacetPackage;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.query.FalseLiteralQuery;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.query.IsOneOfQuery;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.query.QueryFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.query.QueryPackage;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.emf.core.EmfDebugUtils;
import org.eclipse.emf.facet.util.emf.core.command.ICommandFactoryResult;
import org.eclipse.emf.facet.util.emf.core.command.ICommandFactoryResultFactory;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.SourceColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TableFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TablePackage;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.CustomizationUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.internal.TableInstanceUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.TableWidgetController;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IPositionCoordinate;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.MultiModelQueryException;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.TableWidgetRuntimeException;
import org.eclipse.jface.viewers.IStructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableInstanceCommandFactory {
    protected static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());

    public static Command createLoadCustomizationsCommand(List<Customization> customizationsToLoad, boolean mustLoadRequiredFacets, TableWidgetController controller) {
        Command loadCustomCmd;
        ArrayList<Command> cmds = new ArrayList<Command>();
        if (mustLoadRequiredFacets) {
            Command facetLoad;
            ArrayList<FacetSet> facets = new ArrayList<FacetSet>((Collection<FacetSet>)controller.getTable().getFacetSets());
            facets.addAll(CustomizationUtils.findFacetsCustomizedBy(customizationsToLoad));
            try {
                facetLoad = TableInstanceCommandFactory.createSetFacetsCommand(facets, controller);
            }
            catch (CoreException e) {
                throw new TableWidgetRuntimeException(e);
            }
            if (facetLoad != null) {
                cmds.add(facetLoad);
            }
        }
        if ((loadCustomCmd = TableInstanceCommandFactory.createLoadCustomizationsCommand(customizationsToLoad, controller)) != null) {
            cmds.add(loadCustomCmd);
        }
        CompoundCommand result = null;
        if (!cmds.isEmpty()) {
            result = new CompoundCommand(Messages.TableInstanceCommandFactory_customizationLoad, cmds);
        }
        return result;
    }

    public static Command createLoadCustomizationsCommand(List<Customization> customizationsToLoad, TableWidgetController natTableWidget) {
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        List<Customization> localCustomizations = natTableWidget.getLocalCustomizations();
        if (!localCustomizations.isEmpty() && !customizationsToLoad.containsAll(localCustomizations)) {
            customizationsToLoad.addAll(0, localCustomizations);
        }
        Command result = null;
        EList loadedCustomizations = natTableWidget.getTable().getCustomizations();
        if (!customizationsToLoad.isEmpty() && !customizationsToLoad.equals(loadedCustomizations)) {
            result = commandFactory.createSetCommand(natTableWidget.getEditingDomain(), (Object)natTableWidget.getTable(), (Object)TablePackage.eINSTANCE.getTable_Customizations(), customizationsToLoad);
        }
        return result;
    }

    public static Command createDeleteSelectedColumnCommand(TableWidgetController natTableWidget) {
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        CompoundCommand compoundCommand = new CompoundCommand();
        for (Column column : natTableWidget.getSelectedColumns()) {
            Command removeRowCommand = commandFactory.createRemoveCommand(natTableWidget.getEditingDomain(), (Object)natTableWidget.getTable(), (Object)TablePackage.eINSTANCE.getTable_Columns(), (Object)column);
            compoundCommand.append(removeRowCommand);
        }
        return compoundCommand;
    }

    public static Command createDeleteSelectedElementsCommand(TableWidgetController natTableWidget, ICommandFactory commandFactory) throws CoreException {
        HashSet<EObject> toDelete = new HashSet<EObject>();
        List<Object> rawSelection = natTableWidget.getRawSelection();
        for (Object selectedElement : rawSelection) {
            if (!(selectedElement instanceof IGridElement)) continue;
            IGridElement gridElement = (IGridElement)selectedElement;
            try {
                Object value = TableWidgetUtils.getValueOf(gridElement, natTableWidget.getFacetContext());
                if (!(value instanceof EObject)) continue;
                EObject eObject = (EObject)value;
                toDelete.add(eObject);
            }
            catch (FacetManagerException e) {
                Logger.logError((String)"Error getting the value of a grid element to delete", (Plugin)Activator.getDefault());
            }
        }
        CompoundCommand compoundCommand = new CompoundCommand();
        for (EObject eObjectToDelete : toDelete) {
            Command deleteCommand = commandFactory.createDeleteCommand(natTableWidget.getEditingDomain(), (Object)eObjectToDelete);
            compoundCommand.append(deleteCommand);
        }
        DebugUtils.debug((boolean)DEBUG, (String)("compoundCommand.canExecute()=" + compoundCommand.canExecute()));
        return compoundCommand;
    }

    public static Command createRemoveLineCommand(TableWidgetController tableWidgetController) throws CoreException {
        IPositionCoordinate[] selectedCells;
        CompoundCommand compoundCommand = new CompoundCommand();
        ICommandFactory commandFactory = tableWidgetController.getCommandFactory();
        Table tableInstance = tableWidgetController.getTable();
        ArrayList<Integer> toBeRemoved = new ArrayList<Integer>();
        IPositionCoordinate[] iPositionCoordinateArray = selectedCells = tableWidgetController.getSelectedCells2();
        int n = selectedCells.length;
        int n2 = 0;
        while (n2 < n) {
            IPositionCoordinate positionCoordinate = iPositionCoordinateArray[n2];
            if (!toBeRemoved.contains(positionCoordinate.getRowPosition())) {
                toBeRemoved.add(positionCoordinate.getRowPosition());
            }
            ++n2;
        }
        return TableInstanceCommandFactory.createRemoveLinesCommand(tableWidgetController, toBeRemoved);
    }

    public static Command createRemoveLinesCommand(TableWidgetController tableWidgetController, List<Integer> linesToRemove) throws CoreException {
        Table tableInstance = tableWidgetController.getTable();
        ICommandFactory commandFactory = tableWidgetController.getCommandFactory();
        CompoundCommand compoundCommand = new CompoundCommand();
        int i = 0;
        while (i < tableInstance.getRows().size()) {
            if (linesToRemove.contains(i)) {
                Command removeRowCommand = commandFactory.createRemoveCommand(tableWidgetController.getEditingDomain(), (Object)tableInstance, (Object)TablePackage.eINSTANCE.getTable_Rows(), tableInstance.getRows().get(i));
                compoundCommand.append(removeRowCommand);
            }
            ++i;
        }
        CompoundCommand updateColumnCommand = TableInstanceCommandFactory.createRemoveUselessColumnsCommand(tableWidgetController, linesToRemove);
        if (updateColumnCommand != null) {
            compoundCommand.append((Command)updateColumnCommand);
        }
        return compoundCommand;
    }

    public static CompoundCommand createRemoveUselessColumnsCommand(TableWidgetController natTableWidget, List<Integer> toBeRemoved) throws CoreException {
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        Table tableInstance = natTableWidget.getTable();
        EditingDomain editingDomain = natTableWidget.getEditingDomain();
        ArrayList<Row> rowsToRemove = new ArrayList<Row>();
        if (toBeRemoved != null) {
            for (Integer i : toBeRemoved) {
                rowsToRemove.add((Row)tableInstance.getRows().get(i.intValue()));
            }
        }
        CompoundCommand result = TableInstanceCommandFactory.createRemoveUselessColumnsCommand(tableInstance, rowsToRemove, null, commandFactory, editingDomain);
        return result;
    }

    public static CompoundCommand createRemoveUselessColumnsCommand(Table tableInstance, List<Row> rowsToRemove, List<FacetSet> nextLoadedFacetSets, ICommandFactory commandFactory, EditingDomain editingDomain) throws MultiModelQueryException {
        ArrayList<Command> commandList = new ArrayList<Command>();
        ArrayList<Row> rowsToKeep = new ArrayList<Row>((Collection<Row>)tableInstance.getRows());
        rowsToKeep.removeAll(rowsToRemove);
        EList facetSets = nextLoadedFacetSets == null ? tableInstance.getFacetSets() : nextLoadedFacetSets;
        List<FeatureColumn> columns = TableInstanceUtils.columnsToRemove(tableInstance, (List<? extends FacetSet>)facetSets, rowsToKeep);
        for (FeatureColumn column : columns) {
            DebugUtils.debug((boolean)DEBUG, (String)("column to remove: " + EcoreUtil.getURI((EObject)column.getFeature())));
            Command rmColumnCmd = commandFactory.createRemoveCommand(editingDomain, (Object)tableInstance, (Object)TablePackage.eINSTANCE.getTable_Columns(), (Object)column);
            commandList.add(rmColumnCmd);
        }
        CompoundCommand result = null;
        if (!commandList.isEmpty()) {
            result = new CompoundCommand(Messages.TableInstanceCommandFactory_removeUselessColumn, commandList);
        }
        if (DEBUG) {
            int nbCommand = result != null ? result.getCommandList().size() : 0;
            DebugUtils.debug((String)("Columns to be removed: " + nbCommand));
        }
        return result;
    }

    public static List<EStructuralFeature> getStructuralFeatures(EObject eObject, List<Facet> appliedFacets) throws FacetManagerException {
        BasicEList result = new BasicEList();
        for (Facet facet : appliedFacets) {
            if (!TableInstanceCommandFactory.isConforming(eObject, facet)) continue;
            result.addAll((Collection)facet.getFacetElements());
        }
        return result;
    }

    private static boolean isConforming(EObject eObject, Facet facet) throws FacetManagerException {
        return IFacetManagerFactory.DEFAULT.getOrCreateFacetManager((Resource)new ResourceImpl()).isConforming(eObject, facet);
    }

    public static CompoundCommand createAddRowsCommand(List<EObject> newElements, TableWidgetController natTableWidget) {
        CompoundCommand addNonFeatureColumnCommand;
        CompoundCommand compoundCommand = new CompoundCommand();
        HashSet<EPackage> alreadyDone = new HashSet<EPackage>();
        Table tableInstance = natTableWidget.getTable();
        EditingDomain editingDomain = natTableWidget.getEditingDomain();
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        ArrayList<EStructuralFeature> processedEStructuralFeatures = new ArrayList<EStructuralFeature>();
        List<EObject> tableContent = TableWidgetUtils.getElements(tableInstance);
        for (EObject eObject : newElements) {
            if (tableContent.contains(eObject)) continue;
            Row row = TableFactory.eINSTANCE.createRow();
            Command setEobjectToRowCMD = commandFactory.createSetCommand(editingDomain, (Object)row, (Object)TablePackage.eINSTANCE.getRow_Element(), (Object)eObject);
            compoundCommand.append(setEobjectToRowCMD);
            Command addRowCMD = commandFactory.createAddCommand(editingDomain, (Object)tableInstance, (Object)TablePackage.eINSTANCE.getTable_Rows(), (Object)row);
            compoundCommand.append(addRowCMD);
            for (EStructuralFeature eStructuralFeature : eObject.eClass().getEAllStructuralFeatures()) {
                if (processedEStructuralFeatures.contains(eStructuralFeature)) continue;
                processedEStructuralFeatures.add(eStructuralFeature);
                if (natTableWidget.isColumnAlreadyDeclared(eStructuralFeature)) continue;
                FeatureColumn referenceColumn = TableFactory.eINSTANCE.createFeatureColumn();
                referenceColumn.setFeature((ETypedElement)eStructuralFeature);
                Command cmd = commandFactory.createAddCommand(editingDomain, (Object)tableInstance, (Object)TablePackage.eINSTANCE.getTable_Columns(), (Object)referenceColumn);
                compoundCommand.append(cmd);
                List<Customization> localCustoms = natTableWidget.getLocalCustomizations();
                EObject container = eStructuralFeature.eContainer();
                if (container == null || !((container = container.eContainer()) instanceof EPackage) || alreadyDone.contains(container) || CustomizationUtils.findCustomizationExtendingEPackage(localCustoms, (EPackage)container) != null) continue;
                Command cmd2 = TableInstanceCommandFactory.createMetamodelViewCommand((EPackage)container, natTableWidget);
                if (cmd2.canExecute()) {
                    compoundCommand.append(cmd2);
                }
                alreadyDone.add((EPackage)container);
            }
        }
        if (!newElements.isEmpty() && (addNonFeatureColumnCommand = TableInstanceCommandFactory.createAddNonFeatureColumnIfNeeded(natTableWidget)) != null) {
            compoundCommand.append((Command)addNonFeatureColumnCommand);
        }
        return compoundCommand;
    }

    private static CompoundCommand createAddNonFeatureColumnIfNeeded(TableWidgetController natTableWidget) {
        CompoundCommand result = new CompoundCommand();
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        EditingDomain editingdomain = natTableWidget.getEditingDomain();
        Table tableInstance = natTableWidget.getTable();
        if (result.getCommandList().isEmpty()) {
            result = null;
        }
        return result;
    }

    private static Command createMetamodelViewCommand(EPackage ePackage, TableWidgetController natTableWidget) {
        CompoundCommand compoundCommand = new CompoundCommand();
        Table tableInstance = natTableWidget.getTable();
        EditingDomain editingDomain = natTableWidget.getEditingDomain();
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        ICommandFactoryResult<Customization> cmdFactoryResult = TableInstanceCommandFactory.createLocalCustom(tableInstance, editingDomain, commandFactory, ePackage);
        Customization newMetamodelView = (Customization)cmdFactoryResult.getResult();
        compoundCommand.append(cmdFactoryResult.getCommand());
        ArrayList<Customization> views = new ArrayList<Customization>();
        views.addAll((Collection<Customization>)tableInstance.getCustomizations());
        List<Customization> localCustom = natTableWidget.getLocalCustomizations();
        int i = 0;
        while (i < views.size()) {
            if (localCustom.contains(views.get(i))) break;
            ++i;
        }
        views.add(i, newMetamodelView);
        Command setMetamodelViewCmd = commandFactory.createSetCommand(editingDomain, (Object)tableInstance, (Object)TablePackage.eINSTANCE.getTable_Customizations(), views);
        compoundCommand.append(setMetamodelViewCmd);
        return compoundCommand;
    }

    public static Command createShowHideColumnCommand(TableWidgetController widgetController, List<Column> columnsToShow, List<Column> columnsToHide, boolean putOnTheTop) {
        Command cmd;
        CompoundCommand compoundCommand = new CompoundCommand("Show/hide column");
        EditingDomain editingDomain = widgetController.getEditingDomain();
        ICommandFactory commandFactory = widgetController.getCommandFactory();
        for (Column current : columnsToShow) {
            if (!(current instanceof SourceColumn) || !(cmd = commandFactory.createSetCommand(editingDomain, (Object)current, (Object)TablePackage.eINSTANCE.getSourceColumn_IsHidden(), (Object)Boolean.FALSE)).canExecute()) continue;
            compoundCommand.append(cmd);
        }
        HashSet<FeatureColumn> fColumnsToHide = new HashSet<FeatureColumn>();
        cmd = columnsToHide.iterator();
        while (cmd.hasNext()) {
            Column current = cmd.next();
            if (current instanceof FeatureColumn) {
                fColumnsToHide.add((FeatureColumn)current);
                continue;
            }
            Command cmd2 = commandFactory.createSetCommand(widgetController.getEditingDomain(), (Object)current, (Object)TablePackage.eINSTANCE.getSourceColumn_IsHidden(), (Object)Boolean.TRUE);
            compoundCommand.append(cmd2);
        }
        Command tmp = TableInstanceCommandFactory.createHideColumnCommand(widgetController, fColumnsToHide);
        if (tmp != null) {
            compoundCommand.append(tmp);
        }
        if (putOnTheTop && (cmd = TableInstanceCommandFactory.createPutLocalCustomizationOnTheTopCommand(widgetController)).canExecute()) {
            compoundCommand.append(cmd);
        }
        return compoundCommand;
    }

    public static Command createPutLocalCustomizationOnTheTopCommand(TableWidgetController natTableWidget) {
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        List<Customization> localCustoms = natTableWidget.getLocalCustomizations();
        ArrayList<Customization> customizations = new ArrayList<Customization>();
        customizations.addAll((Collection<Customization>)natTableWidget.getTable().getCustomizations());
        customizations.removeAll(localCustoms);
        customizations.addAll(0, localCustoms);
        return commandFactory.createSetCommand(natTableWidget.getEditingDomain(), (Object)natTableWidget.getTable(), (Object)TablePackage.eINSTANCE.getTable_Customizations(), customizations);
    }

    public static Command createSetFacetsCommand(List<FacetSet> facetSets, TableWidgetController natTableWidget) throws CoreException {
        return TableInstanceCommandFactory.createSetFacetsCommand(facetSets, null, natTableWidget);
    }

    public static Command createSetFacetsCommand(List<FacetSet> facetSets, List<EObject> newElements, TableWidgetController controller) throws CoreException {
        ArrayList cmdList = new ArrayList();
        ICommandFactory commandFactory = controller.getCommandFactory();
        Table tableInstance = controller.getTable();
        for (FacetSet facet : facetSets) {
            if (tableInstance.getFacetSets().contains((Object)facet)) continue;
            Iterator command = commandFactory.createAddCommand(controller.getEditingDomain(), (Object)tableInstance, (Object)TablePackage.eINSTANCE.getTable_FacetSets(), (Object)facet);
            cmdList.add(command);
        }
        ArrayList<FacetSet> newFacets = new ArrayList<FacetSet>();
        newFacets.addAll(facetSets);
        for (FacetSet facet : tableInstance.getFacetSets()) {
            if (facetSets.contains(facet)) continue;
            newFacets.add(facet);
            Command command = commandFactory.createRemoveCommand(controller.getEditingDomain(), (Object)tableInstance, (Object)TablePackage.eINSTANCE.getTable_FacetSets(), (Object)facet);
            cmdList.add(command);
        }
        CompoundCommand removeColumn = TableInstanceCommandFactory.createRemoveUselessColumnsCommand(tableInstance, Collections.<Row>emptyList(), facetSets, commandFactory, controller.getEditingDomain());
        if (removeColumn != null) {
            cmdList.add(removeColumn);
        }
        CompoundCommand compoundCommand = null;
        if (!cmdList.isEmpty()) {
            compoundCommand = new CompoundCommand(Messages.TableInstanceCommandFactory_setFacet, cmdList);
        }
        TableInstanceCommandFactory.debugCommand(compoundCommand);
        return compoundCommand;
    }

    public static CompoundCommand createDropCommand(TableWidgetController natTableWidget, IStructuredSelection structuredSelection, Object element, EStructuralFeature feature) {
        EditingDomain editingDomain = natTableWidget.getEditingDomain();
        if (editingDomain == null) {
            return null;
        }
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        CompoundCommand compoundCommand = new CompoundCommand();
        if (feature.isMany()) {
            for (Object object : structuredSelection) {
                Command addCommand = commandFactory.createAddCommand(editingDomain, element, (Object)feature, object);
                compoundCommand.append(addCommand);
            }
        } else if (structuredSelection.toList().size() == 1) {
            Object firstElement = structuredSelection.getFirstElement();
            Command addCommand = commandFactory.createSetCommand(editingDomain, element, (Object)feature, firstElement);
            compoundCommand.append(addCommand);
        }
        return compoundCommand;
    }

    public static Command createHideColumnCommand(TableWidgetController widgetController, Collection<FeatureColumn> featureColumns) {
        IsOneOfQuery conformanceQuery;
        Facet typeCustomization;
        FacetOperation isVisibleProperty = widgetController.getCustomPropertiesHandler().getIsVisible();
        CompoundCommand resultCmd = new CompoundCommand("Show/hide column");
        EditingDomain editingDomain = widgetController.getEditingDomain();
        ICommandFactory commandFactory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor(editingDomain);
        EList localCustomizations = widgetController.getTable().getLocalCustomizations();
        Customization customization = null;
        if (!localCustomizations.isEmpty()) {
            customization = (Customization)localCustomizations.get(0);
        }
        ICustomizationCommandFactory customCmdFactory = ICustomizationCommandFactoryFactory.DEFAULT.createCustomizationCommandFactory(editingDomain, (org.eclipse.emf.facet.util.emf.core.internal.exported.ICommandFactory)commandFactory);
        if (customization == null) {
            ICommandFactoryResult<Customization> cmdFactoryResult = TableInstanceCommandFactory.createLocalCustom(widgetController.getTable(), editingDomain, commandFactory, (EPackage)EcorePackage.eINSTANCE);
            customization = (Customization)cmdFactoryResult.getResult();
            resultCmd.append(cmdFactoryResult.getCommand());
        }
        if ((typeCustomization = CustomizationUtils.findFacetByExtendedMetaclass(FacetUtils.getFacets((FacetSet)customization), EcorePackage.eINSTANCE.getETypedElement())) == null) {
            conformanceQuery = QueryFactory.eINSTANCE.createIsOneOfQuery();
            ICommandFactoryResult createEClassCustom = customCmdFactory.createEClassCustomization(customization, EcorePackage.eINSTANCE.getETypedElement(), (Query)conformanceQuery);
            typeCustomization = (Facet)createEClassCustom.getResult();
            resultCmd.append(createEClassCustom.getCommand());
        } else {
            if (!(typeCustomization instanceof EClassCustomization)) {
                throw new TableWidgetRuntimeException("Unexpected type for the variable 'featureContainer'");
            }
            DerivedTypedElement conformanceTE = (DerivedTypedElement)typeCustomization.getConformanceTypedElement();
            conformanceQuery = (IsOneOfQuery)conformanceTE.getQuery();
        }
        HashSet<ETypedElement> featuresToHide = new HashSet<ETypedElement>();
        for (FeatureColumn column : featureColumns) {
            featuresToHide.add(column.getFeature());
        }
        Command initQuery = commandFactory.createSetCommand(editingDomain, (Object)conformanceQuery, (Object)QueryPackage.eINSTANCE.getIsOneOfQuery_ExpectedEObjects(), new ArrayList(featuresToHide));
        resultCmd.append(initQuery);
        FalseLiteralQuery query = QueryFactory.eINSTANCE.createFalseLiteralQuery();
        ICommandFactoryResult propConfigCmd = customCmdFactory.setPropertyConfig(typeCustomization, null, isVisibleProperty, (Query)query);
        resultCmd.append(propConfigCmd.getCommand());
        return resultCmd;
    }

    private static ICommandFactoryResult<Customization> createLocalCustom(Table tableInstance, EditingDomain editingDomain, ICommandFactory commandFactory, EPackage customizedEPackage) {
        ICustomizationCommandFactory customCmdFactory = ICustomizationCommandFactoryFactory.DEFAULT.createCustomizationCommandFactory(editingDomain, (org.eclipse.emf.facet.util.emf.core.internal.exported.ICommandFactory)commandFactory);
        CompoundCommand createCustom = new CompoundCommand("Create a local custom.");
        ICommandFactoryResult cmdFactoryResult = customCmdFactory.createCustomization("Column hiding customization for " + customizedEPackage.getName());
        Customization customization = (Customization)cmdFactoryResult.getResult();
        createCustom.append(cmdFactoryResult.getCommand());
        Command addCustomToLocalCmd = commandFactory.createAddCommand(editingDomain, (Object)tableInstance, (Object)TablePackage.eINSTANCE.getTable_LocalCustomizations(), (Object)customization);
        createCustom.append(addCustomToLocalCmd);
        Command addCustomToAllCmd = commandFactory.createAddCommand(editingDomain, (Object)tableInstance, (Object)TablePackage.eINSTANCE.getTable_Customizations(), (Object)customization);
        createCustom.append(addCustomToAllCmd);
        return ICommandFactoryResultFactory.DEFAULT.createCommandFactoryResult((Command)createCustom, (Object)customization);
    }

    private static Facet createEmptyTypeCustomization(FeatureColumn featureColumn, Map<EClassifier, Facet> typeViewMap, CompoundCommand resultCmd, EditingDomain editingDomain, ICommandFactory commandFactory, Customization customization, EClassifier featureContainer) {
        EClassCustomization typeCustomization = null;
        if (featureContainer instanceof Facet) {
            Facet facet = (Facet)featureColumn.getFeature().eContainer();
            FacetCustomization facetCustomization = CustomFactory.eINSTANCE.createFacetCustomization();
            Command linkACustomToAFacet = commandFactory.createSetCommand(editingDomain, (Object)facetCustomization, (Object)CustomPackage.eINSTANCE.getFacetCustomization_CustomizedFacet(), (Object)facet);
            resultCmd.append(linkACustomToAFacet);
            Command addFacetCustomToCustom = commandFactory.createAddCommand(editingDomain, (Object)customization, (Object)EFacetPackage.eINSTANCE.getFacet_FacetElements(), (Object)facetCustomization);
            resultCmd.append(addFacetCustomToCustom);
            typeCustomization = facetCustomization;
        } else if (featureContainer instanceof EClass) {
            EClass eClass = (EClass)featureContainer;
            EClassCustomization eClassCustomization = CustomFactory.eINSTANCE.createEClassCustomization();
            eClassCustomization.setExtendedMetaclass(eClass);
            Command linkACustomToAEClass = commandFactory.createSetCommand(editingDomain, (Object)eClassCustomization, (Object)EFacetPackage.eINSTANCE.getFacet_ExtendedMetaclass(), (Object)eClass);
            resultCmd.append(linkACustomToAEClass);
            typeCustomization = eClassCustomization;
            Command addEClassCustomToCustom = commandFactory.createAddCommand(editingDomain, (Object)customization, (Object)EFacetPackage.eINSTANCE.getFacet_FacetElements(), (Object)typeCustomization);
            resultCmd.append(addEClassCustomToCustom);
        }
        typeViewMap.put(featureContainer, (Facet)typeCustomization);
        return typeCustomization;
    }

    private TableInstanceCommandFactory() {
    }

    /*
     * WARNING - void declaration
     */
    public static Command delete(String label, Collection<? extends EObject> eObjects, TableWidgetController controller) {
        void var4_8;
        ArrayList<Command> cmdList = new ArrayList<Command>();
        for (EObject eObject : eObjects) {
            Command command = controller.getCommandFactory().createDeleteCommand(controller.getEditingDomain(), (Object)eObject);
            cmdList.add(command);
        }
        Object var4_6 = null;
        if (!cmdList.isEmpty()) {
            CompoundCommand compoundCommand = new CompoundCommand(label, cmdList);
        }
        return var4_8;
    }

    private static void debugCommand(Command command) {
        if (DEBUG) {
            if (command == null) {
                DebugUtils.debug((String)"Null command.", (int)1);
            } else {
                DebugUtils.debug((String)EmfDebugUtils.debugCommand((Command)command), (int)1);
            }
        }
    }

    public static final Command createRemoveUselessRowsAndColumnsCommand(TableWidgetController controller) {
        Command deleteRows;
        ArrayList<Object> cmdList = new ArrayList<Object>();
        List<Row> rowsToRemove = TableInstanceUtils.findUselessRow(controller.getTable());
        if (TableWidgetController.DEBUG_REMOVE_USELESS_ROWS_AND_COLUMNS) {
            DebugUtils.debug((String)("Rows to be removed: " + rowsToRemove.size()));
        }
        if ((deleteRows = TableInstanceCommandFactory.delete(Messages.TableWidgetController_DeleteUselessRows, rowsToRemove, controller)) != null) {
            cmdList.add(deleteRows);
        }
        CompoundCommand removeColumnCommand = null;
        try {
            removeColumnCommand = TableInstanceCommandFactory.createRemoveUselessColumnsCommand(controller.getTable(), rowsToRemove, null, controller.getCommandFactory(), controller.getEditingDomain());
        }
        catch (MultiModelQueryException e) {
            Logger.logWarning((Throwable)((Object)e), (Plugin)Activator.getDefault());
        }
        if (removeColumnCommand != null) {
            if (!removeColumnCommand.canExecute()) {
                throw new TableWidgetRuntimeException("Command cannot be executed");
            }
            cmdList.add(removeColumnCommand);
        }
        CompoundCommand command = null;
        if (!cmdList.isEmpty()) {
            command = new CompoundCommand(Messages.TableWidgetController_RemoveUselessRowsAndColumns, cmdList);
        }
        return command;
    }
}

