/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.custom.core.exception.CustomizationException;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.SynchronizedTableWidgetController;
import org.eclipse.emf.facet.widgets.table.ui.internal.TableWidgetController;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetViewFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.TableWidgetRuntimeException;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;

public class TableWidgetFactory
implements ITableWidgetFactory {
    private static final String CLASS = "class";
    private static final String VIEW_IMPL = "org.eclipse.emf.facet.widgets.table.ui.internal.viewimpl";
    private List<ITableWidgetViewFactory> factories = new ArrayList<ITableWidgetViewFactory>();

    public TableWidgetFactory() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(VIEW_IMPL);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configElt = iConfigurationElementArray[n4];
                try {
                    ITableWidgetViewFactory factory = (ITableWidgetViewFactory)configElt.createExecutableExtension(CLASS);
                    this.factories.add(factory);
                }
                catch (CoreException e) {
                    Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
                ++n4;
            }
            ++n2;
        }
        if (this.factories.size() == 0) {
            Logger.logError((String)"No table view factory registered.", (Plugin)Activator.getDefault());
        } else if (this.factories.size() > 1) {
            Logger.logError((String)("More than one table view factory has been registered, " + this.factories.get(0).getClass().getName() + " will be used."), (Plugin)Activator.getDefault());
        }
    }

    public ITableWidget createTableWidget(Composite parent, IEditingDomainProvider edProvider, Table tableInstance, MenuManager menuMgr) {
        TableWidgetController tableWidget;
        try {
            tableWidget = new TableWidgetController(parent, edProvider, tableInstance, menuMgr, this.factories.get(0));
        }
        catch (CustomizationException e) {
            throw new TableWidgetRuntimeException(e);
        }
        return new SynchronizedTableWidgetController(tableWidget);
    }
}

