/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.exported;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.CustomFactory;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementResult;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.EObjectQueryRow;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.NavigationTable;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.PrimitiveTypeQueryRow;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TableFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.CustomizationUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableWidgetUtils {
    private TableWidgetUtils() {
    }

    public static Table createTableInstance(List<EObject> elements, String description, TableConfiguration tableConfiguration, EObject context, Object parameter) {
        Table tableInstance = TableFactory.eINSTANCE.createTable();
        tableInstance.setTableConfiguration(tableConfiguration);
        tableInstance.setContext(context);
        tableInstance.setParameter(parameter);
        HashSet<EObject> added = new HashSet<EObject>();
        for (EObject eObject : elements) {
            if (added.contains(eObject)) continue;
            Row row = TableFactory.eINSTANCE.createRow();
            row.setElement(eObject);
            tableInstance.getRows().add((Object)row);
            added.add(eObject);
        }
        if (tableConfiguration != null) {
            for (Facet facet : tableConfiguration.getDefaultFacets()) {
                try {
                    if (tableInstance.getFacetSets().contains((Object)facet.eContainer())) continue;
                    tableInstance.getFacetSets().add((Object)((FacetSet)facet.eContainer()));
                }
                catch (Exception e) {
                    Logger.logError((String)("The referenced facet:" + facet + " could not be loaded"), (Plugin)Activator.getDefault());
                }
            }
            for (Customization custom : tableConfiguration.getDefaultCustomizations()) {
                if (tableInstance.getCustomizations().contains((Object)custom)) continue;
                tableInstance.getCustomizations().add((Object)custom);
            }
            for (Customization custom : tableConfiguration.getDefaultLocalCustomizations()) {
                if (tableInstance.getLocalCustomizations().contains((Object)custom)) continue;
                tableInstance.getLocalCustomizations().add((Object)custom);
            }
        }
        TableWidgetUtils.createColumns(tableInstance);
        tableInstance.setDescription(description);
        HashSet<Object> alreadyDone = new HashSet<Object>();
        List<EStructuralFeature> allFeatures = TableWidgetUtils.getTableInstanceEStructuralFeatures(tableInstance);
        for (EStructuralFeature structuralFeature : allFeatures) {
            EPackage ePackage;
            EObject sfContainer = structuralFeature.eContainer();
            EObject sfContainerContainer = null;
            if (sfContainer != null) {
                sfContainerContainer = sfContainer.eContainer();
            }
            if (!(sfContainerContainer instanceof EPackage) || alreadyDone.contains(ePackage = (EPackage)sfContainerContainer) || CustomizationUtils.findCustomizationExtendingEPackage((List<Customization>)tableInstance.getLocalCustomizations(), ePackage) != null) continue;
            Customization customizaion = CustomFactory.eINSTANCE.createCustomization();
            tableInstance.getLocalCustomizations().add((Object)customizaion);
            alreadyDone.add(ePackage);
        }
        for (FacetSet container : tableInstance.getFacetSets()) {
            if (!(container instanceof EPackage)) continue;
            FacetSet ePackage = container;
            if (alreadyDone.contains(container) || CustomizationUtils.findCustomizationExtendingEPackage((List<Customization>)tableInstance.getLocalCustomizations(), (EPackage)container) != null) continue;
            Customization metamodelView = CustomFactory.eINSTANCE.createCustomization();
            tableInstance.getLocalCustomizations().add((Object)metamodelView);
            alreadyDone.add(container);
        }
        tableInstance.getCustomizations().addAll(0, (Collection)tableInstance.getLocalCustomizations());
        return tableInstance;
    }

    public static NavigationTable createQueryTableInstance(List<ETypedElementResult> results, TableConfiguration tableConfiguration, EObject context, Object parameter) {
        NavigationTable queryTableInstance = TableFactory.eINSTANCE.createNavigationTable();
        queryTableInstance.getQueryResults().addAll(results);
        queryTableInstance.setTableConfiguration(tableConfiguration);
        queryTableInstance.setContext(context);
        queryTableInstance.setParameter(parameter);
        for (ETypedElementResult result : results) {
            Object resultValue = FacetUtils.getResultValue((ETypedElementResult)result);
            if (resultValue instanceof Collection) {
                Collection collection = (Collection)resultValue;
                for (Object object : collection) {
                    TableWidgetUtils.createQueryRow(queryTableInstance, result, object);
                }
                continue;
            }
            TableWidgetUtils.createQueryRow(queryTableInstance, result, resultValue);
        }
        TableWidgetUtils.createColumns((Table)queryTableInstance);
        return queryTableInstance;
    }

    private static void createQueryRow(NavigationTable queryTableInstance, ETypedElementResult result, Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (!TableWidgetUtils.getElements((Table)queryTableInstance).contains(eObject)) {
                EObjectQueryRow row = TableFactory.eINSTANCE.createEObjectQueryRow();
                row.setElement(eObject);
                row.setQueryResult(result);
                queryTableInstance.getRows().add((Object)row);
            }
        } else {
            PrimitiveTypeQueryRow row = TableFactory.eINSTANCE.createPrimitiveTypeQueryRow();
            row.setElement((EObject)result);
            row.setQueryResult(result);
            row.setValue(object);
            queryTableInstance.getRows().add((Object)row);
        }
    }

    private static void createColumns(Table tableInstance) {
        List<EStructuralFeature> features = TableWidgetUtils.getTableInstanceEStructuralFeatures(tableInstance);
        if (tableInstance instanceof NavigationTable) {
            tableInstance.getColumns().add((Object)TableFactory.eINSTANCE.createSourceColumn());
            for (Row row : tableInstance.getRows()) {
                if (!(row instanceof PrimitiveTypeQueryRow)) continue;
                tableInstance.getColumns().add((Object)TableFactory.eINSTANCE.createValueColumn());
                break;
            }
        }
        for (EStructuralFeature feature : features) {
            FeatureColumn referenceColumn = TableFactory.eINSTANCE.createFeatureColumn();
            referenceColumn.setFeature((ETypedElement)feature);
            tableInstance.getColumns().add((Object)referenceColumn);
        }
        Object resourceSet = null;
        resourceSet = tableInstance.eResource() == null ? new ResourceSetImpl() : tableInstance.eResource().getResourceSet();
        IFacetManager facetContext = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager((ResourceSet)resourceSet);
        facetContext.getManagedFacetSets().addAll(0, tableInstance.getFacetSets());
        HashSet structuralFeatures = new HashSet();
        ArrayList<Status> statusList = new ArrayList<Status>();
        for (EObject eObject : TableWidgetUtils.getElements(tableInstance)) {
            try {
                structuralFeatures.addAll(FacetUtils.getETypedElements((EObject)eObject, EStructuralFeature.class, (IFacetManager)facetContext));
            }
            catch (Exception e) {
                Status status = new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "An exception has occurred while retrieving structural features of:" + eObject, (Throwable)e);
                statusList.add(status);
            }
        }
        if (!statusList.isEmpty()) {
            MultiStatus globalStatus = new MultiStatus(Activator.getDefault().getBundle().getSymbolicName(), 0, "An exception has occurred while retrieving structural features of the eObjects", (Throwable)new Exception());
            Logger.logError((Throwable)new CoreException((IStatus)globalStatus), (Plugin)Activator.getDefault());
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Failed to load facets", (String)"Some facets failed to load. See Error Log for more details.");
        }
        for (EStructuralFeature structuralFeature : structuralFeatures) {
            FeatureColumn column = TableFactory.eINSTANCE.createFeatureColumn();
            column.setFeature((ETypedElement)structuralFeature);
            tableInstance.getColumns().add((Object)column);
        }
    }

    private static List<EStructuralFeature> getTableInstanceEStructuralFeatures(Table tableInstance) {
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        for (EObject eObject : TableWidgetUtils.getElements(tableInstance)) {
            if (eObject == null || eObject instanceof ETypedElementResult && tableInstance instanceof NavigationTable) continue;
            for (EStructuralFeature eStructuralFeature : eObject.eClass().getEAllStructuralFeatures()) {
                if (features.contains(eStructuralFeature)) continue;
                features.add(eStructuralFeature);
            }
        }
        return features;
    }

    public static List<EObject> getElements(Table tableInstance) {
        LinkedList<EObject> result = new LinkedList<EObject>();
        for (Row row : tableInstance.getRows()) {
            result.add(row.getElement());
        }
        return result;
    }

    public static Object getValueOf(IGridElement gridElement, IFacetManager context) throws FacetManagerException {
        EObject element;
        Object value = null;
        if (gridElement.getColumn() instanceof FeatureColumn && (element = gridElement.getRow().getElement()) != null) {
            FeatureColumn featureColumn = (FeatureColumn)gridElement.getColumn();
            ETypedElement eTypedElement = featureColumn.getFeature();
            if (TableWidgetUtils.hasStructuralFeature(element, eTypedElement, context)) {
                value = context.getOrInvoke(element, eTypedElement, Object.class);
            } else {
                return "\ufffd";
            }
        }
        return value;
    }

    public static boolean hasStructuralFeature(EObject eObject, ETypedElement structuralFeature, IFacetManager context) throws FacetManagerException {
        DerivedTypedElement derivedTypedElement;
        EObject eContainer;
        boolean result = false;
        EClass eClass = eObject.eClass();
        if (eClass.getEAllStructuralFeatures().contains((Object)structuralFeature)) {
            result = true;
        } else if (structuralFeature instanceof DerivedTypedElement && (eContainer = (derivedTypedElement = (DerivedTypedElement)structuralFeature).eContainer()) instanceof Facet) {
            Facet facet = (Facet)eContainer;
            result = context.isConforming(eObject, facet);
        }
        return result;
    }

    public static boolean isApplicable(IGridElement gridElement, IFacetManager context) {
        EObject element;
        boolean result = false;
        if (gridElement.getColumn() instanceof FeatureColumn && (element = gridElement.getRow().getElement()) != null) {
            FeatureColumn featureColumn = (FeatureColumn)gridElement.getColumn();
            ETypedElement eTypedElement = featureColumn.getFeature();
            try {
                if (TableWidgetUtils.hasStructuralFeature(element, eTypedElement, context)) {
                    result = true;
                }
            }
            catch (FacetManagerException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }
}

