/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.dialogs;

import java.util.List;
import org.eclipse.emf.common.ui.DiagnosticComposite;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DiagnosticDialog
extends IconAndMessageDialog {
    private Button detailsButton;
    private String title;
    private DiagnosticComposite diagnosticComposite;
    private DiagnosticComposite.TextProvider textProvider;
    private int severityMask = 65535;
    private Diagnostic diagnostic;
    private boolean shouldIncludeTopLevelDiagnostic = false;

    public static int open(Shell parent, String dialogTitle, String message, Diagnostic diagnostic) {
        return DiagnosticDialog.open(parent, dialogTitle, message, diagnostic, 7);
    }

    public static int openProblem(Shell parent, String dialogTitle, String message, Diagnostic diagnostic) {
        return DiagnosticDialog.open(parent, dialogTitle, message, diagnostic, DiagnosticComposite.ERROR_WARNING_MASK);
    }

    public static int open(Shell parentShell, String title, String message, Diagnostic diagnostic, int displayMask) {
        DiagnosticDialog dialog = new DiagnosticDialog(parentShell, title, message, diagnostic, displayMask);
        return dialog.open();
    }

    protected static boolean shouldDisplay(Diagnostic diagnostic, int mask) {
        List children = diagnostic.getChildren();
        if (children.isEmpty()) {
            return DiagnosticComposite.severityMatches(diagnostic, mask);
        }
        for (Diagnostic child : children) {
            if (!DiagnosticComposite.severityMatches(child, mask)) continue;
            return true;
        }
        return false;
    }

    public DiagnosticDialog(Shell parentShell, String dialogTitle, String message, Diagnostic diagnostic, int severityMask) {
        super(parentShell);
        this.title = dialogTitle == null ? JFaceResources.getString((String)"Problem_Occurred") : dialogTitle;
        this.message = message == null ? diagnostic.getMessage() : JFaceResources.format((String)"Reason", (Object[])new Object[]{message, diagnostic.getMessage()});
        this.diagnostic = diagnostic;
        this.severityMask = severityMask;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setTextProvider(DiagnosticComposite.TextProvider textProvider) {
        this.textProvider = textProvider;
        if (this.diagnosticComposite != null) {
            this.diagnosticComposite.setTextProvider(this.getTextProvider());
        }
    }

    public DiagnosticComposite.TextProvider getTextProvider() {
        return this.textProvider;
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.get().OK_LABEL, true);
        this.createDetailsButton(parent);
    }

    protected void createDetailsButton(Composite parent) {
        if (this.shouldShowDetailsButton()) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.get().SHOW_DETAILS_LABEL, false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(768);
        childData.horizontalSpan = 2;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected void createDialogAndButtonArea(Composite parent) {
        Composite dialogComposite;
        super.createDialogAndButtonArea(parent);
        if (this.dialogArea instanceof Composite && (dialogComposite = (Composite)this.dialogArea).getChildren().length == 0) {
            new Label(dialogComposite, 0);
        }
    }

    protected Image getImage() {
        if (this.diagnostic != null) {
            if (this.diagnostic.getSeverity() == 2) {
                return this.getWarningImage();
            }
            if (this.diagnostic.getSeverity() == 1) {
                return this.getInfoImage();
            }
        }
        return this.getErrorImage();
    }

    protected DiagnosticComposite createDiagnosticComposite(Composite parent) {
        DiagnosticComposite diagnosticComposite = new DiagnosticComposite(parent, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = 200;
        diagnosticComposite.setLayoutData(data);
        if (this.getTextProvider() != null) {
            diagnosticComposite.setTextProvider(this.getTextProvider());
        }
        diagnosticComposite.initialize(null);
        this.populate(diagnosticComposite, this.diagnostic, this.shouldIncludeTopLevelDiagnostic);
        return diagnosticComposite;
    }

    public int open() {
        if (DiagnosticDialog.shouldDisplay(this.diagnostic, this.severityMask)) {
            return super.open();
        }
        this.setReturnCode(0);
        return 0;
    }

    private void populate(DiagnosticComposite diagnosticComposite, Diagnostic diagnostic, boolean includeDiagnostic) {
        if (DiagnosticComposite.severityMatches(diagnostic, this.severityMask)) {
            diagnosticComposite.setShowRootDiagnostic(includeDiagnostic);
            diagnosticComposite.setSeverityMask(this.severityMask);
            diagnosticComposite.setDiagnostic(diagnostic);
        }
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        if (this.diagnosticComposite != null) {
            this.diagnosticComposite.dispose();
            this.diagnosticComposite = null;
            this.detailsButton.setText(IDialogConstants.get().SHOW_DETAILS_LABEL);
        } else {
            this.diagnosticComposite = this.createDiagnosticComposite((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.get().HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, newSize.y));
    }

    public boolean close() {
        this.diagnostic = null;
        this.diagnosticComposite = null;
        return super.close();
    }

    protected boolean shouldShowDetailsButton() {
        return !this.diagnostic.getChildren().isEmpty() || this.diagnostic.getException() != null;
    }

    protected final void setDiagnostic(Diagnostic diagnostic) {
        if (this.diagnostic != diagnostic) {
            this.diagnostic = diagnostic;
        }
        this.shouldIncludeTopLevelDiagnostic = true;
        if (this.diagnosticComposite != null && !this.diagnosticComposite.isDisposed()) {
            this.populate(this.diagnosticComposite, diagnostic, this.shouldIncludeTopLevelDiagnostic);
        }
    }
}

