/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.gemini.jpa.classloader.EclipseDotClasspathHelper;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveBase;
import org.eclipse.persistence.jpa.Archive;
import org.osgi.framework.Bundle;

public class BundleArchive
extends ArchiveBase
implements Archive {
    protected Bundle bundle = null;
    protected EclipseDotClasspathHelper pdeClasspathHelper = new EclipseDotClasspathHelper();
    private Logger logger;
    protected Integer pathPrefixSize = null;

    public BundleArchive(URL rootUrl, Map properties, String descriptorLocation) throws MalformedURLException {
        this(rootUrl, properties, descriptorLocation, Logger.global);
    }

    public BundleArchive(URL rootUrl, Map properties, String descriptorLocation, Logger logger) throws MalformedURLException {
        super(rootUrl, descriptorLocation);
        this.bundle = (Bundle)properties.get("org.eclipse.gemini.jpa.bundle");
        logger.entering("BundleArchive", "BundleArchive " + rootUrl);
        this.logger = logger;
        this.descriptorLocation = descriptorLocation;
        logger.logp(Level.FINER, "BundleArchive", "BundleArchive", "rootURL = {0}", this.rootURL);
    }

    public Iterator<String> getEntries() {
        Enumeration entries = null;
        String binPath = this.pdeClasspathHelper.getBinPath(this.bundle);
        if (binPath != null) {
            entries = this.bundle.findEntries(binPath, "*.class", true);
            this.pathPrefixSize = binPath.length() + 2;
        } else {
            entries = this.bundle.findEntries(".", "*.class", true);
            this.pathPrefixSize = 3;
        }
        ArrayList<String> result = new ArrayList<String>();
        while (entries.hasMoreElements()) {
            URL bundleEntry = (URL)entries.nextElement();
            try {
                URI bundleUri = bundleEntry.toURI();
                result.add(this.trimClassName(bundleUri.getPath()));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return result.iterator();
    }

    protected String trimClassName(String path) {
        return path.substring(this.pathPrefixSize);
    }

    public InputStream getEntry(String entryPath) throws IOException {
        InputStream is = null;
        URL entry = this.bundle.getEntry(entryPath);
        if (entry != null) {
            is = entry.openStream();
        }
        return is;
    }

    public URL getEntryAsURL(String entryPath) throws IOException {
        return this.bundle.getEntry(entryPath);
    }

    public void close() {
    }
}

