/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.properties.extended;

import java.text.MessageFormat;
import org.eclipse.gmf.runtime.common.ui.services.properties.extended.ExtendedPropertyDescriptor;
import org.eclipse.gmf.runtime.common.ui.services.properties.internal.l10n.CommonUIServicesPropertiesMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ExtendedTextPropertyDescriptor
extends ExtendedPropertyDescriptor {
    public ExtendedTextPropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        if (this.isReadOnly()) {
            return null;
        }
        TextCellEditor editor = new TextCellEditor(parent){

            protected void editOccured(ModifyEvent e) {
                String value = this.text.getText();
                if (value == null) {
                    value = "";
                }
                String typedValue = value;
                boolean oldValidState = this.isValueValid();
                boolean newValidState = this.isCorrect(typedValue);
                if (typedValue != null || newValidState) {
                    // empty if block
                }
                if (!newValidState) {
                    this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), value));
                }
                this.valueChanged(oldValidState, newValidState);
            }

            protected void keyReleaseOccured(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b') {
                    this.fireCancelEditor();
                    return;
                }
                if (keyEvent.character == '\r') {
                    String value = this.text.getText();
                    if (value == null) {
                        value = "";
                    }
                    boolean newValidState = this.isCorrect(value);
                    if (value != null || newValidState) {
                        // empty if block
                    }
                    if (!newValidState) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)CommonUIServicesPropertiesMessages.ExtendedTextPropertyDescriptor_PropertiesViewErrorDialog_Title, (String)this.getErrorMessage());
                        this.fireCancelEditor();
                    } else {
                        this.fireApplyEditorValue();
                        this.deactivate();
                    }
                    return;
                }
            }
        };
        editor.setValidator(this.getValidator());
        return editor;
    }
}

