/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.actions.ui;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.Messages;
import org.eclipse.gmt.modisco.java.actions.DiscoveryParametersBean;
import org.eclipse.gmt.modisco.java.io.library.LibraryReaderOptions;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class JavaWizardFirstPage
extends WizardPage {
    private static final int COLUMN_USE_SOURCE_WIDTH = 120;
    private static final int COLUMN_DEPENDENCY_SHORTNAME_WIDTH = 400;
    private static final int COLUMN_DEPENDENCY_LONGNAME_WIDTH = 200;
    private Button btnMemberAnalyseJavaFiles;
    private Button btnFullAnalyseJavaFiles;
    private CheckboxTreeViewer dependenciesTree;
    private IJavaProject javaProject;
    private Button btnUseSource;
    private Button btnIncrementalMode;
    private Label textNumberElementsSelected;
    private Collection<Object> discoverableElements;
    private DiscoveryParametersBean discoveryParameters;
    private Text elementsToExcludeFilter;
    private Text elementsToIncludeFilter;
    private Button btnAnalyzeAllFilter;
    private Button btnExcludeFilter;
    private Button btnIncludeFilter;
    public static final String PATH_WIZARD_IMAGE = "icons/ModelWizardBanner.png";

    public JavaWizardFirstPage(IJavaProject javaProject, String pageName, Collection<Object> discoverableElements, DiscoveryParametersBean discoveryParameters) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(Messages.JavaWizardFirstPage_settingsLabel);
        this.setImageDescriptor(JavaActivator.getImageDescriptor(PATH_WIZARD_IMAGE));
        this.setJavaProject(javaProject);
        this.setDiscoverableElements(discoverableElements);
        this.setDiscoveryParameters(discoveryParameters);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout formLayout = new GridLayout();
        composite.setLayout((Layout)formLayout);
        this.createDependenciesPanel(composite);
        this.createIncrementalPanel(composite);
        this.createJavaAnalysisLevelPanel(composite);
        this.createJavaFilterPanel(composite);
        this.refreshInformationLabel();
        this.validatePage();
        this.setControl((Control)composite);
    }

    private void createDependenciesPanel(Composite composite) {
        Group dependencies = new Group(composite, 0);
        dependencies.setText(Messages.JavaWizardFirstPage_dependencies);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dependencies.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        dependencies.setLayoutData((Object)gridData);
        Label l = new Label((Composite)dependencies, 0);
        l.setText(Messages.JavaWizardFirstPage_selectProjects);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        l.setLayoutData((Object)gridData);
        this.setDependenciesTree(new CheckboxTreeViewer((Composite)dependencies, 68356));
        this.getDependenciesTree().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (JavaWizardFirstPage.this.getDiscoveryParameters().getElementsToDiscover().contains(element)) {
                    JavaWizardFirstPage.this.getDiscoveryParameters().removeElementToDiscover(element);
                } else {
                    JavaWizardFirstPage.this.getDiscoveryParameters().addElementToDiscover(element);
                }
                JavaWizardFirstPage.this.getDependenciesTree().update(event.getElement(), null);
                JavaWizardFirstPage.this.refreshBtnUseSources();
                JavaWizardFirstPage.this.refreshInformationLabel();
                JavaWizardFirstPage.this.validatePage();
            }
        });
        this.getDependenciesTree().getTree().setLinesVisible(false);
        this.getDependenciesTree().getTree().setHeaderVisible(true);
        TreeViewerColumn column1 = new TreeViewerColumn((TreeViewer)this.getDependenciesTree(), 0);
        column1.getColumn().setWidth(400);
        column1.getColumn().setText(Messages.JavaWizardFirstPage_name);
        column1.setLabelProvider((CellLabelProvider)new JDTDelegateCellLabelProvider(true));
        TreeViewerColumn column2 = new TreeViewerColumn((TreeViewer)this.getDependenciesTree(), 0);
        column2.getColumn().setWidth(120);
        column2.getColumn().setText(Messages.JavaWizardFirstPage_useSources);
        column2.getColumn().setAlignment(0x1000000);
        column2.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Map<String, Object> options;
                boolean useSources;
                if (cell.getElement() instanceof IPackageFragmentRoot && JavaWizardFirstPage.this.getDiscoveryParameters().getElementsToDiscover().contains(cell.getElement()) && (useSources = Boolean.TRUE.equals((options = JavaWizardFirstPage.this.getDiscoveryParameters().getDiscoveryOptions(cell.getElement())).get(LibraryReaderOptions.USE_SOURCES.toString())))) {
                    cell.setText(Messages.JavaWizardFirstPage_useSourceOn);
                    return;
                }
                cell.setText("");
            }
        });
        TreeViewerColumn column3 = new TreeViewerColumn((TreeViewer)this.getDependenciesTree(), 0);
        column3.getColumn().setWidth(200);
        column3.getColumn().setText(Messages.JavaWizardFirstPage_Path);
        column3.setLabelProvider((CellLabelProvider)new JDTDelegateCellLabelProvider(false));
        this.getDependenciesTree().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                JavaWizardFirstPage.this.refreshBtnUseSources();
            }
        });
        gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.getDependenciesTree().getTree().setLayoutData((Object)gridData);
        this.configureButtonSource(dependencies);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.btnUseSource.setLayoutData((Object)gridData);
        this.getDependenciesTree().setContentProvider((IContentProvider)new MyTreeContentProvider());
        this.getDependenciesTree().setInput(new Object());
        TreeItem[] treeItemArray = this.getDependenciesTree().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeitem = treeItemArray[n2];
            this.recursiveCheckItem(treeitem);
            ++n2;
        }
        Composite cLabels = new Composite((Composite)dependencies, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        cLabels.setLayoutData((Object)gridData);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        cLabels.setLayout((Layout)rowLayout);
        Label imageInformationNumberElementsSelected = new Label(cLabels, 0);
        imageInformationNumberElementsSelected.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
        this.textNumberElementsSelected = new Label(cLabels, 0);
    }

    private void configureButtonSource(Group dependencies) {
        this.btnUseSource = new Button((Composite)dependencies, 32);
        this.btnUseSource.setText(Messages.JavaWizardFirstPage_useSources);
        this.btnUseSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object elt;
                if (JavaWizardFirstPage.this.getDependenciesTree().getTree().getSelection().length == 1 && (elt = JavaWizardFirstPage.this.getDependenciesTree().getTree().getSelection()[0].getData()) != null && elt instanceof IPackageFragmentRoot) {
                    Map<String, Object> options = JavaWizardFirstPage.this.getDiscoveryParameters().getDiscoveryOptions(elt);
                    boolean useSource = Boolean.TRUE.equals(options.get(LibraryReaderOptions.USE_SOURCES.toString()));
                    options.put(LibraryReaderOptions.USE_SOURCES.toString(), new Boolean(!useSource));
                    JavaWizardFirstPage.this.getDependenciesTree().update(elt, null);
                }
                JavaWizardFirstPage.this.refreshBtnUseSources();
            }
        });
        this.btnUseSource.setSelection(false);
        this.btnUseSource.setEnabled(false);
    }

    private void createIncrementalPanel(Composite composite) {
        Group mode = new Group(composite, 0);
        mode.setText(Messages.JavaWizardFirstPage_mode);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        mode.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        mode.setLayoutData((Object)gridData);
        this.setBtnIncrementalMode(new Button((Composite)mode, 32));
        this.getBtnIncrementalMode().setText(Messages.JavaWizardFirstPage_useIncremental);
        this.getBtnIncrementalMode().setSelection(this.getDiscoveryParameters().isIncrementalMode());
        this.getBtnIncrementalMode().setEnabled(true);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.getBtnIncrementalMode().setLayoutData((Object)gridData);
        this.getBtnIncrementalMode().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaWizardFirstPage.this.getDiscoveryParameters().setIncrementalMode(JavaWizardFirstPage.this.getBtnIncrementalMode().getSelection());
            }
        });
    }

    private void createJavaAnalysisLevelPanel(Composite composite) {
        Group analysisLevel = new Group(composite, 0);
        analysisLevel.setText(Messages.JavaWizardFirstPage_analysisLevel);
        GridLayout myLayout = new GridLayout();
        myLayout.numColumns = 1;
        analysisLevel.setLayout((Layout)myLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        analysisLevel.setLayoutData((Object)gridData);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaWizardFirstPage.this.getDiscoveryParameters().setFullJavaLevel(JavaWizardFirstPage.this.getBtnFullAnalyseJavaFiles().getSelection());
            }
        };
        this.setBtnFullAnalyseJavaFiles(new Button((Composite)analysisLevel, 16));
        this.getBtnFullAnalyseJavaFiles().setText(Messages.JavaWizardFirstPage_fullAnalysis);
        this.getBtnFullAnalyseJavaFiles().setLayoutData((Object)new GridData());
        this.getBtnFullAnalyseJavaFiles().setSelection(this.getDiscoveryParameters().isFullJavaLevel());
        this.getBtnFullAnalyseJavaFiles().addSelectionListener((SelectionListener)listener);
        this.btnMemberAnalyseJavaFiles = new Button((Composite)analysisLevel, 16);
        this.btnMemberAnalyseJavaFiles.setText(Messages.JavaWizardFirstPage_limitedAnalysis);
        this.btnMemberAnalyseJavaFiles.setLayoutData((Object)new GridData());
        this.btnMemberAnalyseJavaFiles.addSelectionListener((SelectionListener)listener);
        this.btnMemberAnalyseJavaFiles.setSelection(!this.getDiscoveryParameters().isFullJavaLevel());
    }

    private void recursiveCheckItem(TreeItem treeitem) {
        if (this.getDiscoveryParameters().getElementsToDiscover().contains(treeitem.getData())) {
            treeitem.setChecked(true);
            if (treeitem.getData() == this.getJavaProject()) {
                treeitem.setExpanded(true);
            }
            this.getDependenciesTree().refresh(treeitem.getData());
        }
        TreeItem[] treeItemArray = treeitem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            this.recursiveCheckItem(child);
            ++n2;
        }
    }

    private void createJavaFilterPanel(Composite composite) {
        Group filter = new Group(composite, 0);
        filter.setText(Messages.JavaWizardFirstPage_filter);
        GridLayout myLayout = new GridLayout();
        myLayout.numColumns = 1;
        filter.setLayout((Layout)myLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        filter.setLayoutData((Object)gridData);
        ModifyListener fieldListener = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                JavaWizardFirstPage.this.validatePage();
            }
        };
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaWizardFirstPage.this.getElementsToExcludeFilter().setEnabled(JavaWizardFirstPage.this.isButtonExcludeFilterSelected());
                JavaWizardFirstPage.this.getElementsToIncludeFilter().setEnabled(JavaWizardFirstPage.this.isButtonIncludeFilterSelected());
                JavaWizardFirstPage.this.validatePage();
            }
        };
        this.btnAnalyzeAllFilter = new Button((Composite)filter, 16);
        this.btnAnalyzeAllFilter.setText(Messages.JavaWizardFirstPage_analyseAllElements0);
        this.btnAnalyzeAllFilter.setLayoutData((Object)new GridData());
        this.btnAnalyzeAllFilter.addSelectionListener((SelectionListener)buttonListener);
        this.btnExcludeFilter = new Button((Composite)filter, 16);
        this.btnExcludeFilter.setText(Messages.JavaWizardFirstPage_excludedElements);
        this.btnExcludeFilter.setLayoutData((Object)new GridData());
        this.btnExcludeFilter.addSelectionListener((SelectionListener)buttonListener);
        this.elementsToExcludeFilter = new Text((Composite)filter, 2052);
        this.elementsToExcludeFilter.setLayoutData((Object)gridData);
        this.elementsToExcludeFilter.addModifyListener(fieldListener);
        this.btnIncludeFilter = new Button((Composite)filter, 16);
        this.btnIncludeFilter.setText(Messages.JavaWizardFirstPage_JavaWizardFirstPage_includedElements);
        this.btnIncludeFilter.setLayoutData((Object)new GridData());
        this.btnIncludeFilter.addSelectionListener((SelectionListener)buttonListener);
        this.elementsToIncludeFilter = new Text((Composite)filter, 2052);
        this.elementsToIncludeFilter.setLayoutData((Object)gridData);
        this.elementsToIncludeFilter.addModifyListener(fieldListener);
        if (this.getDiscoveryParameters().getExcludedElementsRegEx() != null) {
            this.btnExcludeFilter.setSelection(true);
            this.btnIncludeFilter.setSelection(false);
            this.btnAnalyzeAllFilter.setSelection(false);
            this.getElementsToExcludeFilter().setEnabled(true);
            this.getElementsToExcludeFilter().setText(this.getDiscoveryParameters().getExcludedElementsRegEx());
            this.getElementsToIncludeFilter().setEnabled(false);
        } else if (this.getDiscoveryParameters().getIncludedElementsRegEx() != null) {
            this.btnExcludeFilter.setSelection(false);
            this.btnIncludeFilter.setSelection(true);
            this.btnAnalyzeAllFilter.setSelection(false);
            this.getElementsToIncludeFilter().setEnabled(true);
            this.getElementsToIncludeFilter().setText(this.getDiscoveryParameters().getIncludedElementsRegEx());
            this.getElementsToExcludeFilter().setEnabled(false);
        } else {
            this.btnAnalyzeAllFilter.setSelection(true);
            this.btnExcludeFilter.setSelection(false);
            this.btnIncludeFilter.setSelection(false);
            this.getElementsToIncludeFilter().setEnabled(false);
            this.getElementsToExcludeFilter().setEnabled(false);
        }
    }

    protected boolean isButtonExcludeFilterSelected() {
        return this.btnExcludeFilter.getSelection();
    }

    protected boolean isButtonIncludeFilterSelected() {
        return this.btnIncludeFilter.getSelection();
    }

    void refreshBtnUseSources() {
        IStructuredSelection selection = (IStructuredSelection)this.getDependenciesTree().getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot lib = (IPackageFragmentRoot)element;
            if (this.getDiscoveryParameters().getElementsToDiscover().contains(lib)) {
                Map<String, Object> options = this.getDiscoveryParameters().getDiscoveryOptions(lib);
                boolean useSources = Boolean.TRUE.equals(options.get(LibraryReaderOptions.USE_SOURCES.toString()));
                if (useSources) {
                    this.btnUseSource.setEnabled(true);
                    this.btnUseSource.setSelection(true);
                    return;
                }
                boolean hasSourceAttached = false;
                try {
                    hasSourceAttached = lib.getSourceAttachmentPath() != null;
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                this.btnUseSource.setSelection(false);
                this.btnUseSource.setEnabled(hasSourceAttached);
                return;
            }
        }
        this.btnUseSource.setEnabled(false);
        this.btnUseSource.setSelection(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    void validatePage() {
        String text;
        TreeItem[] treeItemArray = this.getDependenciesTree().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeitem = treeItemArray[n2];
            if (treeitem.getData() == this.getJavaProject() && !treeitem.getChecked()) {
                this.setErrorMessage(Messages.JavaWizardFirstPage_firstProjectSelection);
                this.setPageComplete(false);
                return;
            }
            ++n2;
        }
        if (this.isButtonExcludeFilterSelected()) {
            text = this.getElementsToExcludeFilter().getText().trim();
            if (text.length() <= 0) {
                this.setErrorMessage(Messages.JavaWizardFirstPage_regExpExcludedElementsNecessary0);
                this.setPageComplete(false);
                return;
            }
            this.getDiscoveryParameters().setExcludedElementsRegEx(text);
            this.getDiscoveryParameters().setIncludedElementsRegEx(null);
        } else if (this.isButtonIncludeFilterSelected()) {
            text = this.getElementsToIncludeFilter().getText().trim();
            if (text.length() <= 0) {
                this.setErrorMessage(Messages.JavaWizardFirstPage_regExpIncludedElementsNecessary0);
                this.setPageComplete(false);
                return;
            }
            this.getDiscoveryParameters().setIncludedElementsRegEx(text);
            this.getDiscoveryParameters().setExcludedElementsRegEx(null);
        } else {
            this.getDiscoveryParameters().setIncludedElementsRegEx(null);
            this.getDiscoveryParameters().setExcludedElementsRegEx(null);
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
    }

    void refreshInformationLabel() {
        int nbProjectsSelected = 0;
        int nbLibrariesSelected = 0;
        Object[] objectArray = this.getDependenciesTree().getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IJavaProject) {
                ++nbProjectsSelected;
            } else if (element instanceof IPackageFragmentRoot) {
                ++nbLibrariesSelected;
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(nbProjectsSelected);
        if (nbProjectsSelected > 1) {
            sb.append(Messages.JavaWizardFirstPage_projects);
        } else {
            sb.append(Messages.JavaWizardFirstPage_project);
        }
        sb.append(Messages.JavaWizardFirstPage_and);
        sb.append(nbLibrariesSelected);
        if (nbLibrariesSelected > 1) {
            sb.append(Messages.JavaWizardFirstPage_libraries);
        } else {
            sb.append(Messages.JavaWizardFirstPage_library);
        }
        sb.append(Messages.JavaWizardFirstPage_selected);
        this.textNumberElementsSelected.setText(sb.toString());
        this.textNumberElementsSelected.pack(true);
    }

    public void setDiscoverableElements(Collection<Object> discoverableElements) {
        this.discoverableElements = discoverableElements;
    }

    public Collection<Object> getDiscoverableElements() {
        return this.discoverableElements;
    }

    public void setJavaProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void setDiscoveryParameters(DiscoveryParametersBean discoveryParameters) {
        this.discoveryParameters = discoveryParameters;
    }

    public DiscoveryParametersBean getDiscoveryParameters() {
        return this.discoveryParameters;
    }

    public void setDependenciesTree(CheckboxTreeViewer dependenciesTree) {
        this.dependenciesTree = dependenciesTree;
    }

    public CheckboxTreeViewer getDependenciesTree() {
        return this.dependenciesTree;
    }

    public void setBtnIncrementalMode(Button btnIncrementalMode) {
        this.btnIncrementalMode = btnIncrementalMode;
    }

    public Button getBtnIncrementalMode() {
        return this.btnIncrementalMode;
    }

    public void setBtnFullAnalyseJavaFiles(Button btnFullAnalyseJavaFiles) {
        this.btnFullAnalyseJavaFiles = btnFullAnalyseJavaFiles;
    }

    public Button getBtnFullAnalyseJavaFiles() {
        return this.btnFullAnalyseJavaFiles;
    }

    public Text getElementsToExcludeFilter() {
        return this.elementsToExcludeFilter;
    }

    public Text getElementsToIncludeFilter() {
        return this.elementsToIncludeFilter;
    }

    class JDTDelegateCellLabelProvider
    extends ColumnLabelProvider {
        private final JavaElementLabelProvider delegate = new JavaElementLabelProvider();
        private boolean displayShortName = true;

        public JDTDelegateCellLabelProvider(boolean displayShortName) {
            this.displayShortName = displayShortName;
        }

        public void addListener(ILabelProviderListener listener) {
            this.delegate.addListener(listener);
        }

        public void dispose() {
            this.delegate.dispose();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public Image getImage(Object element) {
            if (this.displayShortName) {
                return this.delegate.getImage(element);
            }
            return null;
        }

        public String getText(Object element) {
            String qualifiedName = this.delegate.getText(element);
            int lastSegmentindex = qualifiedName.lastIndexOf(File.separator);
            String text = null;
            text = this.displayShortName ? qualifiedName.substring(lastSegmentindex + 1) : (lastSegmentindex > -1 ? qualifiedName.substring(0, lastSegmentindex) : "");
            return text;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.delegate.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.delegate.removeListener(listener);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    class MyTreeContentProvider
    implements ITreeContentProvider {
        MyTreeContentProvider() {
        }

        public Object[] getChildren(Object element) {
            LinkedHashSet<IPackageFragmentRoot> libraries = new LinkedHashSet<IPackageFragmentRoot>();
            if (element instanceof IJavaProject) {
                for (Object tmp : JavaWizardFirstPage.this.getDiscoverableElements()) {
                    IPackageFragmentRoot lib;
                    if (!(tmp instanceof IPackageFragmentRoot) || !(lib = (IPackageFragmentRoot)tmp).getJavaProject().equals(element)) continue;
                    libraries.add(lib);
                }
            }
            return libraries.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof IPackageFragmentRoot) {
                return ((IPackageFragmentRoot)element).getJavaProject();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IJavaProject;
        }

        public Object[] getElements(Object inputElement) {
            LinkedHashSet<IJavaProject> projects = new LinkedHashSet<IJavaProject>();
            projects.add(JavaWizardFirstPage.this.getJavaProject());
            for (Object element : JavaWizardFirstPage.this.getDiscoverableElements()) {
                if (!(element instanceof IJavaProject)) continue;
                projects.add((IJavaProject)element);
            }
            return projects.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

