/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.chess.diagram;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.examples.mm.chess.Square;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.tb.BorderDecorator;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.util.IColorConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChessToolBehaviorProvider
extends DefaultToolBehaviorProvider {
    private List<Square> allowedSquaresForMove = new ArrayList<Square>();

    public ChessToolBehaviorProvider(IDiagramTypeProvider diagramTypeProvider) {
        super(diagramTypeProvider);
    }

    public boolean isShowGuides() {
        return false;
    }

    public IDecorator[] getDecorators(PictogramElement pe) {
        Object object = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (object instanceof Square && this.allowedSquaresForMove.contains(object)) {
            BorderDecorator decorator = new BorderDecorator();
            decorator.setBorderColor(IColorConstant.ORANGE);
            decorator.setBorderWidth(Integer.valueOf(2));
            return new IDecorator[]{decorator};
        }
        return super.getDecorators(pe);
    }

    public void addToAllowedSquaresForMove(List<Square> squares) {
        this.allowedSquaresForMove.addAll(squares);
    }

    public void clearAllowedSquaresForMove() {
        this.allowedSquaresForMove.clear();
    }
}

