/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common.outline.tree;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.graphiti.examples.common.util.uiprovider.TwoObjectsContainer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractGraphicsTreeEditPart
extends AbstractTreeEditPart {
    private Map<TwoObjectsContainer, Image> _imageRegistry = new HashMap<TwoObjectsContainer, Image>();
    public static final String TEXT_TYPE_DEFAULT = null;
    public static final String ARRAY_TEXT_START = "[";
    public static final String ARRAY_TEXT_END = "]";
    public static final String ARRAY_TEXT_SEPARATOR = "; ";
    public static final String TUPLE_TEXT_END = ")";
    public static final String TUPLE_TEXT_SEPARATOR = ", ";
    public static final String TUPLE_TEXT_START = "(";

    public AbstractGraphicsTreeEditPart(Object model) {
        super(model);
    }

    protected Image getImage() {
        Image result = this.getImage(this.getModel(), null);
        return result;
    }

    protected String getText() {
        String text = this.getText(this.getModel(), TEXT_TYPE_DEFAULT);
        return text == null ? "" : text;
    }

    protected void addAllElementsIfNotNull(List<Object> resultList, Collection<?> collection) {
        for (Object element : collection) {
            if (element == null) continue;
            resultList.add(element);
        }
    }

    private String getText(Object element, Object textType) {
        StringBuffer result;
        EClass eObject;
        EObject casted;
        if (element instanceof EObject && (casted = (EObject)element) != null && casted.eResource() != null && (eObject = casted.eClass()) instanceof EClass && eObject.eResource() != null) {
            EClass eClass = eObject;
            String className = eClass.getName();
            return String.valueOf(className) + " (" + casted.toString() + TUPLE_TEXT_END;
        }
        if (element == null) {
            return "";
        }
        if (element instanceof Collection) {
            Collection collection = (Collection)element;
            return this.getText(collection.toArray(), textType);
        }
        if (element.getClass().isArray()) {
            StringBuffer result2 = new StringBuffer();
            result2.append(ARRAY_TEXT_START);
            boolean afterFirstElement = false;
            int i = 0;
            while (i < Array.getLength(element)) {
                if (afterFirstElement) {
                    result2.append(ARRAY_TEXT_SEPARATOR);
                }
                Object next = Array.get(element, i);
                result2.append(this.getText(next, textType));
                afterFirstElement = true;
                ++i;
            }
            result2.append(ARRAY_TEXT_END);
            return result2.toString();
        }
        if (element instanceof Rectangle) {
            casted = (Rectangle)element;
            result = new StringBuffer();
            result.append(TUPLE_TEXT_START);
            result.append(casted.x).append(TUPLE_TEXT_SEPARATOR).append(casted.y).append(TUPLE_TEXT_SEPARATOR).append(casted.width).append(TUPLE_TEXT_SEPARATOR).append(casted.height);
            result.append(TUPLE_TEXT_END);
            return result.toString();
        }
        if (element instanceof Point) {
            casted = (Point)element;
            result = new StringBuffer();
            result.append(TUPLE_TEXT_START);
            result.append(casted.x).append(TUPLE_TEXT_SEPARATOR).append(casted.y);
            result.append(TUPLE_TEXT_END);
            return result.toString();
        }
        return element.toString();
    }

    private Image getImage(Object element, Object imageType) {
        if (element != null) {
            ImageDescriptor descriptor = this.getImageDescriptor(element, imageType);
            TwoObjectsContainer container = new TwoObjectsContainer(descriptor, imageType);
            if (descriptor != null) {
                Image image = this.getImageRegistry().get(container);
                if (image == null) {
                    image = descriptor.createImage();
                    this.getImageRegistry().put(container, image);
                }
                return image;
            }
        }
        return null;
    }

    private ImageDescriptor getImageDescriptor(Object element, Object imageType) {
        return null;
    }

    private Map<TwoObjectsContainer, Image> getImageRegistry() {
        return this._imageRegistry;
    }
}

