/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.cloud.internal;

import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.admin.ui.cloud.internal.NodeBrowserContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public final class NodeBrowserComparator
extends ViewerComparator {
    private SortIndex index = SortIndex.ID;
    private boolean reverse;

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof NodeBrowserContentProvider.NodeItem && e2 instanceof NodeBrowserContentProvider.NodeItem) {
            return this.compareNodes((NodeBrowserContentProvider.NodeItem)e1, (NodeBrowserContentProvider.NodeItem)e2);
        }
        return super.compare(viewer, e1, e2);
    }

    private int compareNodes(NodeBrowserContentProvider.NodeItem n1, NodeBrowserContentProvider.NodeItem n2) {
        String t1 = StringUtils.trimToEmpty((String)this.getText(n1));
        String t2 = StringUtils.trimToEmpty((String)this.getText(n2));
        if (this.isReverse()) {
            return this.getComparator().compare(t2, t1);
        }
        return this.getComparator().compare(t1, t2);
    }

    public SortIndex getIndex() {
        return this.index != null ? this.index : SortIndex.ID;
    }

    private String getText(NodeBrowserContentProvider.NodeItem node) {
        switch (this.getIndex()) {
            case LOCATION: {
                return node.getDescriptor().getLocation();
            }
            case STATUS: {
                return node.isApproved() ? (node.isOnline() ? "A1" : "A2") : (node.isOnline() ? "P1" : "P2");
            }
        }
        return node.getDescriptor().getId();
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setIndex(SortIndex index) {
        this.index = index;
        this.reverse = false;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public static enum SortIndex {
        ID,
        LOCATION,
        STATUS;

    }
}

