/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields;

import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IUploadAdapter;
import org.eclipse.rwt.widgets.DialogCallback;
import org.eclipse.rwt.widgets.DialogUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class UploadDialogField
extends DialogField {
    private String uploadButtonLabel;
    private Button uploadControl;
    private final IUploadAdapter uploadAdapter;
    private final boolean multipleFilesUpload;

    protected static GridData gridDataForUpload(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    public UploadDialogField(IUploadAdapter uploadAdapter, boolean multipleFilesUpload) {
        this.uploadAdapter = uploadAdapter;
        this.multipleFilesUpload = multipleFilesUpload;
        this.uploadButtonLabel = "Upload...";
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)UploadDialogField.gridDataForLabel(1));
        Button upload = this.getUploadControl(parent);
        upload.setLayoutData((Object)UploadDialogField.gridDataForUpload(nColumns - 1));
        return new Control[]{label, upload};
    }

    void doOpenUploadDialog() {
        final FileDialog fileDialog = this.multipleFilesUpload ? new FileDialog(SwtUtil.getShell((Widget)this.uploadControl), 34) : new FileDialog(SwtUtil.getShell((Widget)this.uploadControl), 32);
        fileDialog.setText("Upload Files");
        fileDialog.setAutoUpload(true);
        DialogUtil.open((Dialog)fileDialog, (DialogCallback)new DialogCallback(){

            public void dialogClosed(int returnCode) {
                UploadDialogField.this.uploadAdapter.uploadFinished(fileDialog.getFileNames());
            }
        });
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    public Button getUploadControl(Composite parent) {
        if (this.uploadControl == null) {
            this.assertCompositeNotNull(parent);
            this.uploadControl = new Button(parent, 8);
            this.uploadControl.setText(this.uploadButtonLabel);
            this.uploadControl.setFont(parent.getFont());
            this.uploadControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UploadDialogField.this.doOpenUploadDialog();
                }
            });
        }
        return this.uploadControl;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.isOkToUse((Control)this.uploadControl);
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this.uploadControl)) {
            this.uploadControl.setFocus();
        }
        return true;
    }

    public void setUploadButtonLabel(String uploadButtonLabel) {
        this.uploadButtonLabel = uploadButtonLabel;
        if (this.isOkToUse((Control)this.uploadControl)) {
            this.uploadControl.setText(uploadButtonLabel);
        }
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.uploadControl)) {
            this.uploadControl.setEnabled(this.isEnabled());
        }
    }
}

