/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.app;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.application.ApplicationException;
import org.eclipse.gyrex.http.jetty.internal.JettyDebug;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ScopedHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ApplicationDelegateHandler
extends ScopedHandler {
    private static final String MDC_KEY_CONTEXT_PATH = "gyrex.contextPath";
    private static final String MDC_KEY_APPLICATION_ID = "gyrex.applicationId";
    private static final String MDC_KEY_REQUEST_REMOTE_HOST = "req.remoteHost";
    private static final String MDC_KEY_REQUEST_USER_AGENT_MDC_KEY = "req.userAgent";
    private static final String MDC_KEY_REQUEST_REQUEST_URI = "req.requestURI";
    private static final String MDC_KEY_REQUEST_REQUEST_URL = "req.requestURL";
    private static final String MDC_KEY_REQUEST_QUERY_STRING = "req.queryString";
    private static final String MDC_KEY_REQUEST_X_FORWARDED_FOR = "req.xForwardedFor";
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationDelegateHandler.class);
    private final ApplicationHandler applicationHandler;

    public ApplicationDelegateHandler(ApplicationHandler applicationHandler) {
        this.applicationHandler = applicationHandler;
    }

    private void clearMdc() {
        MDC.remove((String)MDC_KEY_APPLICATION_ID);
        MDC.remove((String)MDC_KEY_CONTEXT_PATH);
        MDC.remove((String)MDC_KEY_REQUEST_REMOTE_HOST);
        MDC.remove((String)MDC_KEY_REQUEST_REQUEST_URI);
        MDC.remove((String)MDC_KEY_REQUEST_QUERY_STRING);
        MDC.remove((String)MDC_KEY_REQUEST_REQUEST_URL);
        MDC.remove((String)MDC_KEY_REQUEST_USER_AGENT_MDC_KEY);
        MDC.remove((String)MDC_KEY_REQUEST_X_FORWARDED_FOR);
    }

    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.nextHandle(target, baseRequest, request, response);
    }

    /*
     * Exception decompiling
     */
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean handleApplicationRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Request baseRequest = Request.getRequest((HttpServletRequest)request);
        if (baseRequest == null) {
            throw new IllegalStateException("Please ensure that this method is called within the request thread!");
        }
        try {
            String target = baseRequest.getPathInfo();
            if (JettyDebug.handlers) {
                LOG.debug("got request back from application {}, continue processing with Jetty handler chain (using target '{}')", (Object)this.applicationHandler.getApplication(), (Object)target);
            }
            if (target == null || !target.startsWith("/")) {
                throw new ApplicationException(String.format("Unable to handle request. It seems the specified request is invalid (path info '%s'). At least an absolute path info is necessary in order to determine the request target within the registered application servlets and resources.", StringUtils.trimToEmpty((String)target)));
            }
            this.nextScope(target, baseRequest, (HttpServletRequest)baseRequest, response);
        }
        catch (ServletException e) {
            throw new ApplicationException((Throwable)e);
        }
        return baseRequest.isHandled();
    }

    private void setupMdc(Application application, HttpServletRequest request) {
        MDC.put((String)MDC_KEY_APPLICATION_ID, (String)application.getId());
        MDC.put((String)MDC_KEY_CONTEXT_PATH, (String)application.getContext().getContextPath().toString());
        MDC.put((String)MDC_KEY_REQUEST_REMOTE_HOST, (String)request.getRemoteHost());
        MDC.put((String)MDC_KEY_REQUEST_REQUEST_URI, (String)request.getRequestURI());
        StringBuffer requestURL = request.getRequestURL();
        if (requestURL != null) {
            MDC.put((String)MDC_KEY_REQUEST_REQUEST_URL, (String)requestURL.toString());
        }
        MDC.put((String)MDC_KEY_REQUEST_QUERY_STRING, (String)request.getQueryString());
        MDC.put((String)MDC_KEY_REQUEST_USER_AGENT_MDC_KEY, (String)request.getHeader("User-Agent"));
        MDC.put((String)MDC_KEY_REQUEST_X_FORWARDED_FOR, (String)request.getHeader("X-Forwarded-For"));
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append(((Object)((Object)this)).getClass().getSimpleName());
        string.append("[");
        try {
            string.append(this.applicationHandler.getApplication().getId());
        }
        catch (Exception e) {
            string.append(e.toString());
        }
        string.append("]");
        return string.toString();
    }
}

