/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.lang.time.DateFormatUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.manager.JobHistoryImpl;
import org.eclipse.gyrex.jobs.internal.manager.JobHistoryItemImpl;
import org.eclipse.gyrex.jobs.internal.manager.JobHistoryStore;
import org.eclipse.gyrex.jobs.internal.manager.JobImpl;
import org.eclipse.gyrex.jobs.internal.manager.JobManagerImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleManagerImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleStore;
import org.eclipse.gyrex.jobs.schedules.ISchedule;
import org.eclipse.gyrex.jobs.schedules.IScheduleEntry;
import org.kohsuke.args4j.Argument;
import org.osgi.service.prefs.BackingStoreException;

public class LsCmd
extends Command {
    @Argument(index=0, usage="specify what to list (schedules, jobs or providers)", required=true, metaVar="WHAT")
    String what;
    @Argument(index=1, usage="an optional filter string", required=false, metaVar="FILTER")
    String searchString;

    public LsCmd() {
        super("<schedules|providers|running|waiting|all|job> [<filterString>] - lists schedules or jobs");
    }

    protected void doExecute() throws Exception {
        if (StringUtils.isBlank((String)this.what)) {
            this.printf("ERROR: please specify what to list", new Object[0]);
            return;
        }
        if (StringUtils.startsWithIgnoreCase((String)"providers", (String)this.what)) {
            this.printProviders();
        } else if (StringUtils.startsWithIgnoreCase((String)"schedules", (String)this.what)) {
            this.printSchedules();
        } else if (StringUtils.startsWithIgnoreCase((String)"running", (String)this.what)) {
            this.printJobs(JobState.RUNNING);
        } else if (StringUtils.startsWithIgnoreCase((String)"waiting", (String)this.what)) {
            this.printJobs(JobState.WAITING);
        } else if (StringUtils.startsWithIgnoreCase((String)"all", (String)this.what)) {
            this.printJobs(null);
        } else if (StringUtils.startsWithIgnoreCase((String)"job", (String)this.what)) {
            this.printJobs(null);
        }
    }

    private SortedSet<String> getJobIds(JobState state) throws BackingStoreException {
        String[] storageIds = JobHistoryStore.getJobsNode().childrenNames();
        if (state == null) {
            return new TreeSet<String>(Arrays.asList(storageIds));
        }
        TreeSet<String> jobIds = new TreeSet<String>();
        String[] stringArray = storageIds;
        int n = storageIds.length;
        int n2 = 0;
        while (n2 < n) {
            String storageId = stringArray[n2];
            if (StringUtils.equals((String)JobHistoryStore.getJobsNode().node(storageId).get("status", null), (String)state.name())) {
                jobIds.add(storageId);
            }
            ++n2;
        }
        return jobIds;
    }

    private void printJob(JobImpl job) throws Exception {
        StrBuilder info = new StrBuilder();
        info.appendln(job.getId());
        info.append("                    type: ").appendln(job.getTypeId());
        info.append("                   state: ").appendln((Object)job.getState());
        info.append("         last start time: ").appendln(job.getLastStart() > -1L ? DateFormatUtils.formatUTC((long)job.getLastStart(), (String)"yyyy-MM-dd 'at' HH:mm:ss z") : "never");
        info.append(" last successfull finish: ").appendln(job.getLastSuccessfulFinish() > -1L ? DateFormatUtils.formatUTC((long)job.getLastSuccessfulFinish(), (String)"yyyy-MM-dd 'at' HH:mm:ss z") : "never");
        info.append("             last result: ").appendln(job.getLastResult() != null ? job.getLastResult().getMessage() : "(not available)");
        IEclipsePreferences historyNode = JobHistoryStore.getJobsHistoryNode();
        if (historyNode.nodeExists(job.getStorageKey())) {
            IEclipsePreferences jobHistory = JobHistoryStore.getHistoryNode(job.getStorageKey());
            String[] childrenNames = jobHistory.childrenNames();
            TreeSet<JobHistoryItemImpl> entries = new TreeSet<JobHistoryItemImpl>();
            String[] stringArray = childrenNames;
            int n = childrenNames.length;
            int n2 = 0;
            while (n2 < n) {
                String entryId = stringArray[n2];
                entries.add(JobHistoryImpl.readItem(jobHistory.node(entryId)));
                ++n2;
            }
            info.appendNewLine();
            for (JobHistoryItemImpl entry : entries) {
                info.appendln(entry.toString());
            }
        }
        this.printf("%s", new Object[]{info.toString()});
    }

    private void printJobs(JobState state) throws Exception {
        SortedSet<String> storageIds = this.getJobIds(state);
        if (StringUtils.isNotBlank((String)this.searchString) && IdHelper.isValidId((String)this.searchString)) {
            for (String storageId : storageIds) {
                JobImpl job;
                String externalId = JobManagerImpl.getExternalId(storageId);
                if (!StringUtils.equals((String)this.searchString, (String)externalId) || (job = JobManagerImpl.readJob(externalId, JobHistoryStore.getJobsNode().node(storageId))) == null) continue;
                this.printJob(job);
                return;
            }
        }
        boolean found = false;
        for (String storageId : storageIds) {
            String externalId = JobManagerImpl.getExternalId(storageId);
            if (!StringUtils.isBlank((String)this.searchString) && !StringUtils.contains((String)storageId, (String)this.searchString)) continue;
            this.printf("%s (storage key %s)", new Object[]{externalId, storageId});
            found = true;
        }
        if (!found) {
            if (state != null) {
                this.printf("no %s jobs found", new Object[]{state.name()});
            } else {
                this.printf("no jobs found", new Object[0]);
            }
            return;
        }
    }

    private void printProviders() {
        TreeSet<String> providers = new TreeSet<String>(JobsActivator.getInstance().getJobProviderRegistry().getProviders());
        for (String id : providers) {
            if (!StringUtils.isBlank((String)this.searchString) && !StringUtils.contains((String)id, (String)this.searchString)) continue;
            this.printf(id, new Object[0]);
        }
    }

    private void printSchedule(ISchedule schedule) {
        StrBuilder info = new StrBuilder();
        info.append(schedule.getId());
        if (!schedule.isEnabled()) {
            info.appendln(" DISABLED");
        }
        TimeZone timeZone = schedule.getTimeZone();
        info.append("  time zone: ").append(timeZone.getDisplayName(false, 1, Locale.US)).appendln(timeZone.useDaylightTime() ? " (will adjust to daylight changes)" : " (independent of daylight changes)");
        info.append("      queue: ").appendln(schedule.getQueueId() != null ? schedule.getQueueId() : "(default)");
        String prefix = "    entries: ";
        List<IScheduleEntry> entries = schedule.getEntries();
        if (!entries.isEmpty()) {
            for (IScheduleEntry entry : entries) {
                info.append(prefix).append(entry.getId()).append(' ').append(entry.getCronExpression()).append(' ').append(entry.getJobTypeId()).appendNewLine();
                prefix = "             ";
                Map<String, String> parameter = entry.getJobParameter();
                if (parameter.isEmpty()) continue;
                Set<Map.Entry<String, String>> entrySet = parameter.entrySet();
                for (Map.Entry<String, String> param : entrySet) {
                    info.append(prefix).append("    ").append(param.getKey()).append('=').appendln(param.getValue());
                }
            }
        } else {
            info.append(prefix).appendln("(none)");
        }
        this.printf("%s", new Object[]{info.toString()});
    }

    private void printSchedules() throws Exception {
        TreeSet<String> storageIds = new TreeSet<String>(Arrays.asList(ScheduleStore.getSchedules()));
        if (StringUtils.isNotBlank((String)this.searchString)) {
            for (String storageId : storageIds) {
                ScheduleImpl schedule;
                String externalId = ScheduleManagerImpl.getExternalId(storageId);
                if (!StringUtils.equals((String)this.searchString, (String)externalId) || (schedule = ScheduleStore.load(storageId, externalId, false)) == null) continue;
                this.printSchedule(schedule);
                return;
            }
        }
        boolean found = false;
        for (String storageId : storageIds) {
            String externalId = ScheduleManagerImpl.getExternalId(storageId);
            if (!StringUtils.isBlank((String)this.searchString) && !StringUtils.contains((String)storageId, (String)this.searchString)) continue;
            this.printf("%s (storage key %s)", new Object[]{externalId, storageId});
            found = true;
        }
        if (!found) {
            this.printf("No schedules found!", new Object[0]);
        }
    }
}

