/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.scheduler;

import java.text.ParseException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.scheduler.Scheduler;
import org.eclipse.gyrex.jobs.internal.scheduler.SchedulingJob;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleManagerImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleStore;
import org.eclipse.gyrex.jobs.schedules.IScheduleEntry;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.impl.SchedulerRepository;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schedule
implements IEclipsePreferences.IPreferenceChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(Schedule.class);
    private final String scheduleStoreStorageKey;
    private ScheduleImpl scheduleData;
    private org.quartz.Scheduler quartzScheduler;

    public static String asQuartzCronExpression(String cronExpression) {
        return "0 " + cronExpression;
    }

    public Schedule(String scheduleStoreStorageKey, Scheduler scheduler) throws Exception {
        this.scheduleStoreStorageKey = scheduleStoreStorageKey;
    }

    synchronized void activateEngine() {
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Activating schedule {}...", (Object)this.getScheduleStoreStorageKey());
        }
        if (this.quartzScheduler != null) {
            return;
        }
        try {
            System.setProperty("org.terracotta.quartz.skipUpdateCheck", "true");
            DirectSchedulerFactory factory = DirectSchedulerFactory.getInstance();
            SimpleThreadPool threadPool = new SimpleThreadPool(1, 5);
            threadPool.setInstanceId(this.getScheduleStoreStorageKey());
            threadPool.setInstanceName(this.getScheduleStoreStorageKey());
            RAMJobStore jobStore = new RAMJobStore();
            factory.createScheduler(this.getScheduleStoreStorageKey(), this.getScheduleStoreStorageKey(), (ThreadPool)threadPool, (JobStore)jobStore);
            this.quartzScheduler = factory.getScheduler(this.getScheduleStoreStorageKey());
            this.refreshSchedule();
            this.quartzScheduler.start();
            LOG.info("Activated schedule {}.", (Object)this.getScheduleStoreStorageKey());
        }
        catch (SchedulerException e) {
            LOG.error("Unable to activate Quarz scheduler. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            this.quietShutdown();
        }
    }

    synchronized void deactivateEngine() {
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Deactivating Quartz engine {}...", (Object)this.getScheduleStoreStorageKey());
        }
        this.quietShutdown();
    }

    private ScheduleImpl ensureScheduleData(boolean forceReload) {
        if (this.scheduleData == null || forceReload) {
            try {
                this.scheduleData = ScheduleStore.load(this.scheduleStoreStorageKey, ScheduleManagerImpl.getExternalId(this.scheduleStoreStorageKey), true);
                return this.scheduleData;
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Unable to load schedule '%s'. %s", this.scheduleStoreStorageKey, e.getMessage()), e);
            }
        }
        return this.scheduleData;
    }

    public String getScheduleStoreStorageKey() {
        return this.scheduleStoreStorageKey;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("enabled".equals(event.getKey())) {
            boolean activate = StringUtils.equals((String)Boolean.toString(Boolean.TRUE), (String)((String)event.getNewValue()));
            try {
                if (activate) {
                    this.activateEngine();
                } else {
                    this.deactivateEngine();
                }
            }
            catch (Exception e) {
                if (activate) {
                    LOG.error("Error activating schedule '{}'. {}", new Object[]{event.getNode().name(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                } else {
                    LOG.error("Error deactivating schedule '{}'. {}", new Object[]{event.getNode().name(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                }
                this.quietShutdown();
            }
        }
    }

    private synchronized void quietShutdown() {
        if (this.quartzScheduler != null) {
            try {
                this.quartzScheduler.shutdown();
                LOG.info("Deactivated schedule {}.", (Object)this.getScheduleStoreStorageKey());
            }
            catch (Exception exception) {}
            try {
                SchedulerRepository.getInstance().remove(this.getScheduleStoreStorageKey());
                if (JobsDebug.schedulerEngine) {
                    LOG.debug("Successful removal of Quartz engine {} from scheduler repo.", (Object)this.getScheduleStoreStorageKey());
                }
            }
            catch (Exception exception) {}
            this.quartzScheduler = null;
        }
    }

    private synchronized void refreshSchedule() throws SchedulerException {
        String[] jobGroupNames = this.quartzScheduler.getJobGroupNames();
        if (jobGroupNames != null) {
            String[] stringArray = jobGroupNames;
            int n = jobGroupNames.length;
            int n2 = 0;
            while (n2 < n) {
                String groupName = stringArray[n2];
                String[] stringArray2 = this.quartzScheduler.getJobNames(groupName);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String jobName = stringArray2[n4];
                    if (JobsDebug.schedulerEngine) {
                        LOG.debug("Removing job {} from Quartz engine {}...", (Object)jobName, (Object)this.getScheduleStoreStorageKey());
                    }
                    this.quartzScheduler.deleteJob(jobName, groupName);
                    ++n4;
                }
                ++n2;
            }
        }
        List<IScheduleEntry> entries = this.ensureScheduleData(Boolean.FALSE).getEntries();
        for (IScheduleEntry entry : entries) {
            JobDetail detail = new JobDetail(entry.getId(), SchedulingJob.class);
            detail.getJobDataMap().putAll(entry.getJobParameter());
            detail.getJobDataMap().put("gyrex.job.type", entry.getJobTypeId());
            detail.getJobDataMap().put("gyrex.job.id", entry.getJobId());
            detail.getJobDataMap().put("gyrex.job.enabled", entry.isEnabled());
            detail.getJobDataMap().put("gyrex.job.contextPath", this.ensureScheduleData(Boolean.FALSE).getContextPath().toString());
            detail.getJobDataMap().put("gyrex.job.scheduleId", this.ensureScheduleData(Boolean.FALSE).getId());
            detail.getJobDataMap().put("gyrex.job.scheduleEntryId", entry.getId());
            String cronExpression = entry.getCronExpression();
            CronTrigger trigger = new CronTrigger(entry.getId());
            trigger.setTimeZone(this.ensureScheduleData(Boolean.FALSE).getTimeZone());
            try {
                trigger.setCronExpression(Schedule.asQuartzCronExpression(cronExpression));
            }
            catch (ParseException e) {
                LOG.error("Unable to schedule entry {}. Invalid cron expression. {}", (Object)entry, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
            if (JobsDebug.schedulerEngine) {
                LOG.debug("Adding job {} to Quartz engine {}...", (Object)entry, (Object)this.getScheduleStoreStorageKey());
            }
            this.quartzScheduler.scheduleJob(detail, (Trigger)trigger);
        }
    }

    public void start() throws Exception {
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Starting schedule {}...", (Object)this.getScheduleStoreStorageKey());
        }
        if (!ScheduleStore.getSchedulesNode().nodeExists(this.scheduleStoreStorageKey)) {
            throw new IllegalStateException(String.format("Schedule '%s' not found", this.scheduleStoreStorageKey));
        }
        IEclipsePreferences node = (IEclipsePreferences)ScheduleStore.getSchedulesNode().node(this.scheduleStoreStorageKey);
        node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        if (this.ensureScheduleData(Boolean.TRUE).isEnabled()) {
            this.activateEngine();
        } else if (JobsDebug.schedulerEngine) {
            LOG.debug("Schedule {} is disabled.", (Object)this.getScheduleStoreStorageKey());
        }
    }

    public void stop() {
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Stopping schedule {}...", (Object)this.getScheduleStoreStorageKey());
        }
        this.deactivateEngine();
        try {
            if (ScheduleStore.getSchedulesNode().nodeExists(this.scheduleStoreStorageKey)) {
                IEclipsePreferences node = (IEclipsePreferences)ScheduleStore.getSchedulesNode().node(this.scheduleStoreStorageKey);
                node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            }
        }
        catch (Exception exception) {}
    }
}

