/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.schedules;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.internal.scheduler.Schedule;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.schedules.IScheduleEntry;
import org.eclipse.gyrex.jobs.schedules.manager.IScheduleEntryWorkingCopy;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.quartz.CronExpression;

public class ScheduleEntryImpl
implements IScheduleEntry,
IScheduleEntryWorkingCopy {
    private static final String PARAMETER = "parameter";
    private static final String JOB_TYPE_ID = "jobTypeId";
    private static final String CRON_EXPRESSION = "cronExpression";
    private static final String ENABLED = "enabled";
    private final String id;
    private final ScheduleImpl schedule;
    private boolean enabled;
    private String cronExpression;
    private String jobTypeId;
    private Map<String, String> jobParamater;

    public ScheduleEntryImpl(String id, ScheduleImpl schedule) {
        this.schedule = schedule;
        if (!IdHelper.isValidId((String)id)) {
            throw new IllegalArgumentException("invalid entry id");
        }
        this.id = id;
        this.enabled = true;
    }

    @Override
    public String getCronExpression() {
        return this.cronExpression;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getJobId() {
        return this.schedule.getId().concat("__entry__").concat(this.id);
    }

    @Override
    public Map<String, String> getJobParameter() {
        if (this.jobParamater != null) {
            return Collections.unmodifiableMap(this.jobParamater);
        }
        return Collections.emptyMap();
    }

    @Override
    public String getJobTypeId() {
        return this.jobTypeId;
    }

    public ScheduleImpl getSchedule() {
        return this.schedule;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    void load(Preferences node) throws BackingStoreException {
        try {
            this.setCronExpression(node.get(CRON_EXPRESSION, null));
            this.setJobTypeId(node.get(JOB_TYPE_ID, null));
            this.setEnabled(node.getBoolean(ENABLED, true));
            if (node.nodeExists(PARAMETER)) {
                Preferences paramNode = node.node(PARAMETER);
                String[] keys = paramNode.keys();
                this.jobParamater = new HashMap<String, String>(keys.length);
                String[] stringArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    this.jobParamater.put(key, paramNode.get(key, null));
                    ++n2;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new BackingStoreException(String.format("Unable to load entry '%s'. %s", this.id, e.getMessage()), (Throwable)e);
        }
    }

    void saveWithoutFlush(Preferences node) throws BackingStoreException {
        this.setJobTypeId(this.jobTypeId);
        this.setCronExpression(this.cronExpression);
        node.put(CRON_EXPRESSION, this.cronExpression);
        node.put(JOB_TYPE_ID, this.jobTypeId);
        node.putBoolean(ENABLED, this.enabled);
        if (this.jobParamater != null && !this.jobParamater.isEmpty()) {
            Preferences paramNode = node.node(PARAMETER);
            String[] stringArray = paramNode.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (StringUtils.isBlank((String)this.jobParamater.get(key))) {
                    paramNode.remove(key);
                }
                ++n2;
            }
            for (String key : this.jobParamater.keySet()) {
                String value = this.jobParamater.get(key);
                if (!StringUtils.isNotBlank((String)value)) continue;
                paramNode.put(key, value);
            }
        } else if (node.nodeExists(PARAMETER)) {
            node.node(PARAMETER).removeNode();
        }
    }

    @Override
    public void setCronExpression(String cronExpression) {
        if (!CronExpression.isValidExpression((String)Schedule.asQuartzCronExpression(cronExpression))) {
            try {
                new CronExpression(Schedule.asQuartzCronExpression(cronExpression));
                throw new IllegalArgumentException("invalid cron expression");
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("error parsing cron expression: " + e.getMessage(), e);
            }
        }
        this.cronExpression = cronExpression;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setJobParameter(Map<String, String> jobParameter) {
        this.jobParamater = jobParameter != null ? new HashMap<String, String>(jobParameter) : null;
    }

    @Override
    public void setJobTypeId(String jobTypeId) {
        if (!IdHelper.isValidId((String)jobTypeId)) {
            throw new IllegalArgumentException("invalid type id");
        }
        this.jobTypeId = jobTypeId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ScheduleEntryImpl [id=").append(this.id).append(", cronExpression=").append(this.cronExpression).append(", jobProviderId=").append(this.jobTypeId).append(", jobParamater=").append(this.jobParamater).append("]");
        return builder.toString();
    }
}

