/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.logback.config.internal;

import java.io.File;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.gyrex.boot.internal.logback.LogbackConfigurator;
import org.eclipse.gyrex.common.internal.applications.BaseApplication;
import org.eclipse.gyrex.logback.config.internal.LogbackConfigActivator;
import org.eclipse.gyrex.logback.config.internal.LogbackConfigGenerator;
import org.eclipse.gyrex.logback.config.internal.PreferenceBasedLogbackConfigStore;
import org.eclipse.gyrex.logback.config.internal.model.LogbackConfig;
import org.eclipse.gyrex.preferences.CloudScope;
import org.eclipse.gyrex.server.Platform;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackConfigApplication
extends BaseApplication
implements IApplication,
IEclipsePreferences.IPreferenceChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(LogbackConfigApplication.class);
    private static final String PREF_LAST_MODIFIED = "lastModified";
    private static final String PREF_NODE_CONFIG = "config";

    protected void doStart(Map arguments) throws Exception {
        CloudScope.INSTANCE.getNode("org.eclipse.gyrex.logback.config").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.reloadConfig();
    }

    protected Object doStop() {
        CloudScope.INSTANCE.getNode("org.eclipse.gyrex.logback.config").removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.resetConfig();
        return EXIT_OK;
    }

    private File generateConfig(LogbackConfig config) {
        return new LogbackConfigGenerator(this.getLastModified(), this.getParentFolder(), config).generateConfig();
    }

    private LogbackConfig getConfig() throws BackingStoreException {
        IEclipsePreferences node = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.logback.config");
        if (node.nodeExists(PREF_NODE_CONFIG)) {
            return new PreferenceBasedLogbackConfigStore().loadConfig(node.node(PREF_NODE_CONFIG));
        }
        return null;
    }

    private long getLastModified() {
        return CloudScope.INSTANCE.getNode("org.eclipse.gyrex.logback.config").getLong(PREF_LAST_MODIFIED, 0L);
    }

    protected Logger getLogger() {
        return LOG;
    }

    private File getParentFolder() {
        return Platform.getStateLocation((Bundle)LogbackConfigActivator.getInstance().getBundle()).append("logback.xml").toFile();
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (StringUtils.equals((String)event.getKey(), (String)PREF_LAST_MODIFIED)) {
            Job reloadJob = new Job("Reload Logback Config"){

                protected IStatus run(IProgressMonitor monitor) {
                    LogbackConfigApplication.this.reloadConfig();
                    return Status.OK_STATUS;
                }
            };
            reloadJob.schedule(2000L);
        }
    }

    void reloadConfig() {
        File configFile;
        if (this.getLastModified() == 0L) {
            LOG.debug("No Logback configuration ever saved. Nothing to load.");
            return;
        }
        try {
            LogbackConfig config = this.getConfig();
            if (config == null) {
                LOG.debug("No Logback configuration available. Nothing to load.");
                return;
            }
            if (!config.getAppenders().isEmpty()) {
                LOG.debug("Generating Logback configuration file.");
                configFile = this.generateConfig(config);
            } else {
                LOG.debug("Disabling cloud Logback configuration due to missing appenders.");
                configFile = null;
            }
        }
        catch (Exception e) {
            LOG.error("Exception while generating new Logback configuration. Aborting re-configuration. {}", (Object)ExceptionUtils.getRootCause((Throwable)e), (Object)e);
            return;
        }
        File oldFile = LogbackConfigurator.setLogConfigurationFile((File)configFile);
        try {
            LogbackConfigurator.configureDefaultContext();
        }
        catch (Exception e) {
            System.err.printf("Error applying new Logback configuration (%s). Reverting to previous one (%s).%n", configFile, oldFile);
            e.printStackTrace(System.err);
            LogbackConfigurator.setLogConfigurationFile((File)oldFile);
            try {
                LogbackConfigurator.configureDefaultContext();
            }
            catch (Exception revertException) {
                System.err.printf("Error reverting Logback configuration (to %s). Trying reset.%n", oldFile);
                revertException.printStackTrace(System.err);
                try {
                    LogbackConfigurator.reset();
                }
                catch (Exception resetException) {
                    System.err.println("Error resetting Logback configuration. Logging won't work as expected. ");
                    resetException.printStackTrace(System.err);
                }
            }
        }
    }

    private void resetConfig() {
        LogbackConfigurator.setLogConfigurationFile(null);
        try {
            LogbackConfigurator.configureDefaultContext();
        }
        catch (Exception e) {
            System.err.println("Error restoring default Logback configuration. Trying reset.");
            e.printStackTrace(System.err);
            try {
                LogbackConfigurator.reset();
            }
            catch (Exception resetException) {
                System.err.println("Error resetting Logback configuration. Logging won't work as expected. ");
                resetException.printStackTrace(System.err);
            }
        }
    }
}

