/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.logback.config.internal;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.eclipse.gyrex.logback.config.internal.model.LogbackConfig;

public class LogbackConfigGenerator {
    private final long lastModified;
    private final File parentFolder;
    private final LogbackConfig config;

    public LogbackConfigGenerator(long lastModified, File parentFolder, LogbackConfig config) {
        this.lastModified = lastModified;
        this.parentFolder = parentFolder;
        this.config = config;
    }

    public File generateConfig() {
        if (!this.parentFolder.isDirectory() && !this.parentFolder.mkdirs()) {
            throw new IllegalStateException(String.format("Unable to create configs directory (%s).", this.parentFolder));
        }
        File configFile = new File(this.parentFolder, String.format("logback.%s.xml", DateFormatUtils.format((long)this.lastModified, (String)"yyyyMMdd-HHmmssSSS")));
        BufferedOutputStream outputStream = null;
        XMLStreamWriter xmlStreamWriter = null;
        try {
            try {
                outputStream = new BufferedOutputStream(FileUtils.openOutputStream((File)configFile));
                XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
                xmlStreamWriter = outputFactory.createXMLStreamWriter(outputStream, "UTF-8");
                try {
                    Class<?> clazz = this.getClass().getClassLoader().loadClass("com.sun.xml.internal.txw2.output.IndentingXMLStreamWriter");
                    xmlStreamWriter = (XMLStreamWriter)clazz.getConstructor(XMLStreamWriter.class).newInstance(xmlStreamWriter);
                }
                catch (Exception exception) {}
                this.config.toXml(xmlStreamWriter);
                xmlStreamWriter.flush();
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Unable to create config file (%s).", ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
            }
            catch (XMLStreamException e) {
                throw new IllegalStateException(String.format("Error writing config (%s).", ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
            }
        }
        catch (Throwable throwable) {
            if (xmlStreamWriter != null) {
                try {
                    xmlStreamWriter.close();
                }
                catch (Exception exception) {}
            }
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        if (xmlStreamWriter != null) {
            try {
                xmlStreamWriter.close();
            }
            catch (Exception exception) {}
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        this.removeOldFiles(this.parentFolder);
        return configFile;
    }

    private void removeOldFiles(File parentFolder) {
        File[] files = parentFolder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    FileUtils.deleteQuietly((File)file);
                }
                ++n2;
            }
            files = parentFolder.listFiles();
            if (files != null && files.length > 5) {
                Arrays.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        return o2.getName().compareTo(o1.getName());
                    }
                });
                int i = 5;
                while (i < files.length) {
                    FileUtils.deleteQuietly((File)files[i]);
                    ++i;
                }
            }
        }
    }
}

