/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.logback.config.internal.model;

import ch.qos.logback.classic.Level;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Logger {
    private String name;
    private Level level;
    private List<String> appenderReferences;
    private boolean inheritOtherAppenders = true;

    public List<String> getAppenderReferences() {
        if (this.appenderReferences == null) {
            this.appenderReferences = new ArrayList<String>();
        }
        return this.appenderReferences;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInheritOtherAppenders() {
        return this.inheritOtherAppenders;
    }

    public void setAppenderReferences(List<String> appenders) {
        this.appenderReferences = appenders;
    }

    public void setInheritOtherAppenders(boolean inheritOtherAppenders) {
        this.inheritOtherAppenders = inheritOtherAppenders;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void toXml(XMLStreamWriter writer) throws XMLStreamException {
        List<String> appenderRefs = this.getAppenderReferences();
        if (appenderRefs.isEmpty()) {
            writer.writeEmptyElement("logger");
        } else {
            writer.writeStartElement("logger");
        }
        writer.writeAttribute("name", this.getName());
        writer.writeAttribute("level", this.getLevel().toString());
        if (!this.isInheritOtherAppenders()) {
            writer.writeAttribute("additivity", Boolean.FALSE.toString());
        }
        for (String appenderRef : appenderRefs) {
            writer.writeEmptyElement("appender-ref");
            writer.writeAttribute("ref", appenderRef);
        }
        if (!appenderRefs.isEmpty()) {
            writer.writeEndElement();
        }
    }
}

